/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.arboriculture.ITree;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.config.ForestryBlock;
import forestry.core.utils.Utils;
import forestry.core.utils.Vect;
import forestry.farming.logic.CropBlock;
import forestry.plugins.PluginArboriculture;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FarmableGE
implements IFarmable {
    @Override
    public boolean isSaplingAt(World world, int x, int y, int z) {
        if (world.func_147437_c(x, y, z)) {
            return false;
        }
        return ForestryBlock.saplingGE.isBlockEqual(world, x, y, z);
    }

    @Override
    public ICrop getCropAt(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block.isAir((IBlockAccess)world, x, y, z) || !block.isWood((IBlockAccess)world, x, y, z)) {
            return null;
        }
        return new CropBlock(world, block, world.func_72805_g(x, y, z), new Vect(x, y, z));
    }

    @Override
    public boolean plantSaplingAt(ItemStack germling, World world, int x, int y, int z) {
        return germling.func_77946_l().func_77943_a(Utils.getForestryPlayer(world, x, y, z), world, x, y - 1, z, 1, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        ITree tree = PluginArboriculture.treeInterface.getMember(itemstack);
        return tree != null;
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }
}

