/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Vect;
import forestry.farming.logic.CropBlock;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FarmableStacked
implements IFarmable {
    Block block;
    int matureHeight;

    public FarmableStacked(Block block, int matureHeight) {
        this.block = block;
        this.matureHeight = matureHeight;
    }

    @Override
    public boolean isSaplingAt(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == this.block;
    }

    @Override
    public ICrop getCropAt(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y + (this.matureHeight - 1), z) != this.block) {
            return null;
        }
        return new CropBlock(world, this.block, 0, new Vect(x, y + (this.matureHeight - 1), z));
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return StackUtils.equals(this.block, itemstack);
    }

    @Override
    public boolean plantSaplingAt(ItemStack germling, World world, int x, int y, int z) {
        return world.func_147465_d(x, y, z, this.block, 0, 2);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }
}

