/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.items;

import forestry.api.core.ForestryAPI;
import forestry.api.core.Tabs;
import forestry.api.lepidopterology.IButterfly;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.interfaces.IErrorSource;
import forestry.core.interfaces.IHintSource;
import forestry.core.items.ItemInventoried;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.AlyzerInventory;
import forestry.plugins.PluginLepidopterology;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemFlutterlyzer
extends ItemInventoried {
    public ItemFlutterlyzer() {
        this.func_77625_d(1);
        this.func_77637_a(Tabs.tabLepidopterology);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (Proxies.common.isSimulating(world)) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.FlutterlyzerGUI.ordinal(), world, (int)entityplayer.field_70165_t, (int)entityplayer.field_70163_u, (int)entityplayer.field_70161_v);
        }
        return itemstack;
    }

    public static class FlutterlyzerInventory
    extends AlyzerInventory
    implements IErrorSource,
    IHintSource {
        public FlutterlyzerInventory(EntityPlayer player) {
            super(ItemFlutterlyzer.class, 7);
            this.player = player;
        }

        public FlutterlyzerInventory(EntityPlayer player, ItemStack itemStack) {
            super(ItemFlutterlyzer.class, 7, itemStack);
            this.player = player;
        }

        private boolean isEnergy(ItemStack itemstack) {
            if (itemstack == null || itemstack.field_77994_a <= 0) {
                return false;
            }
            return ForestryItem.honeyDrop.isItemEqual(itemstack) || ForestryItem.honeydew.isItemEqual(itemstack);
        }

        private void tryAnalyze() {
            if (this.inventoryStacks[1] != null || this.inventoryStacks[2] != null || this.inventoryStacks[3] != null || this.inventoryStacks[4] != null || this.inventoryStacks[6] != null) {
                return;
            }
            if (this.func_70301_a(0) == null) {
                return;
            }
            IButterfly butterfly = PluginLepidopterology.butterflyInterface.getMember(this.func_70301_a(0));
            if (butterfly == null) {
                return;
            }
            if (!butterfly.isAnalyzed()) {
                if (!this.isEnergy(this.func_70301_a(5))) {
                    return;
                }
                butterfly.analyze();
                if (this.player != null) {
                    PluginLepidopterology.butterflyInterface.getBreedingTracker(this.player.field_70170_p, this.player.func_146103_bH()).registerSpecies(butterfly.getGenome().getPrimary());
                    PluginLepidopterology.butterflyInterface.getBreedingTracker(this.player.field_70170_p, this.player.func_146103_bH()).registerSpecies(butterfly.getGenome().getSecondary());
                }
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                butterfly.writeToNBT(nbttagcompound);
                this.func_70301_a(0).func_77982_d(nbttagcompound);
                this.func_70298_a(5, 1);
            }
            this.func_70299_a(1, this.func_70301_a(0));
            this.func_70299_a(0, null);
        }

        @Override
        public void func_70296_d() {
            this.tryAnalyze();
        }

        @Override
        public boolean hasHints() {
            return Config.hints.get("flutterlyzer") != null && Config.hints.get("flutterlyzer").length > 0;
        }

        @Override
        public String[] getHints() {
            return Config.hints.get("flutterlyzer");
        }

        @Override
        public boolean throwsErrors() {
            return true;
        }

        @Override
        public EnumErrorCode getErrorState() {
            if (PluginLepidopterology.butterflyInterface.isMember(this.inventoryStacks[0]) && !this.isEnergy(this.func_70301_a(5))) {
                return EnumErrorCode.NOHONEY;
            }
            return EnumErrorCode.OK;
        }
    }
}

