/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.mail.ITradeStation;
import forestry.api.mail.MailAddress;
import forestry.api.mail.PostManager;
import forestry.api.mail.TradeStationInfo;
import forestry.core.proxy.Proxies;
import forestry.core.utils.CommandMC;
import forestry.core.utils.StringUtil;
import forestry.mail.EnumStationState;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class CommandMail
extends CommandMC {
    public int compareTo(Object arg0) {
        return this.func_71517_b().compareTo(((ICommand)arg0).func_71517_b());
    }

    public String func_71517_b() {
        return "mail";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " help";
    }

    public List func_71514_a() {
        return null;
    }

    public void func_71515_b(ICommandSender sender, String[] arguments) {
        if (arguments.length <= 0) {
            throw new WrongUsageException(StringUtil.localizeAndFormat("chat.help", this.func_71518_a(sender)), new Object[0]);
        }
        if (arguments[0].matches("trades")) {
            this.commandTrades(sender, arguments);
            return;
        }
        if (arguments[0].matches("virtualize")) {
            this.commandVirtualize(sender, arguments);
            return;
        }
        if (arguments[0].matches("help")) {
            this.sendChatMessage(sender, StringUtil.localizeAndFormat("chat.mail.command.help.0", this.func_71517_b()));
            this.sendChatMessage(sender, StringUtil.localize("chat.mail.command.help.1"));
            this.sendChatMessage(sender, StringUtil.localize("chat.mail.command.help.2"));
            this.sendChatMessage(sender, StringUtil.localize("chat.mail.command.help.3"));
            return;
        }
        throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
    }

    private void commandTrades(ICommandSender sender, String[] arguments) {
        if (!(sender instanceof EntityPlayer)) {
            return;
        }
        for (ITradeStation trade : PostManager.postRegistry.getPostOffice(((EntityPlayer)sender).field_70170_p).getActiveTradeStations(((EntityPlayer)sender).field_70170_p).values()) {
            this.sendChatMessage(sender, this.makeTradeListEntry(trade.getTradeInfo()));
        }
    }

    private String makeTradeListEntry(TradeStationInfo info) {
        String entry = "\u00a7c";
        if (info.state == EnumStationState.OK) {
            entry = "\u00a7a";
        }
        String tradegood = "[ ? ]";
        if (info.tradegood != null) {
            tradegood = info.tradegood.field_77994_a + "x" + info.tradegood.func_82833_r();
        }
        String demand = "[ ? ]";
        if (info.required.length > 0) {
            demand = "";
            for (ItemStack dmd : info.required) {
                demand = StringUtil.append(", ", demand, dmd.field_77994_a + "x" + dmd.func_82833_r());
            }
        }
        return String.format("%s%-12s | %-20s | %s", entry, info.address.getName(), tradegood, demand);
    }

    private void commandVirtualize(ICommandSender sender, String[] arguments) {
        MailAddress address;
        if (sender instanceof EntityPlayer && !Proxies.common.isOp((EntityPlayer)sender) || !sender.func_70003_b(4, this.func_71517_b())) {
            this.sendChatMessage(sender, "\u00a7c" + StringUtil.localize("chat.command.noperms"));
            return;
        }
        if (arguments.length <= 1) {
            throw new WrongUsageException("/" + this.func_71517_b() + " virtualize <tradestation-name>", new Object[0]);
        }
        World world = this.getWorld(sender, arguments);
        ITradeStation trade = PostManager.postRegistry.getTradeStation(world, address = new MailAddress(arguments[1]));
        if (trade == null) {
            this.sendChatMessage(sender, String.format("\u00a7c" + StringUtil.localize("chat.mail.command.no_tradestation"), arguments[1]));
            return;
        }
        trade.setVirtual(!trade.isVirtual());
        this.sendChatMessage(sender, String.format("\u00a7aSet virtualization for '%s' to %s.", trade.getAddress().getName(), trade.isVirtual()));
    }
}

