/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gadgets;

import buildcraft.api.gates.ITrigger;
import forestry.api.core.ForestryAPI;
import forestry.api.core.ISpecialInventory;
import forestry.api.mail.ILetter;
import forestry.api.mail.IPostalState;
import forestry.api.mail.MailAddress;
import forestry.api.mail.PostManager;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.InventoryAdapter;
import forestry.mail.EnumDeliveryState;
import forestry.mail.IMailContainer;
import forestry.mail.PostRegistry;
import forestry.plugins.PluginMail;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineMailbox
extends TileBase
implements IMailContainer,
ISpecialInventory,
ISidedInventory {
    private boolean isLinked = false;
    private static int[] slotIndices;

    public MachineMailbox() {
        this.setHints(Config.hints.get("mailbox"));
    }

    public String func_145825_b() {
        return "mail.0.name";
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        if (!Proxies.common.isSimulating(this.field_145850_b)) {
            return;
        }
        ItemStack held = player.func_71045_bC();
        if (PostManager.postRegistry.isLetter(held)) {
            IPostalState result = this.tryDispatchLetter(held, true);
            if (!result.isOk()) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("for.chat.mail." + result.getIdentifier(), new Object[0]));
            } else {
                --held.field_77994_a;
            }
        } else {
            player.openGui(ForestryAPI.instance, GuiId.MailboxGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void updateServerSide() {
        if (!this.isLinked) {
            this.getOrCreateMailInventory();
            this.isLinked = true;
        }
    }

    public IInventory getOrCreateMailInventory() {
        if (!Proxies.common.isSimulating(this.field_145850_b)) {
            return new InventoryAdapter(84, "Letters");
        }
        EntityPlayer player = Proxies.common.getPlayer();
        if (player == null || player.func_146103_bH() == null) {
            return new InventoryAdapter(84, "Letters");
        }
        MailAddress address = new MailAddress(player.func_146103_bH());
        return PostRegistry.getOrCreatePOBox(this.field_145850_b, address);
    }

    private IPostalState tryDispatchLetter(ItemStack letterstack, boolean dispatchLetter) {
        ILetter letter = PostManager.postRegistry.getLetter(letterstack);
        IPostalState result = letter != null ? PostManager.postRegistry.getPostOffice(this.field_145850_b).lodgeLetter(this.field_145850_b, letterstack, dispatchLetter) : EnumDeliveryState.NOT_MAILABLE;
        return result;
    }

    @Override
    public boolean hasMail() {
        IInventory mailInventory = this.getOrCreateMailInventory();
        for (int i = 0; i < mailInventory.func_70302_i_(); ++i) {
            if (mailInventory.func_70301_a(i) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public LinkedList<ITrigger> getCustomTriggers() {
        LinkedList<ITrigger> res = new LinkedList<ITrigger>();
        res.add(PluginMail.triggerHasMail);
        return res;
    }

    public int[] getSizeInventorySide(int side) {
        IInventory inventory = this.getOrCreateMailInventory();
        if (slotIndices == null) {
            slotIndices = new int[inventory.func_70302_i_()];
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                MachineMailbox.slotIndices[i] = i;
            }
        }
        return slotIndices;
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (!PostManager.postRegistry.isLetter(stack)) {
            return 0;
        }
        IPostalState result = this.tryDispatchLetter(stack, doAdd);
        if (!result.isOk()) {
            return 0;
        }
        return 1;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ItemStack product = null;
        IInventory mailInventory = this.getOrCreateMailInventory();
        for (int i = 0; i < mailInventory.func_70302_i_(); ++i) {
            ItemStack slotStack = mailInventory.func_70301_a(i);
            if (slotStack == null) continue;
            product = slotStack;
            if (!doRemove) break;
            mailInventory.func_70299_a(i, null);
            break;
        }
        if (product != null) {
            return new ItemStack[]{product};
        }
        return new ItemStack[0];
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int var1) {
        return null;
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public void func_70299_a(int var1, ItemStack var2) {
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return super.isUseableByPlayer(player);
    }

    public boolean func_145818_k_() {
        return super.hasCustomInventoryName();
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return super.isItemValidForSlot(slotIndex, itemstack);
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return super.canInsertItem(i, itemstack, j);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return super.canExtractItem(i, itemstack, j);
    }

    public int[] func_94128_d(int side) {
        return super.getAccessibleSlotsFromSide(side);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

