/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gadgets;

import buildcraft.api.gates.ITrigger;
import forestry.api.core.ForestryAPI;
import forestry.api.core.ISpecialInventory;
import forestry.api.mail.IStamps;
import forestry.api.mail.MailAddress;
import forestry.api.mail.PostManager;
import forestry.core.EnumErrorCode;
import forestry.core.gadgets.TileBase;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.StackUtils;
import forestry.plugins.PluginMail;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineTrader
extends TileBase
implements ISpecialInventory,
ISidedInventory {
    @EntityNetData
    public MailAddress address = new MailAddress();
    private static int[] slotIndices;

    public String func_145825_b() {
        return "mail.1.name";
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        if (this.isLinked()) {
            player.openGui(ForestryAPI.instance, GuiId.TraderGUI.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else {
            player.openGui(ForestryAPI.instance, GuiId.TraderNameGUI.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void onRemoval() {
        if (this.isLinked()) {
            PostManager.postRegistry.deleteTradeStation(this.field_145850_b, this.address);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.address != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.address.writeToNBT(nbt);
            nbttagcompound.func_74782_a("address", (NBTBase)nbt);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("address")) {
            this.address = MailAddress.loadFromNBT(nbttagcompound.func_74775_l("address"));
        }
    }

    @Override
    public void updateServerSide() {
        if (this.field_145850_b.func_82737_E() % 40L * 10L != 0L) {
            return;
        }
        if (!this.hasPaperMin(0.0f) || !this.hasInputBufMin(0.0f)) {
            this.setErrorState(EnumErrorCode.NORESOURCE);
            return;
        }
        if (!this.hasPostageMin(3)) {
            this.setErrorState(EnumErrorCode.NOSTAMPS);
            return;
        }
        this.setErrorState(EnumErrorCode.OK);
    }

    public boolean isLinked() {
        return this.address.isValid();
    }

    private float percentOccupied(int startSlot, int countSlots) {
        int max = 0;
        int avail = 0;
        IInventory tradeInventory = this.getOrCreateTradeInventory();
        for (int i = startSlot; i < startSlot + countSlots; ++i) {
            max += 64;
            if (tradeInventory.func_70301_a(i) == null) continue;
            avail += tradeInventory.func_70301_a((int)i).field_77994_a;
        }
        return (float)avail / (float)max;
    }

    public boolean hasPaperMin(float percentage) {
        return this.percentOccupied(5, 6) > percentage;
    }

    public boolean hasInputBufMin(float percentage) {
        return this.percentOccupied(15, 12) > percentage;
    }

    public boolean hasOutputBufMin(float percentage) {
        return this.percentOccupied(27, 12) > percentage;
    }

    public boolean hasPostageMin(int postage) {
        int posted = 0;
        IInventory tradeInventory = this.getOrCreateTradeInventory();
        for (int i = 11; i < 15; ++i) {
            ItemStack stamp = tradeInventory.func_70301_a(i);
            if (stamp == null || !(stamp.func_77973_b() instanceof IStamps)) continue;
            posted += ((IStamps)stamp.func_77973_b()).getPostage(stamp).getValue() * stamp.field_77994_a;
        }
        return posted >= postage;
    }

    public MailAddress getAddress() {
        return this.address;
    }

    public void setAddress(MailAddress address) {
        if (address == null) {
            throw new NullPointerException("address must not be null");
        }
        if (this.address.isValid() && this.address.equals(address)) {
            return;
        }
        if (Proxies.common.isSimulating(this.field_145850_b)) {
            if (!PostManager.postRegistry.isValidTradeAddress(this.field_145850_b, address)) {
                this.setErrorState(EnumErrorCode.NOTALPHANUMERIC);
                return;
            }
            if (!PostManager.postRegistry.isAvailableTradeAddress(this.field_145850_b, address)) {
                this.setErrorState(EnumErrorCode.NOTUNIQUE);
                return;
            }
            this.address = address;
            PostManager.postRegistry.getOrCreateTradeStation(this.field_145850_b, this.getOwnerProfile(), address);
            this.setErrorState(EnumErrorCode.OK);
            this.sendNetworkUpdate();
        } else {
            this.address = address;
        }
    }

    public IInventory getOrCreateTradeInventory() {
        if (!Proxies.common.isSimulating(this.field_145850_b)) {
            return new InventoryAdapter(39, "INV");
        }
        if (!this.address.isValid()) {
            return new InventoryAdapter(39, "INV");
        }
        return PostManager.postRegistry.getOrCreateTradeStation(this.field_145850_b, this.getOwnerProfile(), this.address);
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (!this.isLinked()) {
            return 0;
        }
        IInventory inventory = this.getOrCreateTradeInventory();
        ItemStack tradegood = inventory.func_70301_a(0);
        if (stack.func_77973_b() == Items.field_151121_aF && (tradegood != null && tradegood.func_77973_b() != Items.field_151121_aF || from == ForgeDirection.DOWN || from == ForgeDirection.UP)) {
            return StackUtils.addToInventory(stack, inventory, doAdd, 5, 6);
        }
        if (stack.func_77973_b() instanceof IStamps && (tradegood != null && !(tradegood.func_77973_b() instanceof IStamps) || from == ForgeDirection.DOWN || from == ForgeDirection.UP)) {
            return StackUtils.addToInventory(stack, inventory, doAdd, 11, 4);
        }
        if (tradegood == null) {
            return 0;
        }
        if (!tradegood.func_77969_a(stack)) {
            return 0;
        }
        return StackUtils.addToInventory(stack, inventory, doAdd, 15, 12);
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        if (!this.isLinked()) {
            return new ItemStack[0];
        }
        ItemStack product = null;
        IInventory inventory = this.getOrCreateTradeInventory();
        for (int i = 27; i < 39; ++i) {
            ItemStack stackSlot = inventory.func_70301_a(i);
            if (stackSlot == null || stackSlot.field_77994_a <= 0) continue;
            product = inventory.func_70298_a(i, 1);
            break;
        }
        if (product != null) {
            return new ItemStack[]{product};
        }
        return new ItemStack[0];
    }

    public int[] getSizeInventorySide(int side) {
        IInventory inventory = this.getOrCreateTradeInventory();
        if (slotIndices == null) {
            slotIndices = new int[inventory.func_70302_i_()];
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                MachineTrader.slotIndices[i] = i;
            }
        }
        return slotIndices;
    }

    @Override
    protected boolean canTakeStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canTakeStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        return slotIndex >= 27 && slotIndex < 39;
    }

    @Override
    protected boolean canPutStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canPutStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        if (slotIndex >= 5 && slotIndex < 11 && itemstack.func_77973_b() == Items.field_151121_aF) {
            return true;
        }
        if (slotIndex >= 11 && slotIndex < 4) {
            return itemstack.func_77973_b() instanceof IStamps;
        }
        if (slotIndex >= 15 && slotIndex < 12) {
            IInventory inventory = this.getOrCreateTradeInventory();
            ItemStack tradegood = inventory.func_70301_a(0);
            if (tradegood == null) {
                return false;
            }
            return StackUtils.isIdenticalItem(tradegood, itemstack);
        }
        return false;
    }

    public int func_70302_i_() {
        return this.getOrCreateTradeInventory().func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.getOrCreateTradeInventory().func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.getOrCreateTradeInventory().func_70298_a(i, j);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.getOrCreateTradeInventory().func_70299_a(i, itemstack);
    }

    public ItemStack func_70304_b(int slot) {
        return this.getOrCreateTradeInventory().func_70304_b(slot);
    }

    public void func_70296_d() {
        this.getOrCreateTradeInventory().func_70296_d();
    }

    public int func_70297_j_() {
        return this.getOrCreateTradeInventory().func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return super.isUseableByPlayer(player);
    }

    public boolean func_145818_k_() {
        return super.hasCustomInventoryName();
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return super.isItemValidForSlot(slotIndex, itemstack);
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return super.canInsertItem(i, itemstack, j);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return super.canExtractItem(i, itemstack, j);
    }

    public int[] func_94128_d(int side) {
        return super.getAccessibleSlotsFromSide(side);
    }

    @Override
    public LinkedList<ITrigger> getCustomTriggers() {
        LinkedList<ITrigger> res = new LinkedList<ITrigger>();
        res.add(PluginMail.lowPaper25);
        res.add(PluginMail.lowPaper10);
        res.add(PluginMail.lowInput25);
        res.add(PluginMail.lowInput10);
        res.add(PluginMail.lowPostage40);
        res.add(PluginMail.lowPostage20);
        res.add(PluginMail.highBuffer90);
        res.add(PluginMail.highBuffer75);
        return res;
    }
}

