/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.api.mail.ITradeStation;
import forestry.api.mail.MailAddress;
import forestry.api.mail.PostManager;
import forestry.api.mail.TradeStationInfo;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.IGuiSelectable;
import forestry.core.network.PacketPayload;
import forestry.core.network.PacketUpdate;
import forestry.core.proxy.Proxies;
import forestry.mail.EnumStationState;
import forestry.mail.network.PacketTradeInfo;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;

public class ContainerCatalogue
extends ContainerForestry
implements IGuiSelectable {
    private final EntityPlayer player;
    private final LinkedHashMap<MailAddress, ITradeStation> stations;
    private TradeStationInfo currentTrade = null;
    private Iterator<ITradeStation> iterator = null;
    private int maxItPos = 0;
    private int currentItPos = 0;
    private boolean needsSynch = true;
    private int currentFilter = 1;
    private static final String[] FILTER_NAMES = new String[]{"all", "online", "offline"};
    private static final Set<EnumStationState>[] FILTERS = new EnumSet[]{EnumSet.noneOf(EnumStationState.class), EnumSet.of(EnumStationState.OK), EnumSet.of(EnumStationState.INSUFFICIENT_OFFER, EnumStationState.INSUFFICIENT_TRADE_GOOD, EnumStationState.INSUFFICIENT_BUFFER, EnumStationState.INSUFFICIENT_PAPER, EnumStationState.INSUFFICIENT_STAMPS)};

    public ContainerCatalogue(EntityPlayer player) {
        super((IInventory)player.field_71071_by);
        this.player = player;
        this.stations = new LinkedHashMap();
        this.rebuildStationsList();
    }

    public int getMaxCount() {
        return this.maxItPos;
    }

    public int getCurrentPos() {
        return this.currentItPos;
    }

    public String getFilterIdent() {
        return FILTER_NAMES[this.currentFilter];
    }

    private void rebuildStationsList() {
        this.stations.clear();
        for (ITradeStation station : PostManager.postRegistry.getPostOffice(this.player.field_70170_p).getActiveTradeStations(this.player.field_70170_p).values()) {
            TradeStationInfo info = station.getTradeInfo();
            if (info.tradegood == null || !FILTERS[this.currentFilter].isEmpty() && !FILTERS[this.currentFilter].contains(info.state)) continue;
            this.stations.put(station.getAddress(), station);
        }
        this.maxItPos = this.stations.size();
        this.resetIteration();
    }

    private void resetIteration() {
        if (!this.stations.isEmpty()) {
            this.iterator = this.stations.values().iterator();
            this.updateTradeInfo(this.iterator.next());
        } else {
            this.updateTradeInfo(null);
        }
        this.currentItPos = 1;
    }

    public void advanceIteration() {
        if (!Proxies.common.isSimulating(this.player.field_70170_p)) {
            this.sendSelection(true);
            return;
        }
        if (this.stations.isEmpty()) {
            return;
        }
        if (this.iterator.hasNext()) {
            ++this.currentItPos;
            this.updateTradeInfo(this.iterator.next());
        } else {
            this.resetIteration();
        }
    }

    public void regressIteration() {
        if (!Proxies.common.isSimulating(this.player.field_70170_p)) {
            this.sendSelection(false);
            return;
        }
        if (this.stations.isEmpty()) {
            return;
        }
        this.iterator = this.stations.values().iterator();
        ITradeStation previous = null;
        this.currentItPos = 0;
        while (this.iterator.hasNext()) {
            ITradeStation current = this.iterator.next();
            if (!current.getAddress().equals(this.currentTrade.address)) {
                ++this.currentItPos;
                previous = current;
                continue;
            }
            if (previous == null) {
                Iterator<ITradeStation> it = this.stations.values().iterator();
                this.currentItPos = this.stations.size();
                while (it.hasNext()) {
                    previous = it.next();
                }
            }
            this.updateTradeInfo(previous);
            break;
        }
    }

    public void cycleFilter() {
        if (!Proxies.common.isSimulating(this.player.field_70170_p)) {
            PacketPayload payload = new PacketPayload(1, 0, 0);
            payload.intPayload[0] = 2;
            PacketUpdate packet = new PacketUpdate(30, payload);
            Proxies.net.sendToServer(packet);
            return;
        }
        this.currentFilter = this.currentFilter < FILTERS.length - 1 ? ++this.currentFilter : 0;
        this.rebuildStationsList();
    }

    private void sendSelection(boolean advance) {
        PacketPayload payload = new PacketPayload(1, 0, 0);
        payload.intPayload[0] = advance ? 0 : 1;
        PacketUpdate packet = new PacketUpdate(30, payload);
        Proxies.net.sendToServer(packet);
    }

    public void updateTradeInfo(ITradeStation station) {
        if (!Proxies.common.isSimulating(this.player.field_70170_p)) {
            return;
        }
        if (station != null) {
            this.setTradeInfo(station.getTradeInfo());
        } else {
            this.setTradeInfo(null);
        }
        this.needsSynch = true;
    }

    public void handleTradeInfoUpdate(PacketTradeInfo packet) {
        this.setTradeInfo(packet.tradeInfo);
    }

    public TradeStationInfo getTradeInfo() {
        return this.currentTrade;
    }

    private void setTradeInfo(TradeStationInfo info) {
        this.currentTrade = info;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.needsSynch) {
            for (int i = 0; i < this.field_75149_d.size(); ++i) {
                ICrafting crafter = (ICrafting)this.field_75149_d.get(i);
                crafter.func_71112_a((Container)this, 0, this.currentItPos);
                crafter.func_71112_a((Container)this, 1, this.maxItPos);
                crafter.func_71112_a((Container)this, 2, this.currentFilter);
            }
            Proxies.net.sendToPlayer(new PacketTradeInfo(83, this.currentTrade), this.player);
            this.needsSynch = false;
        }
    }

    public void func_75137_b(int i, int j) {
        switch (i) {
            case 0: {
                this.currentItPos = j;
                break;
            }
            case 1: {
                this.maxItPos = j;
                break;
            }
            case 2: {
                this.currentFilter = j;
            }
        }
    }

    @Override
    public void handleSelectionChange(EntityPlayer player, PacketUpdate packet) {
        if (packet.payload.intPayload[0] == 0) {
            this.advanceIteration();
        } else if (packet.payload.intPayload[0] == 1) {
            this.regressIteration();
        } else if (packet.payload.intPayload[0] == 2) {
            this.cycleFilter();
        }
        this.needsSynch = true;
    }

    @Override
    public void setSelection(PacketUpdate packet) {
    }
}

