/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.MailAddress;
import forestry.api.mail.PostManager;
import forestry.core.config.SessionVars;
import forestry.core.gadgets.TileForestry;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiTextBox;
import forestry.core.gui.widgets.Widget;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import forestry.mail.EnumAddressee;
import forestry.mail.gui.ContainerLetter;
import forestry.mail.items.ItemLetter;
import java.util.Locale;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiLetter
extends GuiForestry<TileForestry> {
    private final boolean isProcessedLetter;
    private boolean checkedSessionVars;
    private GuiTextField address;
    private GuiTextBox text;
    boolean addressFocus;
    boolean textFocus;
    private final ContainerLetter container;

    public GuiLetter(EntityPlayer player, ItemLetter.LetterInventory inventory) {
        super("textures/gui/letter.png", (ContainerForestry)new ContainerLetter(player, inventory), (Object)inventory);
        this.field_146999_f = 194;
        this.field_147000_g = 227;
        this.container = (ContainerLetter)this.field_147002_h;
        this.isProcessedLetter = this.container.getLetter().isProcessed();
        this.widgetManager.add(new AddresseeSlot(16, 12));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.address = new GuiTextField(this.field_146289_q, this.field_147003_i + 46, this.field_147009_r + 13, 93, 13);
        MailAddress recipient = this.container.getRecipient();
        if (recipient != null) {
            this.address.func_146180_a(recipient.getName());
            this.setRecipient(recipient);
        }
        this.text = new GuiTextBox(this.field_146289_q, this.field_147003_i + 17, this.field_147009_r + 31, 122, 57);
        this.text.func_146203_f(128);
        if (!this.container.getText().isEmpty()) {
            this.text.func_146180_a(this.container.getText());
        }
    }

    protected void func_73869_a(char eventCharacter, int eventKey) {
        if (this.address.func_146206_l()) {
            if (eventKey == 28) {
                this.address.func_146195_b(false);
            } else {
                this.address.func_146201_a(eventCharacter, eventKey);
            }
            return;
        }
        if (this.text.func_146206_l()) {
            if (eventKey == 28) {
                if (Proxies.common.isShiftDown()) {
                    this.text.func_146180_a(this.text.func_146179_b() + "\n");
                } else {
                    this.text.func_146195_b(false);
                }
            } else if (eventKey == 208) {
                this.text.advanceLine();
            } else if (eventKey == 200) {
                this.text.regressLine();
            } else if (this.text.moreLinesAllowed() || eventKey == 211 || eventKey == 14) {
                this.text.func_146201_a(eventCharacter, eventKey);
            }
            return;
        }
        super.func_73869_a(eventCharacter, eventKey);
    }

    @Override
    protected void func_73864_a(int par1, int par2, int mouseButton) {
        super.func_73864_a(par1, par2, mouseButton);
        this.address.func_146192_a(par1, par2, mouseButton);
        this.text.func_146192_a(par1, par2, mouseButton);
    }

    @Override
    protected void func_146976_a(float var1, int mouseX, int mouseY) {
        String recipient;
        if (!this.isProcessedLetter && !this.checkedSessionVars) {
            this.checkedSessionVars = true;
            this.setFromSessionVars();
        }
        if (this.addressFocus != this.address.func_146206_l() && StringUtils.isNotBlank((CharSequence)(recipient = this.address.func_146179_b()))) {
            MailAddress recipientAddress = MailAddress.makeMailAddress(recipient, this.container.getCarrierType());
            this.setRecipient(recipientAddress);
        }
        this.addressFocus = this.address.func_146206_l();
        if (this.textFocus != this.text.func_146206_l()) {
            this.setText();
        }
        this.textFocus = this.text.func_146206_l();
        super.func_146976_a(var1, mouseX, mouseY);
        if (this.isProcessedLetter) {
            this.field_146289_q.func_78276_b(this.address.func_146179_b(), this.field_147003_i + 49, this.field_147009_r + 16, this.fontColor.get("gui.mail.lettertext"));
            this.field_146289_q.func_78279_b(this.text.func_146179_b(), this.field_147003_i + 20, this.field_147009_r + 34, 119, this.fontColor.get("gui.mail.lettertext"));
        } else {
            this.address.func_146194_f();
            if (this.container.getCarrierType().equals(EnumAddressee.TRADER.toString().toLowerCase(Locale.ENGLISH))) {
                this.drawTradePreview(this.field_147003_i + 18, this.field_147009_r + 32);
            } else {
                this.text.func_146194_f();
            }
        }
    }

    private void drawTradePreview(int x, int y) {
        String infoString = null;
        if (this.container.getTradeInfo() == null) {
            infoString = "gui.mail.notrader";
        } else if (this.container.getTradeInfo().tradegood == null) {
            infoString = "gui.mail.nothingtotrade";
        } else if (!this.container.getTradeInfo().state.isOk()) {
            infoString = "chat.mail." + this.container.getTradeInfo().state.getIdentifier();
        }
        if (infoString != null) {
            this.field_146289_q.func_78279_b(StringUtil.localize(infoString), x, y, 119, this.fontColor.get("gui.mail.lettertext"));
            return;
        }
        this.field_146289_q.func_78276_b(StringUtil.localize("gui.mail.pleasesend"), x, y, this.fontColor.get("gui.mail.lettertext"));
        field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, this.container.getTradeInfo().tradegood, x, y + 10);
        field_146296_j.func_77021_b(this.field_146289_q, this.field_146297_k.field_71446_o, this.container.getTradeInfo().tradegood, x, y + 10);
        GL11.glDisable((int)2896);
        this.field_146289_q.func_78276_b(StringUtil.localize("gui.mail.foreveryattached"), x, y + 28, this.fontColor.get("gui.mail.lettertext"));
        GL11.glEnable((int)2896);
        for (int i = 0; i < this.container.getTradeInfo().required.length; ++i) {
            GL11.glDisable((int)2896);
            field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, this.container.getTradeInfo().required[i], x + i * 18, y + 38);
            field_146296_j.func_77021_b(this.field_146289_q, this.field_146297_k.field_71446_o, this.container.getTradeInfo().required[i], x + i * 18, y + 38);
            GL11.glEnable((int)2896);
        }
    }

    public void func_146281_b() {
        MailAddress recipientAddress = MailAddress.makeMailAddress(this.address.func_146179_b(), this.container.getCarrierType());
        this.setRecipient(recipientAddress);
        this.setText();
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_146281_b();
    }

    protected boolean func_146983_a(int key) {
        return false;
    }

    private void setFromSessionVars() {
        if (SessionVars.getStringVar("mail.letter.recipient") == null) {
            return;
        }
        String recipient = SessionVars.getStringVar("mail.letter.recipient");
        String type = SessionVars.getStringVar("mail.letter.addressee");
        if (recipient != null && type != null) {
            this.address.func_146180_a(recipient);
            MailAddress recipientAddress = MailAddress.makeMailAddress(recipient, type);
            this.setRecipient(recipientAddress);
        }
        SessionVars.clearStringVar("mail.letter.recipient");
        SessionVars.clearStringVar("mail.letter.addressee");
    }

    private void setRecipient(MailAddress recipientAddress) {
        if (this.isProcessedLetter || recipientAddress == null) {
            return;
        }
        this.container.setRecipient(recipientAddress);
        this.container.updateTradeInfo((World)this.field_146297_k.field_71441_e, recipientAddress);
    }

    private void setText() {
        if (this.isProcessedLetter) {
            return;
        }
        this.container.setText(this.text.func_146179_b());
    }

    protected class AddresseeSlot
    extends Widget {
        public AddresseeSlot(int xPos, int yPos) {
            super(GuiLetter.this.widgetManager, xPos, yPos);
            this.width = 26;
            this.height = 15;
        }

        @Override
        public void draw(int startX, int startY) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            IPostalCarrier carrier = PostManager.postRegistry.getCarrier(GuiLetter.this.container.getCarrierType());
            if (carrier != null) {
                GuiLetter.this.func_94065_a(startX + this.xPos, startY + this.yPos - 5, carrier.getIcon(), 26, 26);
            }
        }

        @Override
        protected String getLegacyTooltip(EntityPlayer player) {
            return StringUtil.localize("gui.addressee." + GuiLetter.this.container.getCarrierType().toLowerCase(Locale.ENGLISH));
        }

        @Override
        public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
            if (!GuiLetter.this.isProcessedLetter) {
                GuiLetter.this.container.advanceCarrierType();
            }
        }
    }
}

