/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.ForestryAPI;
import forestry.api.mail.ILetter;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.interfaces.IErrorSource;
import forestry.core.interfaces.IHintSource;
import forestry.core.items.ItemInventoried;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.ItemInventory;
import forestry.core.utils.StringUtil;
import forestry.mail.Letter;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemLetter
extends ItemInventoried {
    @SideOnly(value=Side.CLIENT)
    private IIcon[][] icons;

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (Proxies.common.isSimulating(world)) {
            if (itemstack.field_77994_a == 1) {
                entityplayer.openGui(ForestryAPI.instance, GuiId.LetterGUI.ordinal(), world, (int)entityplayer.field_70165_t, (int)entityplayer.field_70163_u, (int)entityplayer.field_70161_v);
            } else {
                entityplayer.func_145747_a((IChatComponent)new ChatComponentTranslation("for.chat.mail.wrongstacksize", new Object[0]));
            }
        }
        return itemstack;
    }

    public boolean func_77651_p() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.icons = new IIcon[3][4];
        for (int i = 0; i < 3; ++i) {
            this.icons[i][0] = TextureManager.getInstance().registerTex(register, "mail/letter." + i + ".fresh");
            this.icons[i][1] = TextureManager.getInstance().registerTex(register, "mail/letter." + i + ".stamped");
            this.icons[i][2] = TextureManager.getInstance().registerTex(register, "mail/letter." + i + ".opened");
            this.icons[i][3] = TextureManager.getInstance().registerTex(register, "mail/letter." + i + ".emptied");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        int state = ItemLetter.getState(damage);
        int size = ItemLetter.getSize(damage);
        return this.icons[size][state];
    }

    public static int encodeMeta(int state, int size) {
        int meta = size << 4;
        size = ItemLetter.getSize(meta |= state);
        state = ItemLetter.getState(meta);
        return meta;
    }

    public static int getState(int meta) {
        return meta & 0xF;
    }

    public static int getSize(int meta) {
        return meta >> 4;
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        NBTTagCompound nbttagcompound = itemstack.func_77978_p();
        if (nbttagcompound == null) {
            list.add("<" + StringUtil.localize("gui.blank") + ">");
            return;
        }
        Letter letter = new Letter(nbttagcompound);
        letter.addTooltip(list);
    }

    public static int getType(ILetter letter) {
        int count = letter.countAttachments();
        if (count > 5) {
            return 2;
        }
        if (count > 1) {
            return 1;
        }
        return 0;
    }

    public static class LetterInventory
    extends ItemInventory
    implements IErrorSource,
    IHintSource {
        ILetter letter;

        public LetterInventory(ItemStack itemstack) {
            super(ItemLetter.class);
            this.parent = itemstack;
            this.isItemInventory = true;
            this.setUID(true);
            this.readFromNBT(itemstack.func_77978_p());
        }

        public ILetter getLetter() {
            return this.letter;
        }

        @Override
        public void onGuiSaved(EntityPlayer player) {
            super.onGuiSaved(player);
            if (this.parent == null) {
                return;
            }
            int state = ItemLetter.getState(this.parent.func_77960_j());
            if (state >= 2) {
                if (state == 2 && this.letter.countAttachments() <= 0) {
                    this.parent.func_77964_b(ItemLetter.encodeMeta(3, ItemLetter.getSize(this.parent.func_77960_j())));
                }
                return;
            }
            int type = ItemLetter.getType(this.letter);
            if (this.parent != null && this.letter.isMailable() && this.letter.isPostPaid()) {
                this.parent.func_77964_b(ItemLetter.encodeMeta(1, type));
            } else {
                this.parent.func_77964_b(ItemLetter.encodeMeta(0, type));
            }
        }

        @Override
        public void readFromNBT(NBTTagCompound nbttagcompound) {
            if (nbttagcompound == null) {
                return;
            }
            this.letter = new Letter(nbttagcompound);
        }

        @Override
        public void writeToNBT(NBTTagCompound nbttagcompound) {
            this.letter.writeToNBT(nbttagcompound);
        }

        @Override
        public ItemStack func_70298_a(int i, int j) {
            return this.letter.func_70298_a(i, j);
        }

        @Override
        public void func_70299_a(int i, ItemStack itemstack) {
            this.letter.func_70299_a(i, itemstack);
        }

        @Override
        public ItemStack func_70301_a(int i) {
            return this.letter.func_70301_a(i);
        }

        @Override
        public int func_70302_i_() {
            return this.letter.func_70302_i_();
        }

        @Override
        public String func_145825_b() {
            return this.letter.func_145825_b();
        }

        @Override
        public int func_70297_j_() {
            return this.letter.func_70297_j_();
        }

        @Override
        public void func_70296_d() {
            this.letter.func_70296_d();
        }

        @Override
        public boolean func_70300_a(EntityPlayer entityplayer) {
            return this.letter.func_70300_a(entityplayer);
        }

        @Override
        public void func_70295_k_() {
        }

        @Override
        public void func_70305_f() {
        }

        @Override
        public ItemStack func_70304_b(int slot) {
            return this.letter.func_70304_b(slot);
        }

        @Override
        public boolean throwsErrors() {
            return true;
        }

        @Override
        public EnumErrorCode getErrorState() {
            if (!this.letter.hasRecipient()) {
                return EnumErrorCode.NORECIPIENT;
            }
            if (!this.letter.isProcessed() && !this.letter.isPostPaid()) {
                return EnumErrorCode.NOTPOSTPAID;
            }
            return EnumErrorCode.OK;
        }

        @Override
        public boolean hasHints() {
            return Config.hints.get("letter") != null && Config.hints.get("letter").length > 0;
        }

        @Override
        public String[] getHints() {
            return Config.hints.get("letter");
        }
    }
}

