/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.circuits.ChipsetManager;
import forestry.api.core.PluginInfo;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.core.CommandForestry;
import forestry.core.CreativeTabForestry;
import forestry.core.GameMode;
import forestry.core.PickupHandlerCore;
import forestry.core.SaveEventHandlerCore;
import forestry.core.circuits.CircuitRegistry;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.circuits.ItemSolderingIron;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.BlockBase;
import forestry.core.gadgets.BlockResource;
import forestry.core.gadgets.BlockSoil;
import forestry.core.gadgets.BlockStainedGlass;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.gadgets.TileAnalyzer;
import forestry.core.gadgets.TileEscritoire;
import forestry.core.genetics.Allele;
import forestry.core.genetics.AlleleRegistry;
import forestry.core.genetics.ClimateHelper;
import forestry.core.genetics.ItemResearchNote;
import forestry.core.interfaces.IOreDictionaryHandler;
import forestry.core.interfaces.IPickupHandler;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.items.ItemArmorNaturalist;
import forestry.core.items.ItemAssemblyKit;
import forestry.core.items.ItemCrated;
import forestry.core.items.ItemForestry;
import forestry.core.items.ItemForestryBlock;
import forestry.core.items.ItemForestryPickaxe;
import forestry.core.items.ItemForestryShovel;
import forestry.core.items.ItemFruit;
import forestry.core.items.ItemLiquidContainer;
import forestry.core.items.ItemMisc;
import forestry.core.items.ItemOverlay;
import forestry.core.items.ItemPipette;
import forestry.core.items.ItemScoop;
import forestry.core.items.ItemWrench;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ForestryModEnvWarningCallable;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.plugins.NativePlugin;
import forestry.plugins.PluginApiculture;
import forestry.plugins.PluginBuildCraft;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;

@PluginInfo(pluginID="Core", name="Core", author="SirSengir", url="http://forestry.sengir.net/", description="Core mechanics for Forestry. Required by all other plugins.")
public class PluginCore
extends NativePlugin
implements IFuelHandler {
    public static MachineDefinition definitionAnalyzer;
    public static MachineDefinition definitionEscritoire;
    public static ForestryModEnvWarningCallable crashCallable;

    @Override
    public void preInit() {
        super.preInit();
        ChipsetManager.solderManager = new ItemSolderingIron.SolderManager();
        CircuitRegistry circuitRegistry = new CircuitRegistry();
        ChipsetManager.circuitRegistry = circuitRegistry;
        circuitRegistry.initialize();
        AlleleRegistry alleleRegistry = new AlleleRegistry();
        AlleleManager.alleleRegistry = alleleRegistry;
        AlleleManager.climateHelper = new ClimateHelper();
        alleleRegistry.initialize();
        Allele.initialize();
        ForestryBlock.core.registerBlock((Block)new BlockBase(Material.field_151573_f, true), ItemForestryBlock.class, "core");
        definitionAnalyzer = ((BlockBase)ForestryBlock.core.block()).addDefinition(new MachineDefinition(0, "forestry.Analyzer", TileAnalyzer.class, PluginApiculture.proxy.getRendererAnalyzer("textures/blocks/analyzer_"), new IRecipe[0]));
        definitionEscritoire = ((BlockBase)ForestryBlock.core.block()).addDefinition(new MachineDefinition(1, "forestry.Escritoire", TileEscritoire.class, Proxies.render.getRenderEscritoire(), new IRecipe[0]));
        ForestryBlock.soil.registerBlock(new BlockSoil(), ItemForestryBlock.class, "soil");
        ForestryBlock.soil.block().setHarvestLevel("shovel", 0, 0);
        ForestryBlock.soil.block().setHarvestLevel("shovel", 0, 1);
        ForestryBlock.resources.registerBlock(new BlockResource(), ItemForestryBlock.class, "resources");
        ForestryBlock.resources.block().setHarvestLevel("pickaxe", 1, 0);
        ForestryBlock.resources.block().setHarvestLevel("pickaxe", 1, 1);
        ForestryBlock.resources.block().setHarvestLevel("pickaxe", 1, 2);
        OreDictionary.registerOre((String)"oreApatite", (ItemStack)ForestryBlock.resources.getItemStack(1, 0));
        OreDictionary.registerOre((String)"oreCopper", (ItemStack)ForestryBlock.resources.getItemStack(1, 1));
        OreDictionary.registerOre((String)"oreTin", (ItemStack)ForestryBlock.resources.getItemStack(1, 2));
        ForestryBlock.glass.registerBlock((Block)new BlockStainedGlass(), ItemForestryBlock.class, "stained");
        FurnaceRecipes.func_77602_a().func_151394_a(ForestryBlock.resources.getItemStack(1, 1), ForestryItem.ingotCopper.getItemStack(), 0.5f);
        FurnaceRecipes.func_77602_a().func_151394_a(ForestryBlock.resources.getItemStack(1, 2), ForestryItem.ingotTin.getItemStack(), 0.5f);
        GameRegistry.registerFuelHandler((IFuelHandler)this);
    }

    @Override
    public void doInit() {
        super.doInit();
        PluginCore.definitionAnalyzer.recipes = this.createAlyzerRecipes(ForestryBlock.core.block(), 0);
        definitionAnalyzer.register();
        definitionEscritoire.register();
        crashCallable = new ForestryModEnvWarningCallable();
        RecipeSorter.register((String)"forestry:shapedrecipecustom", ShapedRecipeCustom.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:minecraft:shaped");
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return null;
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerCore();
    }

    @Override
    protected void registerItems() {
        ForestryItem.fertilizerBio.registerItem(new ItemForestry(), "fertilizerBio");
        ForestryItem.fertilizerCompound.registerItem(new ItemForestry().setBonemeal(true), "fertilizerCompound");
        ForestryItem.apatite.registerItem(new ItemForestry(), "apatite");
        OreDictionary.registerOre((String)"gemApatite", (ItemStack)ForestryItem.apatite.getItemStack());
        ForestryItem.researchNote.registerItem(new ItemResearchNote(), "researchNote");
        ForestryItem.ingotCopper.registerItem(new ItemForestry(), "ingotCopper");
        ForestryItem.ingotTin.registerItem(new ItemForestry(), "ingotTin");
        ForestryItem.ingotBronze.registerItem(new ItemForestry(), "ingotBronze");
        OreDictionary.registerOre((String)"ingotCopper", (ItemStack)ForestryItem.ingotCopper.getItemStack());
        OreDictionary.registerOre((String)"ingotTin", (ItemStack)ForestryItem.ingotTin.getItemStack());
        OreDictionary.registerOre((String)"ingotBronze", (ItemStack)ForestryItem.ingotBronze.getItemStack());
        ForestryItem.wrench.registerItem(new ItemWrench(), "wrench");
        ForestryItem.pipette.registerItem(new ItemPipette(), "pipette");
        ForestryItem.scoop.registerItem(new ItemScoop(), "scoop");
        ForestryItem.scoop.item().setHarvestLevel("scoop", 3);
        ForestryItem.sturdyCasing.registerItem(new ItemForestry(), "sturdyMachine");
        ForestryItem.hardenedCasing.registerItem(new ItemForestry(), "hardenedMachine");
        ForestryItem.impregnatedCasing.registerItem(new ItemForestry(), "impregnatedCasing");
        ForestryItem.craftingMaterial.registerItem(new ItemMisc(), "craftingMaterial");
        ForestryItem.naturalistHat.registerItem((Item)new ItemArmorNaturalist(0), "naturalistHelmet");
        ForestryItem.vialCatalyst.registerItem(new ItemForestry(), "vialCatalyst");
        ForestryItem.peat.registerItem(new ItemForestry(), "peat");
        OreDictionary.registerOre((String)"brickPeat", (ItemStack)ForestryItem.peat.getItemStack());
        ForestryItem.ash.registerItem(new ItemForestry(), "ash");
        OreDictionary.registerOre((String)"dustAsh", (ItemStack)ForestryItem.ash.getItemStack());
        Proxies.common.addSmelting(ForestryItem.peat.getItemStack(), ForestryItem.ash.getItemStack());
        ForestryItem.bituminousPeat.registerItem(new ItemForestry(), "bituminousPeat");
        ForestryItem.gearBronze.registerItem(new ItemForestry(), "gearBronze");
        OreDictionary.registerOre((String)"gearBronze", (ItemStack)ForestryItem.gearBronze.getItemStack());
        ForestryItem.gearCopper.registerItem(new ItemForestry(), "gearCopper");
        OreDictionary.registerOre((String)"gearCopper", (ItemStack)ForestryItem.gearCopper.getItemStack());
        ForestryItem.gearTin.registerItem(new ItemForestry(), "gearTin");
        OreDictionary.registerOre((String)"gearTin", (ItemStack)ForestryItem.gearTin.getItemStack());
        ForestryItem.circuitboards.registerItem(new ItemCircuitBoard(), "chipsets");
        ForestryItem.solderingIron.registerItem(new ItemSolderingIron(), "solderingIron");
        ForestryItem.tubes.registerItem(new ItemOverlay(CreativeTabForestry.tabForestry, new ItemOverlay.OverlayInfo("ex-0", 0xFFFFFF, 14923662), new ItemOverlay.OverlayInfo("ex-1", 0xFFFFFF, 14806772), new ItemOverlay.OverlayInfo("ex-2", 0xFFFFFF, 14533238), new ItemOverlay.OverlayInfo("ex-3", 0xFFFFFF, 0xD8D8D8), new ItemOverlay.OverlayInfo("ex-4", 0xFFFFFF, 0xFFFF8B), new ItemOverlay.OverlayInfo("ex-5", 0xFFFFFF, 8114616), new ItemOverlay.OverlayInfo("ex-6", 0xFFFFFF, 8809408), new ItemOverlay.OverlayInfo("ex-7", 16775294, 14247424), new ItemOverlay.OverlayInfo("ex-8", 0xFFFFFF, 0x444444), new ItemOverlay.OverlayInfo("ex-9", 0xFFFFFF, 0xBFFFDD), new ItemOverlay.OverlayInfo("ex-10", 0xFFFFFF, 6868206), new ItemOverlay.OverlayInfo("ex-11", 0xFFFFFF, 1857478)), "thermionicTubes");
        ForestryItem.carton.registerItem(new ItemForestry(), "carton");
        ForestryItem.crate.registerItem(new ItemForestry(), "crate");
        ForestryItem.stickImpregnated.registerItem(new ItemForestry(), "oakStick");
        ForestryItem.woodPulp.registerItem(new ItemForestry(), "woodPulp");
        OreDictionary.registerOre((String)"pulpWood", (ItemStack)ForestryItem.woodPulp.getItemStack());
        ForestryItem.brokenBronzePickaxe.registerItem(new ItemForestry(), "brokenBronzePickaxe");
        ForestryItem.brokenBronzeShovel.registerItem(new ItemForestry(), "brokenBronzeShovel");
        ForestryItem.bronzePickaxe.registerItem(new ItemForestryPickaxe(ForestryItem.brokenBronzePickaxe.getItemStack()), "bronzePickaxe");
        ForestryItem.bronzePickaxe.item().setHarvestLevel("pickaxe", 3);
        MinecraftForge.EVENT_BUS.register((Object)ForestryItem.bronzePickaxe.item());
        ForestryItem.bronzeShovel.registerItem(new ItemForestryShovel(ForestryItem.brokenBronzeShovel.getItemStack()), "bronzeShovel");
        ForestryItem.bronzeShovel.item().setHarvestLevel("shovel", 3);
        MinecraftForge.EVENT_BUS.register((Object)ForestryItem.bronzeShovel.item());
        ForestryItem.kitShovel.registerItem(new ItemAssemblyKit(ForestryItem.bronzeShovel.getItemStack()), "kitShovel");
        ForestryItem.kitPickaxe.registerItem(new ItemAssemblyKit(ForestryItem.bronzePickaxe.getItemStack()), "kitPickaxe");
        ForestryItem.mouldyWheat.registerItem(new ItemForestry(), "mouldyWheat");
        ForestryItem.decayingWheat.registerItem(new ItemForestry(), "decayingWheat");
        ForestryItem.mulch.registerItem(new ItemForestry(), "mulch");
        ForestryItem.iodineCharge.registerItem(new ItemForestry(), "iodineCapsule");
        ForestryItem.phosphor.registerItem(new ItemForestry(), "phosphor");
        ForestryItem.beeswax.registerItem(new ItemForestry().func_77637_a(Tabs.tabApiculture), "beeswax");
        OreDictionary.registerOre((String)"itemBeeswax", (ItemStack)ForestryItem.beeswax.getItemStack());
        ForestryItem.refractoryWax.registerItem(new ItemForestry(), "refractoryWax");
        ForestryItem.fruits.registerItem((Item)new ItemFruit(), "fruits");
        ForestryItem.waxCapsule.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.CAPSULE, -1).func_77625_d(64), "waxCapsule");
        ForestryItem.canEmpty.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.CAN, -1).func_77625_d(64), "canEmpty");
        ForestryItem.refractoryEmpty.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.REFRACTORY, -1).func_77625_d(64), "refractoryEmpty");
        ForestryItem.bucketBiomass.registerItem(new ItemForestry().func_77642_a(Items.field_151133_ar).func_77625_d(1), "bucketBiomass");
        ForestryItem.bucketBiofuel.registerItem(new ItemForestry().func_77642_a(Items.field_151133_ar).func_77625_d(1), "bucketBiofuel");
        ForestryItem.waxCapsuleWater.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.CAPSULE, 2372332), "waxCapsuleWater");
        ForestryItem.waxCapsuleBiomass.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.CAPSULE, 8639516), "waxCapsuleBiomass");
        ForestryItem.waxCapsuleBiofuel.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.CAPSULE, 16742665), "waxCapsuleBiofuel");
        ForestryItem.waxCapsuleOil.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.CAPSULE, 0x404040), "waxCapsuleOil");
        ForestryItem.waxCapsuleFuel.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.CAPSULE, 0xFFFF00), "waxCapsuleFuel");
        ForestryItem.waxCapsuleSeedOil.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.CAPSULE, 0xFFFFA9), "waxCapsuleSeedOil");
        ForestryItem.waxCapsuleHoney.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.CAPSULE, 16767559).setDrink(2, 0.2f), "waxCapsuleHoney");
        ForestryItem.waxCapsuleJuice.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.CAPSULE, 10080334).setDrink(2, 0.2f), "waxCapsuleJuice");
        ForestryItem.waxCapsuleIce.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.CAPSULE, 0xDCFFFF), "waxCapsuleIce");
        ForestryItem.canWater.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.CAN, 2372332), "waterCan");
        ForestryItem.canBiomass.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.CAN, 8639516), "biomassCan");
        ForestryItem.canBiofuel.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.CAN, 16742665), "biofuelCan");
        ForestryItem.canOil.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.CAN, 0x404040), "canOil");
        ForestryItem.canFuel.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.CAN, 0xFFFF00), "canFuel");
        ForestryItem.canLava.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.CAN, 16598559), "canLava");
        ForestryItem.canSeedOil.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.CAN, 0xFFFFA9), "canSeedOil");
        ForestryItem.canHoney.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.CAN, 16767559).setDrink(2, 0.2f), "canHoney");
        ForestryItem.canJuice.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.CAN, 10080334).setDrink(2, 0.2f), "canJuice");
        ForestryItem.canIce.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.CAN, 0xDCFFFF), "canIce");
        ForestryItem.refractoryWater.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.REFRACTORY, 2372332), "refractoryWater");
        ForestryItem.refractoryBiomass.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.REFRACTORY, 8639516), "refractoryBiomass");
        ForestryItem.refractoryBiofuel.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.REFRACTORY, 16742665), "refractoryBiofuel");
        ForestryItem.refractoryOil.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.REFRACTORY, 0x404040), "refractoryOil");
        ForestryItem.refractoryFuel.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.REFRACTORY, 0xFFFF00), "refractoryFuel");
        ForestryItem.refractoryLava.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.REFRACTORY, 16598559), "refractoryLava");
        ForestryItem.refractorySeedOil.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.REFRACTORY, 0xFFFFA9), "refractorySeedOil");
        ForestryItem.refractoryHoney.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.REFRACTORY, 16767559).setDrink(2, 0.2f), "refractoryHoney");
        ForestryItem.refractoryJuice.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.REFRACTORY, 10080334).setDrink(2, 0.2f), "refractoryJuice");
        ForestryItem.refractoryIce.registerItem(new ItemLiquidContainer(ItemLiquidContainer.EnumContainerType.REFRACTORY, 0xDCFFFF), "refractoryIce");
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerCrates() {
        ForestryItem.cratedWood.registerItem(new ItemCrated(new ItemStack(Blocks.field_150364_r)), "cratedWood");
        ForestryItem.cratedCobblestone.registerItem(new ItemCrated(new ItemStack(Blocks.field_150347_e)), "cratedCobblestone");
        ForestryItem.cratedDirt.registerItem(new ItemCrated(new ItemStack(Blocks.field_150346_d)), "cratedDirt");
        ForestryItem.cratedStone.registerItem(new ItemCrated(new ItemStack(Blocks.field_150348_b)), "cratedStone");
        ForestryItem.cratedBrick.registerItem(new ItemCrated(new ItemStack(Blocks.field_150336_V)), "cratedBrick");
        ForestryItem.cratedCacti.registerItem(new ItemCrated(new ItemStack(Blocks.field_150434_aF)), "cratedCacti");
        ForestryItem.cratedSand.registerItem(new ItemCrated(new ItemStack((Block)Blocks.field_150354_m)), "cratedSand");
        ForestryItem.cratedObsidian.registerItem(new ItemCrated(new ItemStack(Blocks.field_150343_Z)), "cratedObsidian");
        ForestryItem.cratedNetherrack.registerItem(new ItemCrated(new ItemStack(Blocks.field_150424_aL)), "cratedNetherrack");
        ForestryItem.cratedSoulsand.registerItem(new ItemCrated(new ItemStack(Blocks.field_150425_aM)), "cratedSoulsand");
        ForestryItem.cratedSandstone.registerItem(new ItemCrated(new ItemStack(Blocks.field_150322_A)), "cratedSandstone");
        ForestryItem.cratedBogearth.registerItem(new ItemCrated(ForestryBlock.soil.getItemStack(1, 1)), "cratedBogearth");
        ForestryItem.cratedHumus.registerItem(new ItemCrated(ForestryBlock.soil.getItemStack(1, 0)), "cratedHumus");
        ForestryItem.cratedNetherbrick.registerItem(new ItemCrated(new ItemStack(Blocks.field_150385_bj)), "cratedNetherbrick");
        ForestryItem.cratedPeat.registerItem(new ItemCrated(ForestryItem.peat.getItemStack()), "cratedPeat");
        ForestryItem.cratedApatite.registerItem(new ItemCrated(ForestryItem.apatite.getItemStack()), "cratedApatite");
        ForestryItem.cratedFertilizer.registerItem(new ItemCrated(ForestryItem.fertilizerCompound.getItemStack()), "cratedFertilizer");
        ForestryItem.cratedTin.registerItem(new ItemCrated(ForestryItem.ingotTin.getItemStack()), "cratedTin");
        ForestryItem.cratedCopper.registerItem(new ItemCrated(ForestryItem.ingotCopper.getItemStack()), "cratedCopper");
        ForestryItem.cratedBronze.registerItem(new ItemCrated(ForestryItem.ingotBronze.getItemStack()), "cratedBronze");
        ForestryItem.cratedWheat.registerItem(new ItemCrated(new ItemStack(Items.field_151015_O)), "cratedWheat");
        ForestryItem.cratedMycelium.registerItem(new ItemCrated(new ItemStack((Block)Blocks.field_150391_bh)), "cratedMycelium");
        ForestryItem.cratedMulch.registerItem(new ItemCrated(ForestryItem.mulch.getItemStack()), "cratedMulch");
        ForestryItem.cratedCookies.registerItem(new ItemCrated(new ItemStack(Items.field_151106_aX)), "cratedCookies");
        ForestryItem.cratedRedstone.registerItem(new ItemCrated(new ItemStack(Items.field_151137_ax)), "cratedRedstone");
        ForestryItem.cratedLapis.registerItem(new ItemCrated(new ItemStack(Items.field_151100_aR, 1, 4)), "cratedLapis");
        ForestryItem.cratedReeds.registerItem(new ItemCrated(new ItemStack(Items.field_151120_aE)), "cratedReeds");
        ForestryItem.cratedClay.registerItem(new ItemCrated(new ItemStack(Items.field_151119_aD)), "cratedClay");
        ForestryItem.cratedGlowstone.registerItem(new ItemCrated(new ItemStack(Items.field_151114_aO)), "cratedGlowstone");
        ForestryItem.cratedApples.registerItem(new ItemCrated(new ItemStack(Items.field_151034_e)), "cratedApples");
        ForestryItem.cratedNetherwart.registerItem(new ItemCrated(new ItemStack(Items.field_151075_bm)), "cratedNetherwart");
        ForestryItem.cratedPhosphor.registerItem(new ItemCrated(ForestryItem.phosphor.getItemStack()), "cratedPhosphor");
        ForestryItem.cratedAsh.registerItem(new ItemCrated(ForestryItem.ash.getItemStack()), "cratedAsh");
        ForestryItem.cratedCharcoal.registerItem(new ItemCrated(new ItemStack(Items.field_151044_h, 1, 1)), "cratedCharcoal");
        ForestryItem.cratedGravel.registerItem(new ItemCrated(new ItemStack(Blocks.field_150351_n)), "cratedGravel");
        ForestryItem.cratedCoal.registerItem(new ItemCrated(new ItemStack(Items.field_151044_h, 1, 0)), "cratedCoal");
        ForestryItem.cratedSeeds.registerItem(new ItemCrated(new ItemStack(Items.field_151014_N)), "cratedSeeds");
        ForestryItem.cratedSaplings.registerItem(new ItemCrated(new ItemStack(Blocks.field_150345_g)), "cratedSaplings");
    }

    @Override
    protected void registerRecipes() {
        if (Config.getCraftingBronzeEnabled()) {
            Proxies.common.addShapelessRecipe(ForestryItem.ingotBronze.getItemStack(4), "ingotTin", "ingotCopper", "ingotCopper", "ingotCopper");
        }
        Proxies.common.addRecipe(ForestryItem.sturdyCasing.getItemStack(), "###", "# #", "###", Character.valueOf('#'), "ingotBronze");
        Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.can"), " # ", "# #", Character.valueOf('#'), "ingotTin");
        if (PluginBuildCraft.stoneGear != null) {
            Proxies.common.addRecipe(ForestryItem.gearBronze.getItemStack(), " # ", "#Y#", " # ", Character.valueOf('#'), "ingotBronze", Character.valueOf('Y'), PluginBuildCraft.stoneGear);
            Proxies.common.addRecipe(ForestryItem.gearCopper.getItemStack(), " # ", "#Y#", " # ", Character.valueOf('#'), "ingotCopper", Character.valueOf('Y'), PluginBuildCraft.stoneGear);
            Proxies.common.addRecipe(ForestryItem.gearTin.getItemStack(), " # ", "#Y#", " # ", Character.valueOf('#'), "ingotTin", Character.valueOf('Y'), PluginBuildCraft.stoneGear);
        } else {
            Proxies.common.addRecipe(ForestryItem.gearBronze.getItemStack(), " # ", "#X#", " # ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "ingotCopper");
            Proxies.common.addRecipe(ForestryItem.gearCopper.getItemStack(), " # ", "#X#", " # ", Character.valueOf('#'), "ingotCopper", Character.valueOf('X'), "ingotCopper");
            Proxies.common.addRecipe(ForestryItem.gearTin.getItemStack(), " # ", "#X#", " # ", Character.valueOf('#'), "ingotTin", Character.valueOf('X'), "ingotCopper");
        }
        Proxies.common.addRecipe(ForestryItem.bronzePickaxe.getItemStack(), " X ", " X ", "###", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood");
        Proxies.common.addRecipe(ForestryItem.bronzeShovel.getItemStack(), " X ", " X ", " # ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood");
        Proxies.common.addShapelessRecipe(ForestryItem.kitPickaxe.getItemStack(), new Object[]{ForestryItem.bronzePickaxe, ForestryItem.carton});
        Proxies.common.addShapelessRecipe(ForestryItem.kitShovel.getItemStack(), new Object[]{ForestryItem.bronzeShovel, ForestryItem.carton});
        Proxies.common.addRecipe(ForestryItem.naturalistHat.getItemStack(), " X ", "Y Y", Character.valueOf('X'), "ingotBronze", Character.valueOf('Y'), Blocks.field_150410_aZ);
        Proxies.common.addRecipe(ForestryItem.wrench.getItemStack(), "# #", " # ", " # ", Character.valueOf('#'), "ingotBronze");
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.compost.wheat").field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.compost.wheat"), " X ", "X#X", " X ", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), Items.field_151015_O);
        }
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.compost.ash").field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.compost.ash"), " X ", "X#X", " X ", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), "dustAsh");
        }
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.fertilizer.apatite").field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.fertilizer.apatite"), " # ", " X ", " # ", Character.valueOf('#'), Blocks.field_150354_m, Character.valueOf('X'), "gemApatite");
        }
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.fertilizer.ash").field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.fertilizer.ash"), "###", "#X#", "###", Character.valueOf('#'), "dustAsh", Character.valueOf('X'), "gemApatite");
        }
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.humus.compost").field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.humus.compost"), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), ForestryItem.fertilizerBio});
        }
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.humus.fertilizer").field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.humus.fertilizer"), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), ForestryItem.fertilizerCompound});
        }
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.bogearth.bucket").field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.bogearth.bucket"), "#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), Items.field_151131_as, Character.valueOf('Y'), Blocks.field_150354_m);
        }
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.bogearth.can").field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.bogearth.can"), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), ForestryItem.canWater, Character.valueOf('Y'), Blocks.field_150354_m});
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.bogearth.can"), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), ForestryItem.waxCapsuleWater, Character.valueOf('Y'), Blocks.field_150354_m});
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.bogearth.can"), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), ForestryItem.refractoryWater, Character.valueOf('Y'), Blocks.field_150354_m});
        }
        Proxies.common.addRecipe(ForestryItem.vialCatalyst.getItemStack(3), new Object[]{"###", "YXY", Character.valueOf('#'), ForestryItem.waxCapsule.item(), Character.valueOf('X'), Items.field_151103_aS, Character.valueOf('Y'), ForestryItem.fertilizerCompound});
        Proxies.common.addRecipe(ForestryItem.vialCatalyst.getItemStack(3), new Object[]{"###", "YXY", Character.valueOf('#'), ForestryItem.canEmpty.item(), Character.valueOf('X'), Items.field_151103_aS, Character.valueOf('Y'), ForestryItem.fertilizerCompound});
        Proxies.common.addRecipe(new ItemStack(Items.field_151007_F), "#", "#", "#", Character.valueOf('#'), ForestryItem.craftingMaterial.getItemStack(1, 2));
        Proxies.common.addRecipe(ForestryItem.pipette.getItemStack(), "  #", " X ", "X  ", Character.valueOf('X'), Blocks.field_150410_aZ, Character.valueOf('#'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE));
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }

    @Override
    public IPickupHandler getPickupHandler() {
        return new PickupHandlerCore();
    }

    @Override
    public ICommand[] getConsoleCommands() {
        return new ICommand[]{new CommandForestry()};
    }

    public int getBurnTime(ItemStack fuel) {
        if (fuel != null && fuel.func_77973_b() == ForestryItem.peat.item()) {
            return 2000;
        }
        if (fuel != null && fuel.func_77973_b() == ForestryItem.bituminousPeat.item()) {
            return 4200;
        }
        return 0;
    }

    public IRecipe[] createAlyzerRecipes(Block block, int meta) {
        ArrayList<ShapedRecipeCustom> recipes = new ArrayList<ShapedRecipeCustom>();
        if (ForestryItem.beealyzer != null) {
            recipes.add(ShapedRecipeCustom.createShapedRecipe(new ItemStack(block, 1, meta), new Object[]{"XTX", " Y ", "X X", Character.valueOf('Y'), ForestryItem.sturdyCasing, Character.valueOf('T'), ForestryItem.beealyzer, Character.valueOf('X'), "ingotBronze"}));
        }
        if (ForestryItem.treealyzer != null) {
            recipes.add(ShapedRecipeCustom.createShapedRecipe(new ItemStack(block, 1, meta), new Object[]{"XTX", " Y ", "X X", Character.valueOf('Y'), ForestryItem.sturdyCasing, Character.valueOf('T'), ForestryItem.treealyzer, Character.valueOf('X'), "ingotBronze"}));
        }
        return recipes.toArray(new IRecipe[0]);
    }
}

