/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.core.PluginInfo;
import forestry.api.farming.Farmables;
import forestry.core.interfaces.IOreDictionaryHandler;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.proxy.Proxies;
import forestry.farming.logic.FarmableFarmCraftory;
import forestry.plugins.NativePlugin;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

@PluginInfo(pluginID="FarmCraftory", name="FarmCraftory", author="SirSengir", url="http://forestry.sengir.net/", description="Enables compatibility with FarmCraftory. Adds crops and vegetables to farms.")
public class PluginFarmCraftory
extends NativePlugin {
    public static Block blockSingle;
    public static Block blockMulti;
    public static Class<?> classSingle;
    public static Class<?> classMulti;
    public static Method methodGrowthSingle;
    public static Method methodGrowthMulti;
    public static HashMap<String, ItemStack> vegetableSeeds;
    public static final String[] seedIdentifiers;
    public static HashMap<String, ItemStack> vegetableItems;
    public static final String[] vegetableIdentifiers;
    public static HashMap<String, ItemStack> cerealSeeds;
    public static final String[] cseedIdentifiers;
    public static HashMap<String, ItemStack> cerealItems;
    public static final String[] cerealIdentifiers;

    @Override
    public boolean isAvailable() {
        return Proxies.common.isModLoaded("FarmCraftory");
    }

    @Override
    public void doInit() {
        super.doInit();
        try {
            blockSingle = (Block)Class.forName("farmcraftory.FarmCraftory").getField("singleHarvest").get(null);
            blockMulti = (Block)Class.forName("farmcraftory.FarmCraftory").getField("multiHarvest").get(null);
            classSingle = Class.forName("farmcraftory.TileEntitySingleHarvest");
            classMulti = Class.forName("farmcraftory.TileEntityMultiHarvest");
            methodGrowthSingle = classSingle.getMethod("getGrowthStage", new Class[0]);
            methodGrowthMulti = classMulti.getMethod("getGrowthStage", new Class[0]);
            for (String str : seedIdentifiers) {
                try {
                    vegetableSeeds.put(str, new ItemStack((Item)Class.forName("farmcraftory.FarmCraftory").getField(str).get(null)));
                }
                catch (Exception ex) {
                    Proxies.log.info("FarmCraftory item '%s' could not be integrated.", (Object)str);
                    Proxies.log.info(ex.getMessage());
                }
            }
            for (String str : vegetableIdentifiers) {
                try {
                    vegetableItems.put(str, new ItemStack((Item)Class.forName("farmcraftory.FarmCraftory").getField(str).get(null)));
                }
                catch (Exception ex) {
                    Proxies.log.info("FarmCraftory item '%s' could not be integrated.", (Object)str);
                    Proxies.log.info(ex.getMessage());
                }
            }
            for (String str : cseedIdentifiers) {
                try {
                    cerealSeeds.put(str, new ItemStack((Item)Class.forName("farmcraftory.FarmCraftory").getField(str).get(null)));
                }
                catch (Exception ex) {
                    Proxies.log.info("FarmCraftory item '%s' could not be integrated.", (Object)str);
                    Proxies.log.info(ex.getMessage());
                }
            }
            for (String str : cerealIdentifiers) {
                try {
                    cerealItems.put(str, new ItemStack((Item)Class.forName("farmcraftory.FarmCraftory").getField(str).get(null)));
                }
                catch (Exception ex) {
                    Proxies.log.info("FarmCraftory item '%s' could not be integrated.", (Object)str);
                    Proxies.log.info(ex.getMessage());
                }
            }
            if (blockMulti != null && blockSingle != null) {
                Farmables.farmables.get("farmWheat").add(new FarmableFarmCraftory(cerealSeeds.values(), cerealItems.values()));
                Farmables.farmables.get("farmVegetables").add(new FarmableFarmCraftory(vegetableSeeds.values(), vegetableItems.values()));
            }
        }
        catch (Exception ex) {
            Proxies.log.info("FarmCraftory plugin unexpectedly failed to load.");
            Proxies.log.info(ex.getMessage());
        }
    }

    public static int getGrowthStage(TileEntity tile) {
        try {
            if (classSingle.isInstance(tile)) {
                return (Integer)methodGrowthSingle.invoke((Object)tile, new Object[0]);
            }
            if (classMulti.isInstance(tile)) {
                return (Integer)methodGrowthMulti.invoke((Object)tile, new Object[0]);
            }
        }
        catch (Exception ex) {
            return 0;
        }
        return 0;
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return null;
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return null;
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }

    @Override
    protected void registerItems() {
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    protected void registerRecipes() {
    }

    static {
        vegetableSeeds = new HashMap();
        seedIdentifiers = new String[]{"turnipSeedBag", "cabbageSeedBag", "onionSeedBag", "spinachSeedBag", "leekSeedBag", "cucumberSeedBag", "tomatoSeedBag", "eggplantSeedBag", "greenPepperSeedBag", "yamSeedBag", "strawberrySeedBag", "pineappleSeedBag"};
        vegetableItems = new HashMap();
        vegetableIdentifiers = new String[]{"turnipItem", "cabbageItem", "onionItem", "spinachItem", "leekItem", "cucumberItem", "tomatoItem", "eggplantItem", "greenPepperItem", "yamItem", "strawberryItem", "pineappleItem"};
        cerealSeeds = new HashMap();
        cseedIdentifiers = new String[]{"cornSeedBag"};
        cerealItems = new HashMap();
        cerealIdentifiers = new String[]{"cornItem"};
    }
}

