/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.core.IPlugin;
import forestry.core.ForestryCore;
import forestry.core.interfaces.IOreDictionaryHandler;
import forestry.core.interfaces.IPacketHandler;
import forestry.core.interfaces.IPickupHandler;
import forestry.core.interfaces.IResupplyHandler;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.proxy.Proxies;
import forestry.plugins.NativePlugin;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class PluginManager {
    public static ArrayList<IPlugin> plugins = new ArrayList();
    public static ArrayList<IGuiHandler> guiHandlers = new ArrayList();
    public static ArrayList<IPacketHandler> packetHandlers = new ArrayList();
    public static ArrayList<IPickupHandler> pickupHandlers = new ArrayList();
    public static ArrayList<ISaveEventHandler> saveEventHandlers = new ArrayList();
    public static ArrayList<IResupplyHandler> resupplyHandlers = new ArrayList();
    public static ArrayList<IOreDictionaryHandler> dictionaryHandlers = new ArrayList();

    public static void loadPlugins(File modLocation) {
        PluginManager.loadIncludedPlugins(modLocation);
        PluginManager.loadExternalPlugins(modLocation);
    }

    private static void loadIncludedPlugins(File modLocation) {
        ClassLoader classLoader = ForestryCore.class.getClassLoader();
        if (modLocation.isFile() && (modLocation.getName().endsWith(".jar") || modLocation.getName().endsWith(".zip"))) {
            PluginManager.loadPluginsFromFile(modLocation, classLoader);
        } else if (modLocation.isDirectory()) {
            PluginManager.loadPluginsFromBin(modLocation, classLoader);
        }
    }

    private static void loadExternalPlugins(File modLocation) {
        try {
            File pluginDir = new File(Proxies.common.getForestryRoot() + "/mods");
            ClassLoader classLoader = ForestryCore.class.getClassLoader();
            if (!pluginDir.isDirectory()) {
                return;
            }
            File[] fileList = pluginDir.listFiles();
            if (fileList == null) {
                return;
            }
            for (File file : fileList) {
                if (!file.isFile() || !file.getName().endsWith(".jar") && !file.getName().endsWith(".zip") || file.getName().equals(modLocation.getName())) continue;
                PluginManager.loadPluginsFromFile(file, classLoader);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void loadPluginsFromFile(File file, ClassLoader classLoader) {
        try {
            ZipEntry entry = null;
            FileInputStream fileIO = new FileInputStream(file);
            ZipInputStream zipIO = new ZipInputStream(fileIO);
            while (true) {
                if ((entry = zipIO.getNextEntry()) == null) {
                    fileIO.close();
                    break;
                }
                String entryName = entry.getName();
                File entryFile = new File(entryName);
                String pluginName = entryFile.getName();
                if (entry.isDirectory() || !pluginName.startsWith("Plugin") || !pluginName.endsWith(".class")) continue;
                PluginManager.addPlugin(classLoader, pluginName, entryFile.getPath().replace(File.separatorChar, '.'));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String parseClassName(String binpath) {
        String[] tokens = binpath.split("[\\\\/]");
        String packageName = "";
        boolean inIdea = false;
        for (int i = 0; i < tokens.length && tokens[i] != null; ++i) {
            int j;
            if (tokens[i].equals("production") || tokens[i].equals("classes")) {
                inIdea = true;
            }
            if (!tokens[i].equals("bin") && !inIdea) continue;
            int n = j = inIdea ? i + 2 : i + 1;
            while (j < tokens.length) {
                if (packageName.length() > 0) {
                    packageName = packageName + ".";
                }
                packageName = packageName + tokens[j];
                ++j;
            }
            break;
        }
        return packageName;
    }

    private static void loadPluginsFromBin(File bin, ClassLoader classLoader) {
        File[] fileList = bin.listFiles();
        Arrays.sort(fileList, new Comparator<File>(){

            @Override
            public int compare(File a, File b) {
                return a.getName().toLowerCase().compareTo(b.getName().toLowerCase());
            }
        });
        for (File file : fileList) {
            String pluginName = file.getName();
            if (file.isFile() && pluginName.startsWith("Plugin") && pluginName.endsWith(".class")) {
                PluginManager.addPlugin(classLoader, pluginName, PluginManager.parseClassName(file.getPath()));
                continue;
            }
            if (!file.isDirectory()) continue;
            PluginManager.loadPluginsFromBin(file, classLoader);
        }
    }

    public static void addPlugin(ClassLoader classLoader, String pluginName, String packageName) {
        if (pluginName.equals("PluginManager.class") || pluginName.equals("PluginInfo.class")) {
            return;
        }
        String pluginClassName = packageName.replace(".class", "").replace("minecraft.", "");
        try {
            Class<?> pluginClass = null;
            try {
                pluginClass = classLoader.loadClass(pluginClassName);
            }
            catch (Throwable error) {
                // empty catch block
            }
            if (pluginClass == null) {
                pluginClass = Class.forName(pluginClassName);
            }
            if (pluginClass != null) {
                Class<?> clz = pluginClass;
                boolean isPlugin = false;
                block4: do {
                    for (Class<?> i : clz.getInterfaces()) {
                        if (i != IPlugin.class) continue;
                        isPlugin = true;
                        continue block4;
                    }
                } while ((clz = clz.getSuperclass()) != null && !isPlugin);
                if (!isPlugin) {
                    return;
                }
                IPlugin plugin = (IPlugin)pluginClass.newInstance();
                if (plugin != null) {
                    Proxies.log.fine("Found plugin " + plugin.toString());
                    plugins.add(plugin);
                    if (plugin instanceof NativePlugin) {
                        IOreDictionaryHandler dictionaryHandler;
                        IResupplyHandler resupplyHandler;
                        ISaveEventHandler saveHandler;
                        IPickupHandler pickupHandler;
                        IPacketHandler packetHandler;
                        NativePlugin nplugin = (NativePlugin)plugin;
                        IGuiHandler guiHandler = nplugin.getGuiHandler();
                        if (guiHandler != null) {
                            guiHandlers.add(guiHandler);
                        }
                        if ((packetHandler = nplugin.getPacketHandler()) != null) {
                            packetHandlers.add(packetHandler);
                        }
                        if ((pickupHandler = nplugin.getPickupHandler()) != null) {
                            pickupHandlers.add(pickupHandler);
                        }
                        if ((saveHandler = nplugin.getSaveEventHandler()) != null) {
                            saveEventHandlers.add(saveHandler);
                        }
                        if ((resupplyHandler = nplugin.getResupplyHandler()) != null) {
                            resupplyHandlers.add(resupplyHandler);
                        }
                        if ((dictionaryHandler = nplugin.getDictionaryHandler()) != null) {
                            dictionaryHandlers.add(dictionaryHandler);
                        }
                    }
                    if (plugin instanceof IFuelHandler) {
                        GameRegistry.registerFuelHandler((IFuelHandler)((IFuelHandler)plugin));
                    }
                }
            }
        }
        catch (Throwable ex) {
            // empty catch block
        }
    }
}

