/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.items;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.ForestryAPI;
import forestry.api.storage.BackpackStowEvent;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.wrappers.IInvSlot;
import forestry.core.inventory.wrappers.InventoryIterator;
import forestry.core.items.ItemInventoried;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.ItemInventory;
import forestry.core.utils.StringUtil;
import forestry.storage.BackpackMode;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemBackpack
extends ItemInventoried {
    private final IBackpackDefinition info;
    private final EnumBackpackType type;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemBackpack(IBackpackDefinition info, EnumBackpackType type) {
        this.info = info;
        this.type = type;
        this.func_77625_d(1);
    }

    public IBackpackDefinition getDefinition() {
        return this.info;
    }

    public boolean func_77651_p() {
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer player) {
        if (!Proxies.common.isSimulating(world)) {
            return itemstack;
        }
        if (!player.func_70093_af()) {
            this.openGui(player, itemstack);
        } else {
            this.switchMode(itemstack);
        }
        return itemstack;
    }

    @Override
    public boolean func_77648_a(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return this.getInventoryHit(world, x, y, z, side) != null;
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!Proxies.common.isSimulating(world)) {
            return false;
        }
        if (!player.func_70093_af()) {
            return false;
        }
        return this.evaluateTileHit(itemstack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public ItemStack tryStowing(EntityPlayer player, ItemStack backpackStack, ItemStack stack) {
        ItemBackpack backpack = (ItemBackpack)backpackStack.func_77973_b();
        ItemInventory inventory = new ItemInventory(ItemBackpack.class, backpack.getBackpackSize(), backpackStack);
        if (backpackStack.func_77960_j() == 1) {
            return stack;
        }
        BackpackStowEvent event = new BackpackStowEvent(player, backpack.getDefinition(), inventory, stack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (stack.field_77994_a <= 0) {
            return null;
        }
        if (event.isCanceled()) {
            return stack;
        }
        ItemStack remainder = InvTools.moveItemStack(stack, inventory);
        stack.field_77994_a = remainder == null ? 0 : remainder.field_77994_a;
        inventory.save();
        return null;
    }

    private void switchMode(ItemStack itemstack) {
        BackpackMode mode = ItemBackpack.getMode(itemstack);
        if (mode == BackpackMode.RESUPPLY) {
            itemstack.func_77964_b(0);
        } else if (mode == BackpackMode.RECEIVE) {
            itemstack.func_77964_b(3);
        } else if (mode == BackpackMode.LOCKED) {
            itemstack.func_77964_b(2);
        } else {
            itemstack.func_77964_b(1);
        }
    }

    private IInventory getInventoryHit(World world, int x, int y, int z, int side) {
        TileEntity targeted = world.func_147438_o(x, y, z);
        return InvTools.getInventoryFromTile(targeted, ForgeDirection.getOrientation((int)side));
    }

    private boolean evaluateTileHit(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        IInventory inventory = this.getInventoryHit(world, x, y, z, side);
        if (inventory != null) {
            if (inventory.func_70302_i_() <= 0) {
                return true;
            }
            ItemInventory backpackInventory = new ItemInventory(ItemBackpack.class, this.getBackpackSize(), stack);
            if (stack.func_77960_j() == 2) {
                this.tryChestReceive(player, backpackInventory, inventory);
            } else {
                this.tryChestTransfer(backpackInventory, inventory);
            }
            backpackInventory.save();
            return true;
        }
        return false;
    }

    private void tryChestTransfer(ItemInventory backpackInventory, IInventory target) {
        for (IInvSlot slot : InventoryIterator.getIterable(backpackInventory)) {
            ItemStack packStack = slot.getStackInSlot();
            if (packStack == null) continue;
            ItemStack remaining = InvTools.moveItemStack(packStack, target);
            slot.setStackInSlot(remaining);
        }
    }

    private void tryChestReceive(EntityPlayer player, ItemInventory backpackInventory, IInventory target) {
        for (IInvSlot slot : InventoryIterator.getIterable(target)) {
            ItemStack targetStack = slot.getStackInSlot();
            if (targetStack == null || !this.info.isValidItem(player, targetStack)) continue;
            ItemStack remaining = InvTools.moveItemStack(targetStack, backpackInventory);
            slot.setStackInSlot(remaining);
        }
    }

    public void openGui(EntityPlayer entityplayer, ItemStack itemstack) {
        if (this.getBackpackSize() == 15) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.BackpackGUI.ordinal(), entityplayer.field_70170_p, (int)entityplayer.field_70165_t, (int)entityplayer.field_70163_u, (int)entityplayer.field_70161_v);
        } else if (this.getBackpackSize() == 45) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.BackpackT2GUI.ordinal(), entityplayer.field_70170_p, (int)entityplayer.field_70165_t, (int)entityplayer.field_70163_u, (int)entityplayer.field_70161_v);
        }
    }

    public boolean isBackpack(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.func_77973_b() == this;
    }

    public int getBackpackSize() {
        return ItemBackpack.getSlotsForType(this.type);
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        ItemInventory inventory = new ItemInventory(ItemBackpack.class, this.getBackpackSize(), itemstack);
        int occupied = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i) == null || inventory.func_70301_a((int)i).field_77994_a <= 0) continue;
            ++occupied;
        }
        BackpackMode mode = ItemBackpack.getMode(itemstack);
        if (mode == BackpackMode.LOCKED) {
            list.add(StringUtil.localize("storage.backpack.mode.locked"));
        } else if (mode == BackpackMode.RECEIVE) {
            list.add(StringUtil.localize("storage.backpack.mode.receiving"));
        } else if (mode == BackpackMode.RESUPPLY) {
            list.add(StringUtil.localize("storage.backpack.mode.resupply"));
        }
        list.add(StringUtil.localize("gui.slots").replaceAll("%USED", String.valueOf(occupied)).replaceAll("%SIZE", String.valueOf(this.getBackpackSize())));
    }

    public String func_77653_i(ItemStack itemstack) {
        try {
            return this.info.getName(itemstack);
        }
        catch (Error er) {
            return this.info.getName();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.icons = new IIcon[6];
        EnumBackpackType t = this.type == EnumBackpackType.APIARIST ? EnumBackpackType.T1 : this.type;
        String typeTag = "backpacks/" + t.toString().toLowerCase(Locale.ENGLISH);
        this.icons[0] = TextureManager.getInstance().registerTex(register, typeTag + ".cloth");
        this.icons[1] = TextureManager.getInstance().registerTex(register, typeTag + ".outline");
        this.icons[2] = TextureManager.getInstance().registerTex(register, "backpacks/neutral");
        this.icons[3] = TextureManager.getInstance().registerTex(register, "backpacks/locked");
        this.icons[4] = TextureManager.getInstance().registerTex(register, "backpacks/receive");
        this.icons[5] = TextureManager.getInstance().registerTex(register, "backpacks/resupply");
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 3;
    }

    public int func_82790_a(ItemStack itemstack, int j) {
        if (j == 0) {
            return this.info.getPrimaryColour();
        }
        if (j == 1) {
            return this.info.getSecondaryColour();
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int i, int j) {
        if (j == 0) {
            return this.icons[0];
        }
        if (j == 1) {
            return this.icons[1];
        }
        if (i > 2) {
            return this.icons[5];
        }
        if (i > 1) {
            return this.icons[4];
        }
        if (i > 0) {
            return this.icons[3];
        }
        return this.icons[2];
    }

    public static int getSlotsForType(EnumBackpackType type) {
        switch (type) {
            case APIARIST: {
                return 125;
            }
            case T2: {
                return 45;
            }
        }
        return 15;
    }

    public static BackpackMode getMode(ItemStack backpack) {
        int meta = backpack.func_77960_j();
        if (meta >= 3) {
            return BackpackMode.RESUPPLY;
        }
        if (meta >= 2) {
            return BackpackMode.RECEIVE;
        }
        if (meta >= 1) {
            return BackpackMode.LOCKED;
        }
        return BackpackMode.NORMAL;
    }
}

