/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.core;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BCLog {
    public static final Logger logger = Logger.getLogger("Buildcraft");

    private BCLog() {
    }

    public static void initLog() {
        logger.info("Starting BuildCraft " + BCLog.getVersion());
        logger.info("Copyright (c) SpaceToad, 2011");
        logger.info("http://www.mod-buildcraft.com");
    }

    public static void logErrorAPI(String mod, Throwable error, Class classFile) {
        StringBuilder msg = new StringBuilder(mod);
        msg.append(" API error, please update your mods. Error: ").append(error);
        StackTraceElement[] stackTrace = error.getStackTrace();
        if (stackTrace.length > 0) {
            msg.append(", ").append(stackTrace[0]);
        }
        logger.log(Level.SEVERE, msg.toString());
        if (classFile != null) {
            msg = new StringBuilder(mod);
            msg.append(" API error: ").append(classFile.getSimpleName()).append(" is loaded from ").append(classFile.getProtectionDomain().getCodeSource().getLocation());
            logger.log(Level.SEVERE, msg.toString());
        }
    }

    public static String getVersion() {
        try {
            Class<?> clazz = Class.forName("buildcraft.core.Version");
            Method method = clazz.getDeclaredMethod("getVersion", new Class[0]);
            return String.valueOf(method.invoke(null, new Object[0]));
        }
        catch (Exception e) {
            return "UNKNOWN VERSION";
        }
    }
}

