/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.core.utils.StringUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class FlowerProviderCacti
implements IFlowerProvider {
    @Override
    public boolean isAcceptedFlower(World world, IIndividual individual, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150457_bL) {
            return this.checkFlowerPot(world.func_72805_g(x, y, z));
        }
        return block == Blocks.field_150434_aF;
    }

    @Override
    public boolean isAcceptedPollinatable(World world, IPollinatable pollinatable) {
        return pollinatable.getPlantType().contains(EnumPlantType.Desert);
    }

    private boolean checkFlowerPot(int meta) {
        return meta == 9;
    }

    @Override
    public boolean growFlower(World world, IIndividual individual, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150457_bL && world.func_72805_g(x, y, z) == 0) {
            return this.growInPot(world, x, y, z);
        }
        return false;
    }

    private boolean growInPot(World world, int x, int y, int z) {
        if (world.field_73012_v.nextBoolean()) {
            world.func_147465_d(x, y, z, Blocks.field_150457_bL, 9, 2);
        } else {
            world.func_147465_d(x, y, z, Blocks.field_150457_bL, 10, 2);
        }
        return true;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize("flowers.cacti");
    }

    @Override
    public ItemStack[] affectProducts(World world, IIndividual individual, int x, int y, int z, ItemStack[] products) {
        return products;
    }

    @Override
    public ItemStack[] getItemStacks() {
        return new ItemStack[]{new ItemStack(Blocks.field_150434_aF)};
    }
}

