/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.core.utils.StringUtil;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class FlowerProviderJungle
implements IFlowerProvider {
    @Override
    public boolean isAcceptedFlower(World world, IIndividual individual, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block == Blocks.field_150457_bL) {
            return this.checkFlowerPot(meta);
        }
        return block == Blocks.field_150395_bd || block == Blocks.field_150329_H && meta == 2;
    }

    @Override
    public boolean isAcceptedPollinatable(World world, IPollinatable pollinatable) {
        EnumSet<EnumPlantType> types = pollinatable.getPlantType();
        return types.size() > 1 || !types.contains(EnumPlantType.Nether);
    }

    private boolean checkFlowerPot(int meta) {
        return meta == 11;
    }

    @Override
    public boolean growFlower(World world, IIndividual individual, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150457_bL) {
            return this.growInPot(world, x, y, z);
        }
        return false;
    }

    private boolean growInPot(World world, int x, int y, int z) {
        world.func_147465_d(x, y, z, Blocks.field_150457_bL, 11, 2);
        return true;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize("flowers.jungle");
    }

    @Override
    public ItemStack[] affectProducts(World world, IIndividual individual, int x, int y, int z, ItemStack[] products) {
        return products;
    }

    @Override
    public ItemStack[] getItemStacks() {
        return new ItemStack[]{new ItemStack(Blocks.field_150395_bd), new ItemStack((Block)Blocks.field_150329_H, 1, 2)};
    }
}

