/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.core.utils.StringUtil;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class FlowerProviderMushroom
implements IFlowerProvider {
    @Override
    public boolean isAcceptedFlower(World world, IIndividual individual, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150457_bL) {
            return this.checkFlowerPot(world.func_72805_g(x, y, z));
        }
        return block == Blocks.field_150338_P || block == Blocks.field_150337_Q;
    }

    @Override
    public boolean isAcceptedPollinatable(World world, IPollinatable pollinatable) {
        EnumSet<EnumPlantType> types = pollinatable.getPlantType();
        return types.size() > 1 || !types.contains(EnumPlantType.Nether);
    }

    private boolean checkFlowerPot(int meta) {
        return meta == 7 || meta == 8;
    }

    @Override
    public boolean growFlower(World world, IIndividual individual, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (!block.isAir((IBlockAccess)world, x, y, z)) {
            if (block == Blocks.field_150457_bL) {
                return this.growInPot(world, x, y, z);
            }
            return false;
        }
        Block ground = world.func_147439_a(x, y - 1, z);
        if (ground != Blocks.field_150391_bh) {
            return false;
        }
        BlockBush mushroom = world.field_73012_v.nextBoolean() ? Blocks.field_150338_P : Blocks.field_150337_Q;
        world.func_147465_d(x, y, z, (Block)mushroom, 0, 2);
        return true;
    }

    private boolean growInPot(World world, int x, int y, int z) {
        if (world.field_73012_v.nextBoolean()) {
            world.func_147465_d(x, y, z, Blocks.field_150457_bL, 7, 2);
        } else {
            world.func_147465_d(x, y, z, Blocks.field_150457_bL, 8, 2);
        }
        return true;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize("flowers.mushroom");
    }

    @Override
    public ItemStack[] affectProducts(World world, IIndividual individual, int x, int y, int z, ItemStack[] products) {
        return products;
    }

    @Override
    public ItemStack[] getItemStacks() {
        return new ItemStack[]{new ItemStack((Block)Blocks.field_150338_P), new ItemStack((Block)Blocks.field_150337_Q)};
    }
}

