/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.FlowerManager;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.core.utils.StackUtils;
import forestry.core.utils.StringUtil;
import java.util.Collections;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class FlowerProviderVanilla
implements IFlowerProvider {
    @Override
    public boolean isAcceptedFlower(World world, IIndividual individual, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block == Blocks.field_150457_bL) {
            return this.checkFlowerPot(meta);
        }
        ItemStack flower = new ItemStack(block, 1, meta);
        for (ItemStack stack : FlowerManager.plainFlowers) {
            if (!flower.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcceptedPollinatable(World world, IPollinatable pollinatable) {
        EnumSet<EnumPlantType> types = pollinatable.getPlantType();
        return types.size() > 1 || !types.contains(EnumPlantType.Nether);
    }

    private boolean checkFlowerPot(int meta) {
        return meta == 1 || meta == 2;
    }

    @Override
    public boolean growFlower(World world, IIndividual individual, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (!block.isAir((IBlockAccess)world, x, y, z)) {
            if (block == Blocks.field_150457_bL && world.func_72805_g(x, y, z) == 0) {
                return this.growInPot(world, x, y, z);
            }
            return false;
        }
        Block ground = world.func_147439_a(x, y - 1, z);
        if (ground != Blocks.field_150346_d && ground != Blocks.field_150349_c) {
            return false;
        }
        Collections.shuffle(FlowerManager.plainFlowers);
        ItemStack flower = FlowerManager.plainFlowers.get(world.field_73012_v.nextInt(FlowerManager.plainFlowers.size() - 1));
        world.func_147465_d(x, y, z, StackUtils.getBlock(flower), flower.func_77960_j(), 2);
        return true;
    }

    private boolean growInPot(World world, int x, int y, int z) {
        if (world.field_73012_v.nextBoolean()) {
            world.func_147465_d(x, y, z, Blocks.field_150457_bL, 1, 2);
        } else {
            world.func_147465_d(x, y, z, Blocks.field_150457_bL, 2, 2);
        }
        return true;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize("flowers.vanilla");
    }

    @Override
    public ItemStack[] affectProducts(World world, IIndividual individual, int x, int y, int z, ItemStack[] products) {
        return products;
    }

    @Override
    public ItemStack[] getItemStacks() {
        return FlowerManager.plainFlowers.toArray(new ItemStack[0]);
    }
}

