/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import forestry.apiculture.gadgets.TileCandle;
import forestry.core.ForestryClient;
import forestry.core.render.TextureManager;
import forestry.core.utils.StackUtils;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class BlockCandle
extends BlockTorch {
    private final ArrayList<Item> lightingItems = new ArrayList();
    @SideOnly(value=Side.CLIENT)
    private IIcon litStump;
    @SideOnly(value=Side.CLIENT)
    private IIcon litTip;
    @SideOnly(value=Side.CLIENT)
    private IIcon unlitStump;
    @SideOnly(value=Side.CLIENT)
    private IIcon unlitTip;
    private static final String[] dyes = new String[]{"dyeWhite", "dyeOrange", "dyeMagenta", "dyeLightBlue", "dyeYellow", "dyeLime", "dyePink", "dyeGray", "dyeLightGray", "dyeCyan", "dyePurple", "dyeBlue", "dyeBrown", "dyeGreen", "dyeRed", "dyeBlack"};
    private static final int[][] colours = new int[][]{{255, 255, 255}, {219, 125, 62}, {255, 20, 255}, {107, 138, 201}, {255, 255, 20}, {20, 255, 20}, {208, 132, 153}, {74, 74, 74}, {154, 161, 161}, {20, 255, 255}, {126, 61, 181}, {20, 20, 255}, {79, 50, 31}, {53, 70, 27}, {150, 52, 48}, {20, 20, 20}};
    public static final String colourTagName = "colour";

    public BlockCandle() {
        this.func_149711_c(0.0f);
        this.func_149672_a(field_149766_f);
        this.func_149647_a(Tabs.tabApiculture);
        this.lightingItems.add(Items.field_151033_d);
        this.lightingItems.add(Items.field_151145_ak);
        this.lightingItems.add(Item.func_150898_a((Block)Blocks.field_150478_aa));
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileCandle();
    }

    public int func_149645_b() {
        return ForestryClient.candleRenderId;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        String fileBase = StringUtil.cleanBlockName((Block)this);
        this.field_149761_L = TextureManager.getInstance().registerTex(register, "stump");
        this.litStump = TextureManager.getInstance().registerTex(register, fileBase + "StumpLit");
        this.litTip = TextureManager.getInstance().registerTex(register, fileBase + "TipLit");
        this.unlitStump = TextureManager.getInstance().registerTex(register, fileBase + "StumpUnlit");
        this.unlitTip = TextureManager.getInstance().registerTex(register, fileBase + "TipUnlit");
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return BlockCandle.isLit(meta) ? 14 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getTextureFromPassAndMeta(int meta, int pass) {
        IIcon i = this.unlitStump;
        i = pass == 0 ? (BlockCandle.isLit(meta) ? this.litTip : this.unlitTip) : (BlockCandle.isLit(meta) ? this.litStump : this.unlitStump);
        return i;
    }

    public int getColourFromItemStack(ItemStack stack) {
        int colour = 0xFFFFFF;
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            colour = tag.func_74771_c("red") << 16 | tag.func_74771_c("green") << 8 | tag.func_74771_c("blue");
        }
        return colour;
    }

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        itemList.add(new ItemStack((Block)this, 1, 0));
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int facing, float facingX, float facingY, float facingZ) {
        boolean flag = false;
        int meta = world.func_72805_g(x, y, z);
        boolean toggleLitState = true;
        ItemStack held = player.func_71045_bC();
        if (!BlockCandle.isLit(meta)) {
            if (held == null || !this.lightingItems.contains(held.func_77973_b())) {
                toggleLitState = false;
            } else if (StackUtils.equals((Block)this, held) && BlockCandle.isLit(held)) {
                toggleLitState = true;
            }
        }
        if (held != null) {
            TileCandle te = (TileCandle)world.func_147438_o(x, y, z);
            if (te == null) {
                world.func_147455_a(x, y, z, this.createTileEntity(world, meta));
            }
            if (StackUtils.equals((Block)this, held)) {
                if (!BlockCandle.isLit(held)) {
                    if (held.func_77942_o() && held.func_77978_p().func_74764_b(colourTagName)) {
                        te.setColour(held.func_77978_p().func_74762_e(colourTagName));
                    } else {
                        te.setColour(0xFFFFFF);
                    }
                } else {
                    toggleLitState = true;
                }
                flag = true;
            } else {
                boolean matched = false;
                for (int i = 0; i < dyes.length; ++i) {
                    for (ItemStack stack : OreDictionary.getOres((String)dyes[i])) {
                        if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)held, (boolean)true)) continue;
                        if (BlockCandle.isLit(meta)) {
                            te.setColour(colours[i][0], colours[i][1], colours[i][2]);
                        } else {
                            te.addColour(colours[i][0], colours[i][1], colours[i][2]);
                        }
                        world.func_147471_g(x, y, z);
                        matched = true;
                        toggleLitState = false;
                        flag = true;
                        break;
                    }
                    if (matched) break;
                }
            }
        }
        if (toggleLitState) {
            meta = this.toggleLitStatus(meta);
            world.func_72921_c(x, y, z, meta, 3);
            flag = true;
        }
        return flag;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        if (!world.field_72995_K) {
            TileCandle tc = (TileCandle)world.func_147438_o(x, y, z);
            int newMeta = BlockCandle.isLit(meta) ? 1 : 0;
            ItemStack stack = new ItemStack((Block)this, 1, newMeta);
            if (tc != null && tc.getColour() != 0xFFFFFF) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a(colourTagName, tc.getColour());
                stack.func_77982_d(tag);
            }
            this.func_149642_a(world, x, y, z, stack);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        TileCandle tc = (TileCandle)world.func_147438_o(x, y, z);
        tc.setColour(this.getColourValueFromItemStack(itemStack));
        if (BlockCandle.isLit(itemStack)) {
            int meta = world.func_72805_g(x, y, z);
            world.func_72921_c(x, y, z, this.toggleLitStatus(meta), 3);
        }
    }

    public void func_149690_a(World par1World, int par2, int par3, int par4, int par5, float par6, int par7) {
    }

    public void func_149681_a(World par1World, int par2, int par3, int par4, int par5, EntityPlayer par6EntityPlayer) {
    }

    protected boolean func_150109_e(World world, int x, int y, int z) {
        if (!this.func_149742_c(world, x, y, z)) {
            if (world.func_147439_a(x, y, z) == this) {
                world.func_147468_f(x, y, z);
            }
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (BlockCandle.isLit(world.func_72805_g(x, y, z))) {
            int l = world.func_72805_g(x, y, z) & 7;
            double d0 = (float)x + 0.5f;
            double d1 = (float)y + 0.7f;
            double d2 = (float)z + 0.5f;
            double d3 = 0.22f;
            double d4 = 0.27f;
            if (l == 1) {
                world.func_72869_a("smoke", d0 - d4, d1 + d3, d2, 0.0, 0.0, 0.0);
                world.func_72869_a("flame", d0 - d4, d1 + d3, d2, 0.0, 0.0, 0.0);
            } else if (l == 2) {
                world.func_72869_a("smoke", d0 + d4, d1 + d3, d2, 0.0, 0.0, 0.0);
                world.func_72869_a("flame", d0 + d4, d1 + d3, d2, 0.0, 0.0, 0.0);
            } else if (l == 3) {
                world.func_72869_a("smoke", d0, d1 + d3, d2 - d4, 0.0, 0.0, 0.0);
                world.func_72869_a("flame", d0, d1 + d3, d2 - d4, 0.0, 0.0, 0.0);
            } else if (l == 4) {
                world.func_72869_a("smoke", d0, d1 + d3, d2 + d4, 0.0, 0.0, 0.0);
                world.func_72869_a("flame", d0, d1 + d3, d2 + d4, 0.0, 0.0, 0.0);
            } else {
                world.func_72869_a("smoke", d0, d1, d2, 0.0, 0.0, 0.0);
                world.func_72869_a("flame", d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    protected boolean func_150108_b(World par1World, int par2, int par3, int par4, Block block) {
        if (this.func_150109_e(par1World, par2, par3, par4)) {
            int i1 = par1World.func_72805_g(par2, par3, par4) & 7;
            boolean flag = false;
            if (!par1World.isSideSolid(par2 - 1, par3, par4, ForgeDirection.EAST, true) && i1 == 1) {
                flag = true;
            }
            if (!par1World.isSideSolid(par2 + 1, par3, par4, ForgeDirection.WEST, true) && i1 == 2) {
                flag = true;
            }
            if (!par1World.isSideSolid(par2, par3, par4 - 1, ForgeDirection.SOUTH, true) && i1 == 3) {
                flag = true;
            }
            if (!par1World.isSideSolid(par2, par3, par4 + 1, ForgeDirection.NORTH, true) && i1 == 4) {
                flag = true;
            }
            if (!this.canPlaceTorchOn(par1World, par2, par3 - 1, par4) && i1 == 5) {
                flag = true;
            }
            if (flag) {
                this.func_149697_b(par1World, par2, par3, par4, par1World.func_72805_g(par2, par3, par4), 0);
                par1World.func_147468_f(par2, par3, par4);
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean canPlaceTorchOn(World par1World, int par2, int par3, int par4) {
        if (World.func_147466_a((IBlockAccess)par1World, (int)par2, (int)par3, (int)par4)) {
            return true;
        }
        Block block = par1World.func_147439_a(par2, par3, par4);
        return block.canPlaceTorchOnTop(par1World, par2, par3, par4);
    }

    protected int getColourValueFromItemStack(ItemStack itemStack) {
        NBTTagCompound tag;
        int value = 0xFFFFFF;
        if (itemStack.func_77942_o() && (tag = itemStack.func_77978_p()).func_74764_b(colourTagName)) {
            value = tag.func_74762_e(colourTagName);
        }
        return value;
    }

    public static boolean isLit(int meta) {
        return (meta & 8) > 0;
    }

    public static boolean isLit(ItemStack itemStack) {
        return itemStack.func_77960_j() > 0;
    }

    protected int toggleLitStatus(int meta) {
        return meta ^ 8;
    }

    public void addItemToLightingList(Item item) {
        if (item == null) {
            throw new NullPointerException();
        }
        if (!this.lightingItems.contains(item)) {
            this.lightingItems.add(item);
        }
    }
}

