/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import forestry.api.apiculture.IAlvearyComponent;
import forestry.api.core.ITileStructure;
import forestry.apiculture.gadgets.TileAlvearyPlain;
import forestry.core.config.ForestryBlock;
import forestry.core.gadgets.BlockStructure;
import forestry.core.gadgets.StructureLogic;
import forestry.core.utils.Schemata;
import forestry.core.utils.Vect;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class StructureLogicAlveary
extends StructureLogic {
    public static final String UID_ALVEARY = "alveary";
    public static final Schemata SCHEMATA_ALVEARY = new Schemata("alveary3x3", 5, 6, 5, "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FABAF", "FCCCF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBMBF", "FCCCF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FABAF", "FCCCF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF").setOffsets(-2, -3, -2);
    public static final HashSet<Block> slabBlocks = new HashSet();

    public StructureLogicAlveary(ITileStructure structure) {
        super(UID_ALVEARY, structure);
        this.schematas = new Schemata[]{SCHEMATA_ALVEARY};
        this.metaOnValid.put(Schemata.EnumStructureBlock.BLOCK_B, 1);
    }

    @Override
    protected BlockStructure.EnumStructureState determineMasterState(Schemata schemata, boolean rotate) {
        Vect dimensions = schemata.getDimensions(rotate);
        int offsetX = schemata.getxOffset();
        int offsetZ = schemata.getzOffset();
        if (rotate) {
            offsetX = schemata.getzOffset();
            offsetZ = schemata.getxOffset();
        }
        for (int i = 0; i < dimensions.x; ++i) {
            for (int j = 0; j < schemata.getHeight(); ++j) {
                block10: for (int k = 0; k < dimensions.z; ++k) {
                    int x = this.structureTile.field_145851_c + i + offsetX;
                    int y = this.structureTile.field_145848_d + j + schemata.getyOffset();
                    int z = this.structureTile.field_145849_e + k + offsetZ;
                    if (!this.structureTile.func_145831_w().func_72899_e(x, y, z)) {
                        return BlockStructure.EnumStructureState.INDETERMINATE;
                    }
                    Schemata.EnumStructureBlock required = schemata.getAt(i, j, k, rotate);
                    if (required == Schemata.EnumStructureBlock.ANY) continue;
                    TileEntity tile = this.structureTile.func_145831_w().func_147438_o(x, y, z);
                    Block block = this.structureTile.func_145831_w().func_147439_a(x, y, z);
                    switch (required) {
                        case AIR: {
                            if (block.isAir((IBlockAccess)this.structureTile.func_145831_w(), x, y, z)) continue block10;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case BLOCK_A: {
                            if (tile == null || !(tile instanceof IAlvearyComponent)) {
                                return BlockStructure.EnumStructureState.INVALID;
                            }
                            if (((ITileStructure)tile).getTypeUID().equals(UID_ALVEARY)) continue block10;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case MASTER: 
                        case BLOCK_B: {
                            if (tile != null && tile instanceof TileAlvearyPlain) continue block10;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case BLOCK_C: {
                            if (!slabBlocks.contains(block)) {
                                return BlockStructure.EnumStructureState.INVALID;
                            }
                            if ((this.structureTile.func_145831_w().func_72805_g(x, y, z) & 8) == 0) continue block10;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case BLOCK_D: {
                            if (block == Blocks.field_150485_bF) continue block10;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case FOREIGN: {
                            if (!(tile instanceof ITileStructure)) continue block10;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        default: {
                            return BlockStructure.EnumStructureState.INDETERMINATE;
                        }
                    }
                }
            }
        }
        return BlockStructure.EnumStructureState.VALID;
    }

    static {
        slabBlocks.add((Block)Blocks.field_150333_U);
        slabBlocks.add((Block)Blocks.field_150376_bx);
        slabBlocks.add(ForestryBlock.slabs1.block());
        slabBlocks.add(ForestryBlock.slabs2.block());
        slabBlocks.add(ForestryBlock.slabs3.block());
        if (ForestryBlock.slabs4 != null) {
            slabBlocks.add(ForestryBlock.slabs4.block());
        }
    }
}

