/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.ISpecialInventory;
import forestry.api.core.ITileStructure;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.gadgets.TileAlveary;
import forestry.apiculture.gui.ContainerAlveary;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.interfaces.IClimatised;
import forestry.core.interfaces.IErrorSource;
import forestry.core.interfaces.IHintSource;
import forestry.core.network.GuiId;
import forestry.core.network.PacketInventoryStack;
import forestry.core.proxy.Proxies;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.TileInventoryAdapter;
import forestry.plugins.PluginApiculture;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class TileAlvearyPlain
extends TileAlveary
implements ISidedInventory,
ISpecialInventory,
IBeeHousing,
IClimatised,
IHintSource {
    public static final int SLOT_QUEEN = 0;
    public static final int SLOT_DRONE = 1;
    public static final int SLOT_PRODUCT_1 = 2;
    public static final int SLOT_PRODUCTION_COUNT = 7;
    public static final int BLOCK_META = 0;
    protected IBeekeepingLogic beekeepingLogic;
    protected int biomeId;
    protected float temperature;
    protected float humidity;
    protected float tempChange = 0.0f;
    protected float humidChange = 0.0f;
    private int displayHealthMax = 0;
    private int displayHealth = 0;
    private final Set<IBeeModifier> modifiers = new LinkedHashSet<IBeeModifier>();
    private final Set<IBeeListener> eventHandlers = new LinkedHashSet<IBeeListener>();

    public TileAlvearyPlain() {
        super(0);
    }

    @Override
    public void openGui(EntityPlayer player) {
        if (this.isMaster()) {
            player.openGui(ForestryAPI.instance, GuiId.AlvearyGUI.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (this.hasMaster()) {
            player.openGui(ForestryAPI.instance, GuiId.AlvearyGUI.ordinal(), this.field_145850_b, this.masterX, this.masterY, this.masterZ);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.tempChange = nbttagcompound.func_74760_g("TempChange");
        this.humidChange = nbttagcompound.func_74760_g("HumidChange");
        if (this.inventory != null) {
            this.inventory.readFromNBT(nbttagcompound);
        }
        if (this.beekeepingLogic != null) {
            this.beekeepingLogic.readFromNBT(nbttagcompound);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74776_a("TempChange", this.tempChange);
        nbttagcompound.func_74776_a("HumidChange", this.humidChange);
        if (this.inventory != null) {
            this.inventory.writeToNBT(nbttagcompound);
        }
        if (this.beekeepingLogic != null) {
            this.beekeepingLogic.writeToNBT(nbttagcompound);
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        BiomeGenBase biome = this.field_145850_b.getBiomeGenForCoordsBody(this.field_145851_c, this.field_145849_e);
        this.biomeId = biome.field_76756_M;
        this.temperature = biome.field_76750_F;
        this.humidity = biome.field_76751_G;
        this.setErrorState(EnumErrorCode.OK);
    }

    @Override
    protected void updateServerSide() {
        if (this.beekeepingLogic == null) {
            return;
        }
        if (!this.isMaster()) {
            return;
        }
        this.beekeepingLogic.update();
        this.equalizeTemperature();
        this.equalizeHumidity();
        IBee queen = this.beekeepingLogic.getQueen();
        if (queen == null) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 200L * 10L == 0L) {
            this.onQueenChange(this.inventory.func_70301_a(0));
        }
        if (this.getErrorState() == EnumErrorCode.OK) {
            queen.doFX(this.beekeepingLogic.getEffectData(), this);
        }
        if (this.getErrorState() == EnumErrorCode.OK && this.field_145850_b.func_82737_E() % 50L == 0L) {
            float f = (float)this.field_145851_c + 0.5f;
            float f1 = (float)this.field_145848_d + 0.0f + this.field_145850_b.field_73012_v.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)this.field_145849_e + 0.5f;
            float f3 = 0.52f;
            float f4 = this.field_145850_b.field_73012_v.nextFloat() * 0.6f - 0.3f;
            Proxies.common.addEntitySwarmFX(this.field_145850_b, f - f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
            Proxies.common.addEntitySwarmFX(this.field_145850_b, f + f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
            Proxies.common.addEntitySwarmFX(this.field_145850_b, f + f4, f1, f2 - f3, 0.0f, 0.0f, 0.0f);
            Proxies.common.addEntitySwarmFX(this.field_145850_b, f + f4, f1, f2 + f3, 0.0f, 0.0f, 0.0f);
        }
    }

    @Override
    protected void updateClientSide() {
        if (!this.isMaster()) {
            return;
        }
        if (this.inventory == null) {
            return;
        }
        if (PluginApiculture.beeInterface.isMated(this.inventory.func_70301_a(0)) && this.getErrorState() == EnumErrorCode.OK && this.field_145850_b.func_82737_E() % 2L == 0L) {
            IBee displayQueen = PluginApiculture.beeInterface.getMember(this.inventory.func_70301_a(0));
            displayQueen.doFX(this.beekeepingLogic.getEffectData(), this);
        }
    }

    private void equalizeTemperature() {
        if (this.tempChange == 0.0f) {
            return;
        }
        this.tempChange -= 0.05f * this.tempChange;
        if (this.tempChange <= 0.001f && this.tempChange >= -0.001f) {
            this.tempChange = 0.0f;
        }
    }

    private void equalizeHumidity() {
        if (this.humidChange == 0.0f) {
            return;
        }
        this.humidChange -= 0.05f * this.humidChange;
        if (this.humidChange <= 0.001f && this.humidChange >= 0.001f) {
            this.humidChange = 0.0f;
        }
    }

    private int getHealthDisplay() {
        if (this.inventory == null || this.inventory.func_70301_a(0) == null) {
            return 0;
        }
        if (PluginApiculture.beeInterface.isMated(this.inventory.func_70301_a(0))) {
            return PluginApiculture.beeInterface.getMember(this.inventory.func_70301_a(0)).getHealth();
        }
        if (!PluginApiculture.beeInterface.isDrone(this.inventory.func_70301_a(0))) {
            return this.displayHealth;
        }
        return 0;
    }

    private int getMaxHealthDisplay() {
        if (this.inventory == null || this.inventory.func_70301_a(0) == null) {
            return 0;
        }
        if (PluginApiculture.beeInterface.isMated(this.inventory.func_70301_a(0))) {
            return PluginApiculture.beeInterface.getMember(this.inventory.func_70301_a(0)).getMaxHealth();
        }
        if (!PluginApiculture.beeInterface.isDrone(this.inventory.func_70301_a(0))) {
            return this.displayHealthMax;
        }
        return 0;
    }

    public int getHealthScaled(int i) {
        if (this.getMaxHealthDisplay() == 0) {
            return 0;
        }
        return this.getHealthDisplay() * i / this.getMaxHealthDisplay();
    }

    @Override
    public boolean allowsInteraction(EntityPlayer player) {
        if (!super.allowsInteraction(player)) {
            return false;
        }
        return this.isIntegratedIntoStructure();
    }

    @Override
    protected void createInventory() {
        this.inventory = new TileInventoryAdapter(this, 9, "Items");
    }

    @Override
    public void makeMaster() {
        super.makeMaster();
        if (this.beekeepingLogic == null) {
            this.beekeepingLogic = PluginApiculture.beeInterface.createBeekeepingLogic(this);
        }
    }

    @Override
    public void onStructureReset() {
        super.onStructureReset();
        this.modifiers.clear();
        this.eventHandlers.clear();
    }

    @Override
    public void registerBeeModifier(IBeeModifier modifier) {
        this.modifiers.add(modifier);
    }

    @Override
    public void removeBeeModifier(IBeeModifier modifier) {
        this.modifiers.remove(modifier);
    }

    @Override
    public void registerBeeListener(IBeeListener modifier) {
        this.eventHandlers.add(modifier);
    }

    @Override
    public void removeBeeListener(IBeeListener modifier) {
        this.eventHandlers.remove(modifier);
    }

    @Override
    public void addTemperatureChange(float change, float boundaryDown, float boundaryUp) {
        this.tempChange = Math.min(boundaryUp - this.temperature, Math.max(boundaryDown - this.temperature, this.tempChange + change));
    }

    @Override
    public void addHumidityChange(float change, float boundaryDown, float boundaryUp) {
        this.humidChange = Math.min(boundaryUp - this.humidity, Math.max(boundaryDown - this.humidity, this.humidChange + change));
    }

    @Override
    public int getXCoord() {
        return this.field_145851_c;
    }

    @Override
    public int getYCoord() {
        return this.field_145848_d;
    }

    @Override
    public int getZCoord() {
        return this.field_145849_e;
    }

    @Override
    public ItemStack getQueen() {
        return this.func_70301_a(0);
    }

    @Override
    public ItemStack getDrone() {
        return this.func_70301_a(1);
    }

    @Override
    public void setQueen(ItemStack itemstack) {
        this.func_70299_a(0, itemstack);
    }

    @Override
    public void setDrone(ItemStack itemstack) {
        this.func_70299_a(1, itemstack);
    }

    @Override
    public int getBiomeId() {
        return this.biomeId;
    }

    @Override
    public EnumTemperature getTemperature() {
        if (EnumTemperature.isBiomeHellish(this.biomeId) && this.tempChange >= 0.0f) {
            return EnumTemperature.HELLISH;
        }
        return EnumTemperature.getFromValue(this.getExactTemperature());
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        float mod = 2.0f;
        for (IBeeModifier modifier : this.modifiers) {
            mod *= modifier.getTerritoryModifier(genome, mod);
        }
        return mod;
    }

    @Override
    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        for (IBeeModifier modifier : this.modifiers) {
            mod *= modifier.getProductionModifier(genome, mod);
        }
        return mod;
    }

    @Override
    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        float mod = 1.0f;
        for (IBeeModifier modifier : this.modifiers) {
            mod *= modifier.getMutationModifier(genome, mate, mod);
        }
        return mod;
    }

    @Override
    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        float mod = 1.0f;
        for (IBeeModifier modifier : this.modifiers) {
            mod *= modifier.getLifespanModifier(genome, mate, mod);
        }
        return mod;
    }

    @Override
    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        for (IBeeModifier modifier : this.modifiers) {
            mod *= modifier.getFloweringModifier(genome, mod);
        }
        return mod;
    }

    @Override
    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        for (IBeeModifier modifier : this.modifiers) {
            mod *= modifier.getGeneticDecay(genome, mod);
        }
        return mod;
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public void setErrorState(int state) {
        this.setErrorState(EnumErrorCode.values()[state]);
    }

    @Override
    public int getErrorOrdinal() {
        return this.getErrorState().ordinal();
    }

    @Override
    public boolean canBreed() {
        return true;
    }

    @Override
    public boolean addProduct(ItemStack product, boolean all) {
        if (this.inventory == null) {
            return false;
        }
        return this.inventory.tryAddStack(product, 2, this.inventory.func_70302_i_() - 2, all);
    }

    @Override
    public void wearOutEquipment(int amount) {
        for (IBeeListener eventHandler : this.eventHandlers) {
            eventHandler.wearOutEquipment(amount);
        }
    }

    @Override
    public void onQueenChange(ItemStack queenStack) {
        if (!Proxies.common.isSimulating(this.field_145850_b)) {
            return;
        }
        Proxies.net.sendNetworkPacket(new PacketInventoryStack(3, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, queenStack), this.field_145851_c, this.field_145848_d, this.field_145849_e);
        for (IBeeListener eventHandler : this.eventHandlers) {
            eventHandler.onQueenChange(queenStack);
        }
    }

    @Override
    public void onQueenDeath(IBee queen) {
        for (IBeeListener eventHandler : this.eventHandlers) {
            eventHandler.onQueenDeath(queen);
        }
    }

    @Override
    public void onPostQueenDeath(IBee queen) {
        for (IBeeListener eventHandler : this.eventHandlers) {
            eventHandler.onPostQueenDeath(queen);
        }
    }

    @Override
    public boolean onPollenRetrieved(IBee queen, IIndividual pollen, boolean isHandled) {
        for (IBeeListener eventHandler : this.eventHandlers) {
            if (!eventHandler.onPollenRetrieved(queen, pollen, isHandled)) continue;
            isHandled = true;
        }
        return isHandled;
    }

    @Override
    public boolean onEggLaid(IBee queen) {
        for (IBeeListener eventHandler : this.eventHandlers) {
            if (!eventHandler.onEggLaid(queen)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSealed() {
        for (IBeeModifier modifier : this.modifiers) {
            if (!modifier.isSealed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSelfLighted() {
        for (IBeeModifier modifier : this.modifiers) {
            if (!modifier.isSelfLighted()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSunlightSimulated() {
        for (IBeeModifier modifier : this.modifiers) {
            if (!modifier.isSunlightSimulated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHellish() {
        for (IBeeModifier modifier : this.modifiers) {
            if (!modifier.isHellish()) continue;
            return true;
        }
        return false;
    }

    @Override
    public InventoryAdapter getInternalInventory() {
        return (InventoryAdapter)this.getStructureInventory();
    }

    private IInventory getStructureInventory() {
        ITileStructure central;
        if (this.inventory != null) {
            if (this.isMaster() || !Proxies.common.isSimulating(this.field_145850_b)) {
                return this.inventory;
            }
        } else if (this.hasMaster() && (central = this.getCentralTE()) != null) {
            return central.getInventory();
        }
        return null;
    }

    public int func_70302_i_() {
        IInventory inv = this.getStructureInventory();
        if (inv != null) {
            return inv.func_70302_i_();
        }
        return 0;
    }

    public ItemStack func_70301_a(int slotIndex) {
        IInventory inv = this.getStructureInventory();
        if (inv != null) {
            return inv.func_70301_a(slotIndex);
        }
        return null;
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        IInventory inv = this.getStructureInventory();
        if (inv != null) {
            return inv.func_70298_a(slotIndex, amount);
        }
        return null;
    }

    public ItemStack func_70304_b(int slotIndex) {
        IInventory inv = this.getStructureInventory();
        if (inv != null) {
            return inv.func_70304_b(slotIndex);
        }
        return null;
    }

    public void func_70299_a(int slotIndex, ItemStack itemstack) {
        IInventory inv;
        if (this.inventory == null && !Proxies.common.isSimulating(this.field_145850_b)) {
            this.createInventory();
        }
        if ((inv = this.getStructureInventory()) != null) {
            inv.func_70299_a(slotIndex, itemstack);
        }
    }

    public String func_145825_b() {
        return "alveary.0.name";
    }

    public int func_70297_j_() {
        IInventory inv = this.getStructureInventory();
        if (inv != null) {
            return inv.func_70297_j_();
        }
        return 0;
    }

    @Override
    protected boolean canTakeStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canTakeStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        return slotIndex != 0 && slotIndex != 1;
    }

    @Override
    protected boolean canPutStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canPutStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        if (slotIndex == 0 && PluginApiculture.beeInterface.isMember(itemstack) && !PluginApiculture.beeInterface.isDrone(itemstack)) {
            return true;
        }
        return slotIndex == 1 && PluginApiculture.beeInterface.isDrone(itemstack);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return super.isUseableByPlayer(player);
    }

    public boolean func_145818_k_() {
        return super.hasCustomInventoryName();
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return super.isItemValidForSlot(slotIndex, itemstack);
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return super.canInsertItem(i, itemstack, j);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return super.canExtractItem(i, itemstack, j);
    }

    public int[] func_94128_d(int side) {
        return super.getAccessibleSlotsFromSide(side);
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        IInventory inv = this.getStructureInventory();
        if (inv == null) {
            return 0;
        }
        if ((ForestryItem.beePrincessGE.isItemEqual(stack) || ForestryItem.beeQueenGE.isItemEqual(stack)) && inv.func_70301_a(0) == null) {
            if (doAdd) {
                inv.func_70299_a(0, stack.func_77946_l());
                inv.func_70301_a((int)0).field_77994_a = 1;
            }
            return 1;
        }
        if (ForestryItem.beeDroneGE.isItemEqual(stack)) {
            int added;
            ItemStack droneStack = inv.func_70301_a(1);
            if (droneStack == null) {
                if (doAdd) {
                    inv.func_70299_a(1, stack.func_77946_l());
                }
                return stack.field_77994_a;
            }
            if (!droneStack.func_77969_a(stack)) {
                return 0;
            }
            if (!ItemStack.func_77970_a((ItemStack)droneStack, (ItemStack)stack)) {
                return 0;
            }
            int space = droneStack.func_77976_d() - droneStack.field_77994_a;
            if (space <= 0) {
                return 0;
            }
            int n = added = space > stack.field_77994_a ? stack.field_77994_a : space;
            if (doAdd) {
                droneStack.field_77994_a += added;
            }
            return added;
        }
        return 0;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        IInventory inv = this.getStructureInventory();
        if (inv == null) {
            return new ItemStack[0];
        }
        ItemStack product = null;
        for (int i = 2; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null) continue;
            ItemStack stack = inv.func_70301_a(i);
            if (doRemove) {
                product = inv.func_70298_a(i, 1);
                break;
            }
            product = stack.func_77946_l();
            product.field_77994_a = 1;
            break;
        }
        return new ItemStack[]{product};
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.displayHealth = j;
                break;
            }
            case 1: {
                this.displayHealthMax = j;
                break;
            }
            case 2: {
                this.temperature = (float)j / 100.0f;
                break;
            }
            case 3: {
                this.humidity = (float)j / 100.0f;
                break;
            }
            case 4: {
                this.tempChange = (float)j / 100.0f;
                break;
            }
            case 5: {
                this.humidChange = (float)j / 100.0f;
                break;
            }
            case 6: {
                this.biomeId = j;
            }
        }
    }

    public void sendGUINetworkData(ContainerAlveary container, ICrafting iCrafting) {
        if (this.beekeepingLogic == null) {
            return;
        }
        iCrafting.func_71112_a((Container)container, 0, this.beekeepingLogic.getBreedingTime());
        iCrafting.func_71112_a((Container)container, 1, this.beekeepingLogic.getTotalBreedingTime());
        iCrafting.func_71112_a((Container)container, 2, Math.round(this.temperature * 100.0f));
        iCrafting.func_71112_a((Container)container, 3, Math.round(this.humidity * 100.0f));
        iCrafting.func_71112_a((Container)container, 4, Math.round(this.tempChange * 100.0f));
        iCrafting.func_71112_a((Container)container, 5, Math.round(this.humidChange * 100.0f));
        iCrafting.func_71112_a((Container)container, 6, this.biomeId);
    }

    @Override
    public EnumErrorCode getErrorState() {
        ITileStructure tile;
        if (this.hasMaster() && (tile = this.getCentralTE()) != null) {
            return ((IErrorSource)((Object)tile)).getErrorState();
        }
        return this.errorState;
    }

    @Override
    public boolean isClimatized() {
        return true;
    }

    @Override
    public float getExactTemperature() {
        return this.temperature + this.tempChange;
    }

    @Override
    public float getExactHumidity() {
        return this.humidity + this.humidChange;
    }

    @Override
    public boolean hasHints() {
        return Config.hints.get("alveary").length > 0;
    }

    @Override
    public String[] getHints() {
        return Config.hints.get("alveary");
    }

    @Override
    public boolean isOwnable() {
        return true;
    }

    @Override
    public GameProfile getOwnerName() {
        return this.getOwnerProfile();
    }
}

