/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlvearyComponent;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.ForestryAPI;
import forestry.api.core.ISpecialInventory;
import forestry.apiculture.gadgets.TileAlveary;
import forestry.apiculture.worldgen.WorldGenHive;
import forestry.apiculture.worldgen.WorldGenHiveSwamer;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.TileInventoryAdapter;
import forestry.plugins.PluginApiculture;
import java.util.Map;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class TileAlvearySwarmer
extends TileAlveary
implements ISpecialInventory {
    public static final int BLOCK_META = 2;
    TileInventoryAdapter swarmerInventory;
    private final Stack<ItemStack> pendingSpawns = new Stack();

    public TileAlvearySwarmer() {
        super(2);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.swarmerInventory == null) {
            this.createInventory();
        }
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.AlvearySwarmerGUI.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        if (this.field_145850_b.func_82737_E() % 100L != 0L && this.pendingSpawns.size() > 0) {
            this.trySpawnSwarm();
        }
        if (this.field_145850_b.func_82737_E() % 500L != 0L) {
            return;
        }
        if (!this.hasMaster()) {
            return;
        }
        IAlvearyComponent master = (IAlvearyComponent)this.getCentralTE();
        if (!(master instanceof IBeeHousing)) {
            return;
        }
        IBeeHousing housing = (IBeeHousing)((Object)master);
        ItemStack queenstack = housing.getQueen();
        if (queenstack == null) {
            return;
        }
        if (!PluginApiculture.beeInterface.isMated(queenstack)) {
            return;
        }
        int slot = this.getInducerSlot();
        if (slot < 0) {
            return;
        }
        int chance = this.getChanceFor(this.swarmerInventory.func_70301_a(slot));
        this.swarmerInventory.func_70298_a(slot, 1);
        if (this.field_145850_b.field_73012_v.nextInt(1000) >= chance) {
            return;
        }
        IBee spawn = PluginApiculture.beeInterface.getMember(queenstack);
        spawn.setIsNatural(false);
        this.pendingSpawns.push(PluginApiculture.beeInterface.getMemberStack(spawn, EnumBeeType.PRINCESS.ordinal()));
    }

    private int getChanceFor(ItemStack stack) {
        for (Map.Entry<ItemStack, Integer> entry : BeeManager.inducers.entrySet()) {
            if (!entry.getKey().func_77969_a(stack)) continue;
            return entry.getValue();
        }
        return 0;
    }

    private int getInducerSlot() {
        for (int i = 0; i < this.swarmerInventory.func_70302_i_(); ++i) {
            if (this.swarmerInventory.func_70301_a(i) == null) continue;
            for (Map.Entry<ItemStack, Integer> entry : BeeManager.inducers.entrySet()) {
                if (!entry.getKey().func_77969_a(this.swarmerInventory.func_70301_a(i))) continue;
                return i;
            }
        }
        return -1;
    }

    private void trySpawnSwarm() {
        ItemStack toSpawn = this.pendingSpawns.peek();
        WorldGenHiveSwamer generator = new WorldGenHiveSwamer(new ItemStack[]{toSpawn});
        for (int i = 0; i < 10; ++i) {
            int spawnZ;
            int spawnY;
            int spawnX = this.field_145851_c + this.field_145850_b.field_73012_v.nextInt(80) - 40;
            if (!((WorldGenHive)generator).func_76484_a(this.field_145850_b, this.field_145850_b.field_73012_v, spawnX, spawnY = this.field_145848_d + this.field_145850_b.field_73012_v.nextInt(40), spawnZ = this.field_145849_e + this.field_145850_b.field_73012_v.nextInt(80) - 40)) continue;
            this.pendingSpawns.pop();
            break;
        }
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    @Override
    public int getIcon(int side, int metadata) {
        if (side == 0 || side == 1) {
            return 2;
        }
        if (this.pendingSpawns.size() > 0) {
            return 6;
        }
        return 5;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (this.swarmerInventory == null) {
            this.createInventory();
        }
        this.swarmerInventory.readFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("PendingSpawns", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            this.pendingSpawns.add(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.swarmerInventory != null) {
            this.swarmerInventory.writeToNBT(nbttagcompound);
        }
        NBTTagList nbttaglist = new NBTTagList();
        ItemStack[] offspring = this.pendingSpawns.toArray(new ItemStack[this.pendingSpawns.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            offspring[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("PendingSpawns", (NBTBase)nbttaglist);
    }

    @Override
    protected void createInventory() {
        this.swarmerInventory = new TileInventoryAdapter(this, 4, "SwarmInv");
    }

    @Override
    public IInventory getInventory() {
        return this.swarmerInventory;
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (this.swarmerInventory != null) {
            return this.swarmerInventory.addStack(stack, false, doAdd);
        }
        return 0;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        return null;
    }

    public int func_70302_i_() {
        if (this.swarmerInventory != null) {
            return this.swarmerInventory.func_70302_i_();
        }
        return 0;
    }

    public ItemStack func_70301_a(int slotIndex) {
        if (this.swarmerInventory != null) {
            return this.swarmerInventory.func_70301_a(slotIndex);
        }
        return null;
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        if (this.swarmerInventory != null) {
            return this.swarmerInventory.func_70298_a(slotIndex, amount);
        }
        return null;
    }

    public ItemStack func_70304_b(int slotIndex) {
        if (this.swarmerInventory != null) {
            return this.swarmerInventory.func_70304_b(slotIndex);
        }
        return null;
    }

    public void func_70299_a(int slotIndex, ItemStack itemstack) {
        if (this.swarmerInventory == null && !Proxies.common.isSimulating(this.field_145850_b)) {
            this.createInventory();
        }
        if (this.swarmerInventory != null) {
            this.swarmerInventory.func_70299_a(slotIndex, itemstack);
        }
    }

    public String func_145825_b() {
        return "alveary.2.name";
    }

    public int func_70297_j_() {
        if (this.swarmerInventory != null) {
            return this.swarmerInventory.func_70297_j_();
        }
        return 0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return super.isUseableByPlayer(player);
    }

    public boolean func_145818_k_() {
        return super.hasCustomInventoryName();
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return super.isItemValidForSlot(slotIndex, itemstack);
    }
}

