/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.apiculture.genetics.BeeMutation;
import java.util.Calendar;

public class MutationTimeLimited
extends BeeMutation {
    DayMonth start;
    DayMonth end;

    public MutationTimeLimited(IAllele allele0, IAllele allele1, IAllele[] template, int chance, DayMonth start) {
        this(allele0, allele1, template, chance, start, null);
    }

    public MutationTimeLimited(IAllele allele0, IAllele allele1, IAllele[] template, int chance, DayMonth start, DayMonth end) {
        super(allele0, allele1, template, chance);
        this.start = start;
        this.end = end;
    }

    @Override
    public float getChance(IBeeHousing housing, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        float chance = super.getChance(housing, allele0, allele1, genome0, genome1);
        if (chance == 0.0f) {
            return 0.0f;
        }
        if (this.start == null && this.end == null) {
            return chance;
        }
        DayMonth now = new DayMonth();
        if (Calendar.getInstance().get(5) == this.start.day && Calendar.getInstance().get(2) + 1 == this.start.month) {
            return chance;
        }
        if (this.end == null) {
            return 0.0f;
        }
        if (Calendar.getInstance().get(5) == this.end.day && Calendar.getInstance().get(2) + 1 == this.end.month) {
            return chance;
        }
        if (now.between(this.start, this.end)) {
            return chance;
        }
        return 0.0f;
    }

    public static class DayMonth {
        public int day;
        public int month;

        public DayMonth() {
            this.day = Calendar.getInstance().get(5);
            this.month = Calendar.getInstance().get(2) + 1;
        }

        public DayMonth(int day, int month) {
            this.day = day;
            this.month = month;
        }

        public boolean between(DayMonth start, DayMonth end) {
            if (this.equals(start) || this.equals(end)) {
                return true;
            }
            if (start.month > end.month) {
                return this.after(start) || this.before(end);
            }
            return this.after(start) && this.before(end);
        }

        public boolean before(DayMonth other) {
            if (other.month > this.month) {
                return true;
            }
            if (other.month < this.month) {
                return false;
            }
            return this.day < other.day;
        }

        public boolean after(DayMonth other) {
            if (other.month < this.month) {
                return true;
            }
            if (other.month > this.month) {
                return false;
            }
            return this.day > other.day;
        }

        public int hashCode() {
            int hash = 7;
            hash = 89 * hash + this.day;
            hash = 89 * hash + this.month;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DayMonth other = (DayMonth)obj;
            if (this.day != other.day) {
                return false;
            }
            return this.month == other.month;
        }

        public String toString() {
            return this.day + "." + this.month;
        }
    }
}

