/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.render;

import forestry.api.apiculture.IBee;
import forestry.apiculture.entities.EntityBee;
import forestry.apiculture.render.ModelBee;
import forestry.core.proxy.Proxies;
import forestry.plugins.PluginApiculture;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class BeeItemRenderer
implements IItemRenderer {
    ModelBee model;
    EntityBee entity;

    private static float getWingYaw(IBee bee) {
        float wingYaw = 1.0f;
        if (bee.isAlive()) {
            long systemTime = System.currentTimeMillis();
            long flapping = systemTime + (long)bee.getIdent().hashCode();
            float flap = (float)(flapping % 1000L) / 1000.0f;
            wingYaw = BeeItemRenderer.getIrregularWingYaw(flapping, flap);
        }
        return wingYaw;
    }

    public static float getIrregularWingYaw(long flapping, float flap) {
        long irregular = flapping / 1000L;
        float wingYaw = 1.0f;
        if (irregular % 11L == 0L) {
            wingYaw = 0.75f;
        } else {
            if (irregular % 7L == 0L || irregular % 19L == 0L) {
                flap *= 8.0f;
                flap %= 1.0f;
            }
            wingYaw = BeeItemRenderer.getRegularWingYaw(flap);
        }
        return wingYaw;
    }

    public static float getRegularWingYaw(float flap) {
        return (double)flap < 0.5 ? 0.75f + flap : 1.75f - flap;
    }

    private IBee initBee(ItemStack item, boolean scaled) {
        IBee bee = PluginApiculture.beeInterface.getMember(item);
        if (bee == null) {
            bee = PluginApiculture.beeInterface.templateAsIndividual(PluginApiculture.beeInterface.getDefaultTemplate());
        }
        if (this.entity == null) {
            this.entity = new EntityBee((World)Proxies.common.getClientInstance().field_71441_e);
        }
        this.entity.setSpecies(bee.getGenome().getPrimary());
        this.entity.setType(PluginApiculture.beeInterface.getType(item));
        return bee;
    }

    private void renderBeeItem(IBee bee, float translateX, float translateY, float translateZ) {
        float yaw = 1.0f;
        float pitch = 1.0f;
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        GL11.glTranslatef((float)translateX, (float)translateY, (float)translateZ);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-((float)Math.atan(pitch / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        this.entity.field_70761_aq = (float)Math.atan(yaw / 40.0f) * 20.0f;
        this.entity.field_70177_z = (float)Math.atan(yaw / 40.0f) * 40.0f;
        this.entity.field_70125_A = -((float)Math.atan(pitch / 40.0f)) * 20.0f;
        this.entity.field_70759_as = this.entity.field_70177_z;
        RenderManager.field_78727_a.func_147940_a((Entity)this.entity, 0.0, 0.0, 0.0, 0.0f, BeeItemRenderer.getWingYaw(bee));
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        GL11.glPopAttrib();
    }

    private void renderBeeInInventory(IBee bee) {
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2903);
        RenderHelper.func_74519_b();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.3f, (float)-2.5f, (float)0.0f);
        GL11.glScalef((float)-3.0f, (float)3.0f, (float)3.0f);
        GL11.glRotatef((float)32.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)1.6f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.entity.field_70761_aq = 0.0f;
        this.entity.field_70177_z = 0.0f;
        this.entity.field_70125_A = 0.0f;
        this.entity.field_70759_as = this.entity.field_70177_z;
        RenderManager.field_78727_a.func_147940_a((Entity)this.entity, 0.0, 0.0, 0.0, 0.0f, BeeItemRenderer.getWingYaw(bee));
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        GL11.glPopAttrib();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: {
                return true;
            }
            case EQUIPPED: {
                return true;
            }
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        switch (helper) {
            case ENTITY_BOBBING: 
            case ENTITY_ROTATION: {
                return false;
            }
        }
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                this.renderBeeItem(this.initBee(item, true), 0.0f, 0.0f, 0.0f);
                break;
            }
            case EQUIPPED: {
                this.renderBeeItem(this.initBee(item, true), 1.0f, 0.0f, 0.5f);
                break;
            }
            case INVENTORY: {
                this.renderBeeInInventory(this.initBee(item, false));
                break;
            }
        }
    }
}

