/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.apiculture.gadgets.TileBeehouse;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.utils.StackUtils;
import forestry.plugins.PluginApiculture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.common.ChestGenHooks;

public class ComponentVillageBeeHouse
extends StructureVillagePieces.House1 {
    protected ItemStack[] buildingBlocks = new ItemStack[]{ForestryBlock.planks1.getItemStack(1, 15), new ItemStack(Blocks.field_150364_r, 1, 0)};
    protected int averageGroundLevel = -1;
    protected boolean isInDesert = false;
    protected boolean hasChest = false;

    public ComponentVillageBeeHouse() {
        this.buildingBlocks[0] = ForestryBlock.planks1.getItemStack();
        this.buildingBlocks[1] = ForestryBlock.log1.getItemStack();
    }

    public ComponentVillageBeeHouse(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox boundingBox, int coordBaseMode) {
        super(startPiece, componentType, random, boundingBox, coordBaseMode);
        Block woodBlock;
        this.isInDesert = startPiece.field_74927_b;
        this.buildingBlocks[0] = ForestryBlock.planks1.getItemStack(1, random.nextInt(16));
        switch (random.nextInt(4)) {
            case 1: {
                woodBlock = ForestryBlock.log2.block();
                break;
            }
            case 2: {
                woodBlock = ForestryBlock.log3.block();
                break;
            }
            case 3: {
                woodBlock = ForestryBlock.log4.block();
                break;
            }
            default: {
                woodBlock = ForestryBlock.log1.block();
            }
        }
        this.buildingBlocks[1] = new ItemStack(woodBlock, 1, random.nextInt(4));
    }

    public static ComponentVillageBeeHouse buildComponent(StructureVillagePieces.Start startPiece, List par1List, Random random, int par3, int par4, int par5, int par6, int par7) {
        StructureBoundingBox bbox = StructureBoundingBox.func_78889_a((int)par3, (int)par4, (int)par5, (int)0, (int)0, (int)0, (int)9, (int)9, (int)6, (int)par6);
        return ComponentVillageBeeHouse.func_74895_a((StructureBoundingBox)bbox) && StructureComponent.func_74883_a((List)par1List, (StructureBoundingBox)bbox) == null ? new ComponentVillageBeeHouse(startPiece, par7, random, bbox, par6) : null;
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox structBoundingBox) {
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.func_74889_b(world, structBoundingBox);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78894_e + 8 - 1, 0);
        }
        this.func_151549_a(world, structBoundingBox, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
        this.func_151549_a(world, structBoundingBox, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a, Blocks.field_150350_a, false);
        this.buildGarden(world, structBoundingBox);
        this.func_151549_a(world, structBoundingBox, 1, 1, 6, 1, 1, 10, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
        this.func_151549_a(world, structBoundingBox, 8, 1, 6, 8, 1, 10, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
        this.func_151549_a(world, structBoundingBox, 2, 1, 10, 7, 1, 10, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
        this.plantFlowerGarden(world, structBoundingBox, 2, 1, 5, 7, 1, 9);
        this.buildApiaries(world, structBoundingBox, 3, 1, 4, 6, 1, 8);
        this.func_151549_a(world, structBoundingBox, 1, 0, 1, 7, 0, 4, Blocks.field_150344_f, Blocks.field_150344_f, false);
        this.func_151549_a(world, structBoundingBox, 0, 0, 0, 0, 3, 5, Blocks.field_150347_e, Blocks.field_150347_e, false);
        this.func_151549_a(world, structBoundingBox, 8, 0, 0, 8, 3, 5, Blocks.field_150347_e, Blocks.field_150347_e, false);
        this.func_151549_a(world, structBoundingBox, 1, 0, 0, 7, 1, 0, Blocks.field_150347_e, Blocks.field_150347_e, false);
        this.func_151549_a(world, structBoundingBox, 1, 0, 5, 7, 1, 5, Blocks.field_150347_e, Blocks.field_150347_e, false);
        this.fillBoxWith(world, structBoundingBox, 1, 2, 0, 7, 3, 0, this.buildingBlocks[0], false);
        this.fillBoxWith(world, structBoundingBox, 1, 2, 5, 7, 3, 5, this.buildingBlocks[0], false);
        this.fillBoxWith(world, structBoundingBox, 0, 4, 1, 8, 4, 1, this.buildingBlocks[0], false);
        this.fillBoxWith(world, structBoundingBox, 0, 4, 4, 8, 4, 4, this.buildingBlocks[0], false);
        this.fillBoxWith(world, structBoundingBox, 0, 5, 2, 8, 5, 3, this.buildingBlocks[0], false);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[0], 0, 4, 2, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[0], 0, 4, 3, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[0], 8, 4, 2, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[0], 8, 4, 3, structBoundingBox);
        this.buildRoof(world, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[1], 0, 2, 1, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[1], 0, 2, 4, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[1], 8, 2, 1, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[1], 8, 2, 4, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150410_aZ, 0, 0, 2, 2, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150410_aZ, 0, 0, 2, 3, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150410_aZ, 0, 8, 2, 2, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150410_aZ, 0, 8, 2, 3, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150410_aZ, 0, 2, 2, 5, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150410_aZ, 0, 3, 2, 5, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150410_aZ, 0, 4, 2, 5, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150410_aZ, 0, 5, 2, 0, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150410_aZ, 0, 6, 2, 5, structBoundingBox);
        if (random.nextInt(10) < 1) {
            this.placeBlockAtCurrentPosition(world, ForestryBlock.core.getItemStack(1, 1), 1, 1, 3, structBoundingBox);
        } else {
            this.placeBlockAtCurrentPosition(world, this.buildingBlocks[0], 1, 1, 3, structBoundingBox);
        }
        this.func_151550_a(world, Blocks.field_150350_a, 0, 2, 1, 0, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150350_a, 0, 2, 2, 0, structBoundingBox);
        this.func_74881_a(world, structBoundingBox, random, 2, 1, 0, this.func_151555_a(Blocks.field_150466_ao, 1));
        if (this.isAirBlockAtCurrentPosition(world, 2, 0, -1, structBoundingBox) && !this.isAirBlockAtCurrentPosition(world, 2, -1, -1, structBoundingBox)) {
            this.func_151550_a(world, Blocks.field_150446_ar, this.func_151555_a(Blocks.field_150446_ar, 3), 2, 0, -1, structBoundingBox);
        }
        this.func_151550_a(world, Blocks.field_150350_a, 0, 6, 1, 5, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150350_a, 0, 6, 2, 5, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150478_aa, 0, 2, 3, 4, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150478_aa, 0, 6, 3, 4, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150478_aa, 0, 2, 3, 1, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150478_aa, 0, 6, 3, 1, structBoundingBox);
        this.func_74881_a(world, structBoundingBox, random, 6, 1, 5, this.func_151555_a(Blocks.field_150466_ao, 1));
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_74871_b(world, j, 7, i, structBoundingBox);
                this.func_151554_b(world, Blocks.field_150347_e, 0, j, -1, i, structBoundingBox);
            }
        }
        this.func_74879_a(world, structBoundingBox, random, 7, 1, 4, ChestGenHooks.getItems((String)"naturalistChest", (Random)random), random.nextInt(4) + random.nextInt(4) + 5);
        this.func_74893_a(world, this.field_74887_e, 7, 1, 1, 2);
        return true;
    }

    private void buildRoof(World world, StructureBoundingBox structBoundingBox) {
        int rotatedMetaDoor = this.func_151555_a(Blocks.field_150476_ad, 3);
        int rotatedMetaGarden = this.func_151555_a(Blocks.field_150476_ad, 2);
        for (int i = -1; i <= 2; ++i) {
            for (int j = 0; j <= 8; ++j) {
                this.func_151550_a(world, Blocks.field_150476_ad, rotatedMetaDoor, j, 4 + i, i, structBoundingBox);
                this.func_151550_a(world, Blocks.field_150476_ad, rotatedMetaGarden, j, 4 + i, 5 - i, structBoundingBox);
            }
        }
    }

    protected void buildGarden(World world, StructureBoundingBox box) {
        Block ground = Blocks.field_150346_d;
        if (this.isInDesert) {
            ground = Blocks.field_150354_m;
        }
        for (int i = 1; i <= 8; ++i) {
            for (int j = 6; j <= 10; ++j) {
                this.func_151554_b(world, ground, 0, i, 0, j, box);
            }
        }
    }

    protected void plantFlowerGarden(World world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (this.isInDesert) {
            this.func_151550_a(world, Blocks.field_150434_aF, 0, 4, 1, 7, box);
            return;
        }
        for (int i = minY; i <= maxY; ++i) {
            for (int j = minX; j <= maxX; ++j) {
                for (int k = minZ; k <= maxZ; ++k) {
                    int zCoord;
                    int yCoord;
                    int xCoord;
                    if (!world.field_73012_v.nextBoolean() || !Blocks.field_150328_O.func_149718_j(world, xCoord = this.func_74865_a(j, k), yCoord = this.func_74862_a(i), zCoord = this.func_74873_b(j, k))) continue;
                    ItemStack flower = FlowerManager.plainFlowers.get(world.field_73012_v.nextInt(FlowerManager.plainFlowers.size()));
                    this.placeBlockAtCurrentPosition(world, flower, j, i, k, box);
                }
            }
        }
    }

    protected void buildApiaries(World world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.populateApiary(world, box, 3, 1, 8);
        this.populateApiary(world, box, 6, 1, 8);
    }

    private void populateApiary(World world, StructureBoundingBox box, int x, int y, int z) {
        int zCoord;
        int yCoord;
        int xCoord = this.func_74865_a(x, z);
        if (box.func_78890_b(xCoord, yCoord = this.func_74862_a(y), zCoord = this.func_74873_b(x, z)) && !ForestryBlock.apiculture.isBlockEqual(world, xCoord, yCoord, zCoord) && world.func_72899_e(xCoord, yCoord - 1, zCoord)) {
            world.func_147465_d(xCoord, yCoord, zCoord, ForestryBlock.apiculture.block(), 0, 2);
            ForestryBlock.apiculture.block().func_149726_b(world, xCoord, yCoord, zCoord);
            TileEntity tile = world.func_147438_o(xCoord, yCoord, zCoord);
            if (tile instanceof TileBeehouse) {
                TileBeehouse apiary = (TileBeehouse)tile;
                apiary.initialize();
                apiary.setSlotContents(0, PluginApiculture.beeInterface.getMemberStack(this.getVillageBee(world, xCoord, yCoord, zCoord), EnumBeeType.PRINCESS.ordinal()));
                apiary.setSlotContents(1, PluginApiculture.beeInterface.getMemberStack(this.getVillageBee(world, xCoord, yCoord, zCoord), EnumBeeType.DRONE.ordinal()));
                for (int i = 9; i < 12; ++i) {
                    float roll = world.field_73012_v.nextFloat();
                    if (roll < 0.2f) {
                        apiary.setSlotContents(i, ForestryItem.frameUntreated.getItemStack());
                        continue;
                    }
                    if (roll < 0.4f) {
                        apiary.setSlotContents(i, ForestryItem.frameImpregnated.getItemStack());
                        continue;
                    }
                    if (!((double)roll < 0.6)) continue;
                    apiary.setSlotContents(i, ForestryItem.frameProven.getItemStack());
                }
            }
        }
    }

    private IBee getVillageBee(World world, int xCoord, int yCoord, int zCoord) {
        BiomeGenBase biome = world.func_72807_a(xCoord, zCoord);
        ArrayList<IBeeGenome> candidates = BeeManager.villageBees[1] != null && BeeManager.villageBees[1].size() > 0 && world.field_73012_v.nextDouble() < 0.2 ? BeeManager.villageBees[1] : BeeManager.villageBees[0];
        ArrayList<IBeeGenome> valid = new ArrayList<IBeeGenome>();
        for (IBeeGenome genome : candidates) {
            if (!this.checkBiomeHazard(genome, biome.field_76750_F, biome.field_76751_G)) continue;
            valid.add(genome);
        }
        if (valid.isEmpty()) {
            return PluginApiculture.beeInterface.getBee(world, BeeManager.villageBees[0].get(world.field_73012_v.nextInt(BeeManager.villageBees[0].size())));
        }
        return PluginApiculture.beeInterface.getBee(world, (IBeeGenome)valid.get(world.field_73012_v.nextInt(valid.size())));
    }

    private boolean checkBiomeHazard(IBeeGenome genome, float temperature, float humidity) {
        EnumTemperature beeTemperature = genome.getPrimary().getTemperature();
        EnumTolerance temperatureTolerance = genome.getToleranceTemp();
        Collection<EnumTemperature> toleratedTemperatures = AlleleManager.climateHelper.getToleratedTemperature(beeTemperature, temperatureTolerance);
        boolean validTemp = false;
        validTemp = toleratedTemperatures.contains((Object)EnumTemperature.getFromValue(temperature));
        if (!validTemp) {
            return false;
        }
        EnumHumidity beeHumidity = genome.getPrimary().getHumidity();
        EnumTolerance humidityTolerance = genome.getToleranceHumid();
        Collection<EnumHumidity> toleratedHumidity = AlleleManager.climateHelper.getToleratedHumidity(beeHumidity, humidityTolerance);
        boolean validHumidity = false;
        validHumidity = toleratedHumidity.contains((Object)EnumHumidity.getFromValue(humidity));
        return validHumidity;
    }

    protected void fillBoxWith(World world, StructureBoundingBox box, int par3, int par4, int par5, int par6, int par7, int par8, ItemStack buildingBlock, boolean replace) {
        for (int var14 = par4; var14 <= par7; ++var14) {
            for (int var15 = par3; var15 <= par6; ++var15) {
                for (int var16 = par5; var16 <= par8; ++var16) {
                    if (replace && this.isAirBlockAtCurrentPosition(world, var15, var14, var16, box)) continue;
                    this.placeBlockAtCurrentPosition(world, buildingBlock, var15, var14, var16, box);
                }
            }
        }
    }

    protected void placeBlockAtCurrentPosition(World world, ItemStack buildingBlock, int par4, int par5, int par6, StructureBoundingBox par7StructureBoundingBox) {
        int var10;
        int var9;
        int var8 = this.func_74865_a(par4, par6);
        if (par7StructureBoundingBox.func_78890_b(var8, var9 = this.func_74862_a(par5), var10 = this.func_74873_b(par4, par6))) {
            world.func_147465_d(var8, var9, var10, StackUtils.getBlock(buildingBlock), buildingBlock.func_77960_j(), 2);
        }
    }

    protected int func_74888_b(int villagerCount) {
        if (villagerCount <= 0) {
            return 80;
        }
        return 81;
    }

    private boolean isAirBlockAtCurrentPosition(World world, int x, int y, int z, StructureBoundingBox box) {
        return this.func_151548_a(world, x, y, z, box) == Blocks.field_150350_a;
    }
}

