/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.WoodType;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSlab
extends net.minecraft.block.BlockSlab
implements IWoodTyped {
    private final SlabCat cat;

    public BlockSlab(SlabCat cat) {
        super(false, Material.field_151575_d);
        this.cat = cat;
        this.func_149647_a(Tabs.tabArboriculture);
        this.func_149713_g(0);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(field_149766_f);
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        WoodType.registerIcons(register);
    }

    public IIcon func_149691_a(int side, int meta) {
        WoodType type = WoodType.VALUES[8 * this.cat.ordinal() + (meta & 7)];
        return type.getPlankIcon();
    }

    public Item func_149650_a(int meta, Random random, int par3) {
        return Item.func_150898_a((Block)this);
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return super.func_149643_k(world, x, y, z) & 7;
    }

    protected ItemStack func_149644_j(int meta) {
        return new ItemStack((Block)Blocks.field_150376_bx, 2, meta & 7);
    }

    public String func_150002_b(int var1) {
        return "SomeSlab";
    }

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        for (int i = 0; i < 8; ++i) {
            itemList.add(new ItemStack(item, 1, i));
        }
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 20;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return true;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 5;
    }

    @Override
    public WoodType getWoodType(int meta) {
        if (meta + this.cat.ordinal() * 8 < WoodType.VALUES.length) {
            return WoodType.VALUES[meta + this.cat.ordinal() * 8];
        }
        return WoodType.LARCH;
    }

    @Override
    public String getBlockKind() {
        return "slab";
    }

    public boolean func_149710_n() {
        return true;
    }

    public static enum SlabCat {
        CAT0,
        CAT1,
        CAT2;

    }
}

