/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumGrowthConditions;
import forestry.api.arboriculture.ITreeGenome;
import forestry.arboriculture.genetics.GrowthProvider;
import forestry.core.utils.StringUtil;
import java.util.EnumSet;
import net.minecraft.world.World;

public class GrowthProviderTropical
extends GrowthProvider {
    @Override
    public EnumGrowthConditions getGrowthConditions(ITreeGenome genome, World world, int xPos, int yPos, int zPos) {
        EnumGrowthConditions light = this.getConditionFromLight(world, xPos, yPos, zPos);
        EnumGrowthConditions moisture = this.getConditionsFromRainfall(world, xPos, yPos, zPos, 0.9f, 2.0f);
        EnumGrowthConditions temperature = this.getConditionsFromTemperature(world, xPos, yPos, zPos, 1.2f, 1.9f);
        EnumSet<EnumGrowthConditions> conditions = EnumSet.of(light, moisture, temperature);
        EnumGrowthConditions result = EnumGrowthConditions.HOSTILE;
        for (EnumGrowthConditions cond : conditions) {
            if (cond == EnumGrowthConditions.HOSTILE) {
                return EnumGrowthConditions.HOSTILE;
            }
            if (cond.ordinal() <= result.ordinal()) continue;
            result = cond;
        }
        return result;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize("growth.tropical");
    }
}

