/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IArboristTracker;
import forestry.api.arboriculture.ILeafTickHandler;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeMutation;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.arboriculture.ITreekeepingMode;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.arboriculture.gadgets.BlockFruitPod;
import forestry.arboriculture.gadgets.TileFruitPod;
import forestry.arboriculture.gadgets.TileLeaves;
import forestry.arboriculture.gadgets.TileSapling;
import forestry.arboriculture.genetics.ArboristTracker;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.arboriculture.genetics.TreeTemplates;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.SpeciesRoot;
import forestry.core.utils.BlockUtil;
import forestry.plugins.PluginArboriculture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class TreeHelper
extends SpeciesRoot
implements ITreeRoot {
    public static final String UID = "rootTrees";
    public static int treeSpeciesCount = -1;
    ArrayList<ITreekeepingMode> treekeepingModes = new ArrayList();
    public static ITreekeepingMode activeTreekeepingMode;
    public static ArrayList<ITree> treeTemplates;
    private static ArrayList<ITreeMutation> treeMutations;
    private final LinkedList<ILeafTickHandler> leafTickHandlers = new LinkedList();

    @Override
    public String getUID() {
        return UID;
    }

    public TreeHelper() {
        this.setResearchSuitability(new ItemStack(Blocks.field_150345_g, 1, Short.MAX_VALUE), 1.0f);
    }

    @Override
    public Class<? extends IIndividual> getMemberClass() {
        return ITree.class;
    }

    @Override
    public int getSpeciesCount() {
        if (treeSpeciesCount < 0) {
            treeSpeciesCount = 0;
            for (Map.Entry<String, IAllele> entry : AlleleManager.alleleRegistry.getRegisteredAlleles().entrySet()) {
                if (!(entry.getValue() instanceof IAlleleTreeSpecies) || !((IAlleleTreeSpecies)entry.getValue()).isCounted()) continue;
                ++treeSpeciesCount;
            }
        }
        return treeSpeciesCount;
    }

    @Override
    public boolean isMember(ItemStack itemstack) {
        return this.getType(itemstack) != EnumGermlingType.NONE;
    }

    @Override
    public boolean isMember(ItemStack stack, int type) {
        return this.getType(stack).ordinal() == type;
    }

    @Override
    public boolean isMember(IIndividual individual) {
        return individual instanceof ITree;
    }

    @Override
    public EnumGermlingType getType(ItemStack stack) {
        if (stack == null) {
            return EnumGermlingType.NONE;
        }
        if (ForestryItem.sapling.isItemEqual(stack)) {
            return EnumGermlingType.SAPLING;
        }
        if (ForestryItem.pollenFertile.isItemEqual(stack)) {
            return EnumGermlingType.POLLEN;
        }
        return EnumGermlingType.NONE;
    }

    @Override
    public ITree getTree(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileSapling)) {
            return null;
        }
        return ((TileSapling)tile).getTree();
    }

    @Override
    public ITree getMember(ItemStack itemstack) {
        if (!this.isMember(itemstack)) {
            return null;
        }
        if (itemstack.func_77978_p() == null) {
            return null;
        }
        return new Tree(itemstack.func_77978_p());
    }

    @Override
    public ITree getMember(NBTTagCompound compound) {
        return new Tree(compound);
    }

    @Override
    public ITree getTree(World world, ITreeGenome genome) {
        return new Tree(genome);
    }

    @Override
    public ItemStack getMemberStack(IIndividual tree, int type) {
        Item germlingItem;
        switch (EnumGermlingType.VALUES[type]) {
            case SAPLING: {
                germlingItem = ForestryItem.sapling.item();
                break;
            }
            case POLLEN: {
                germlingItem = ForestryItem.pollenFertile.item();
                break;
            }
            default: {
                throw new RuntimeException("Cannot instantiate a tree of type " + type);
            }
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        tree.writeToNBT(nbttagcompound);
        ItemStack treeStack = new ItemStack(germlingItem);
        treeStack.func_77982_d(nbttagcompound);
        return treeStack;
    }

    @Override
    public boolean plantSapling(World world, ITree tree, GameProfile owner, int x, int y, int z) {
        boolean placed = world.func_147465_d(x, y, z, ForestryBlock.saplingGE.block(), 0, 2);
        if (!placed) {
            return false;
        }
        if (!ForestryBlock.saplingGE.isBlockEqual(world, x, y, z)) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileSapling)) {
            world.func_147468_f(x, y, z);
            return false;
        }
        TileSapling sapling = (TileSapling)tile;
        sapling.setTree(tree.copy());
        sapling.setOwner(owner);
        world.func_147471_g(x, y, z);
        return true;
    }

    @Override
    public boolean setLeaves(World world, IIndividual tree, GameProfile owner, int x, int y, int z) {
        boolean placed = ForestryBlock.leaves.setBlock(world, x, y, z, 0, 2);
        if (!placed) {
            return false;
        }
        if (!ForestryBlock.leaves.isBlockEqual(world, x, y, z)) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileLeaves)) {
            world.func_147468_f(x, y, z);
            return false;
        }
        TileLeaves leaves = (TileLeaves)tile;
        leaves.setTree((ITree)tree.copy());
        leaves.setOwner(owner);
        world.func_147471_g(x, y, z);
        return true;
    }

    @Override
    public boolean setFruitBlock(World world, IAlleleFruit allele, float sappiness, short[] indices, int x, int y, int z) {
        int direction = BlockUtil.getDirectionalMetadata(world, x, y, z);
        if (direction < 0) {
            return false;
        }
        boolean placed = ForestryBlock.pods.setBlock(world, x, y, z, direction, 2);
        if (!placed) {
            return false;
        }
        if (!ForestryBlock.pods.isBlockEqual(world, x, y, z)) {
            return false;
        }
        TileFruitPod pod = BlockFruitPod.getPodTile((IBlockAccess)world, x, y, z);
        if (pod == null) {
            world.func_147468_f(x, y, z);
            return false;
        }
        pod.setFruit(allele, sappiness, indices);
        world.func_147471_g(x, y, z);
        return true;
    }

    @Override
    public ITreeGenome templateAsGenome(IAllele[] template) {
        return new TreeGenome(this.templateAsChromosomes(template));
    }

    @Override
    public ITreeGenome templateAsGenome(IAllele[] templateActive, IAllele[] templateInactive) {
        return new TreeGenome(this.templateAsChromosomes(templateActive, templateInactive));
    }

    @Override
    public ITree templateAsIndividual(IAllele[] template) {
        return new Tree(this.templateAsGenome(template));
    }

    @Override
    public ITree templateAsIndividual(IAllele[] templateActive, IAllele[] templateInactive) {
        return new Tree(this.templateAsGenome(templateActive, templateInactive));
    }

    @Override
    public IArboristTracker getBreedingTracker(World world, GameProfile player) {
        String filename = "ArboristTracker." + (player == null ? "common" : player.getId());
        ArboristTracker tracker = (ArboristTracker)world.func_72943_a(ArboristTracker.class, filename);
        if (tracker == null) {
            tracker = new ArboristTracker(filename, player);
            world.func_72823_a(filename, (WorldSavedData)tracker);
        }
        return tracker;
    }

    @Override
    public ArrayList<ITreekeepingMode> getTreekeepingModes() {
        return this.treekeepingModes;
    }

    @Override
    public ITreekeepingMode getTreekeepingMode(World world) {
        if (activeTreekeepingMode != null) {
            return activeTreekeepingMode;
        }
        IArboristTracker tracker = this.getBreedingTracker(world, null);
        String mode = tracker.getModeName();
        if (mode == null || mode.isEmpty()) {
            mode = PluginArboriculture.treekeepingMode;
        }
        this.setTreekeepingMode(world, mode);
        FMLCommonHandler.instance().getFMLLogger().debug("Set Treekeeping mode for a world to " + mode);
        return activeTreekeepingMode;
    }

    @Override
    public void registerTreekeepingMode(ITreekeepingMode mode) {
        this.treekeepingModes.add(mode);
    }

    @Override
    public void setTreekeepingMode(World world, String name) {
        activeTreekeepingMode = this.getTreekeepingMode(name);
        this.getBreedingTracker(world, null).setModeName(name);
    }

    @Override
    public ITreekeepingMode getTreekeepingMode(String name) {
        for (ITreekeepingMode mode : this.treekeepingModes) {
            if (!mode.getName().equals(name) && !mode.getName().equals(name.toLowerCase(Locale.ENGLISH))) continue;
            return mode;
        }
        FMLCommonHandler.instance().getFMLLogger().debug("Failed to find a Treekeeping mode called '%s', reverting to fallback.");
        return this.treekeepingModes.get(0);
    }

    @Override
    public ArrayList<ITree> getIndividualTemplates() {
        return treeTemplates;
    }

    @Override
    public void registerTemplate(String identifier, IAllele[] template) {
        treeTemplates.add(new Tree(PluginArboriculture.treeInterface.templateAsGenome(template)));
        this.speciesTemplates.put(identifier, template);
    }

    @Override
    public IAllele[] getDefaultTemplate() {
        return TreeTemplates.getDefaultTemplate();
    }

    public ArrayList<ITreeMutation> getMutations(boolean shuffle) {
        if (shuffle) {
            Collections.shuffle(treeMutations);
        }
        return treeMutations;
    }

    @Override
    public void registerMutation(IMutation mutation) {
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getTemplate()[0].getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele0().getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele1().getUID())) {
            return;
        }
        treeMutations.add((ITreeMutation)mutation);
    }

    @Override
    public void registerLeafTickHandler(ILeafTickHandler handler) {
        this.leafTickHandlers.add(handler);
    }

    @Override
    public Collection<ILeafTickHandler> getLeafTickHandlers() {
        return this.leafTickHandlers;
    }

    @Override
    public IChromosomeType[] getKaryotype() {
        return EnumTreeChromosome.values();
    }

    @Override
    public IChromosomeType getKaryotypeKey() {
        return EnumTreeChromosome.SPECIES;
    }

    static {
        treeTemplates = new ArrayList();
        treeMutations = new ArrayList();
    }
}

