/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gui;

import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleGrowth;
import forestry.api.arboriculture.ITree;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleEffect;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IFruitFamily;
import forestry.arboriculture.gui.ContainerTreealyzer;
import forestry.arboriculture.items.ItemGermlingGE;
import forestry.arboriculture.items.ItemTreealyzer;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.Allele;
import forestry.core.genetics.AllelePlantType;
import forestry.core.gui.GuiAlyzer;
import forestry.core.utils.StringUtil;
import forestry.plugins.PluginArboriculture;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.EnumPlantType;

public class GuiTreealyzer
extends GuiAlyzer {
    private ItemStack[] tempProductList;

    public GuiTreealyzer(EntityPlayer player, ItemTreealyzer.TreealyzerInventory inventory) {
        super(AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees"), player, new ContainerTreealyzer(player.field_71071_by, inventory), inventory, 1, inventory.func_70302_i_());
        this.guiName = "gui.treealyzer";
        ArrayList treeList = new ArrayList();
        ((ItemGermlingGE)ForestryItem.sapling.item()).addCreativeItems(treeList, false);
        for (ItemStack beeStack : treeList) {
            this.iconStacks.put(PluginArboriculture.treeInterface.getMember(beeStack).getIdent(), beeStack);
        }
    }

    @Override
    protected void func_146976_a(float var1, int mouseX, int mouseY) {
        super.func_146976_a(var1, mouseX, mouseY);
        int page = 0;
        ITree tree = null;
        EnumGermlingType treeType = EnumGermlingType.SAPLING;
        for (int k = 1; k < 7; ++k) {
            if (k == 5 || this.inventory.func_70301_a(k) == null) continue;
            tree = PluginArboriculture.treeInterface.getMember(this.inventory.func_70301_a(k));
            treeType = PluginArboriculture.treeInterface.getType(this.inventory.func_70301_a(k));
            if (tree == null || !tree.isAnalyzed()) continue;
            page = k;
            break;
        }
        switch (page) {
            case 1: {
                this.drawAnalyticsPage1(tree, treeType);
                break;
            }
            case 2: {
                this.drawAnalyticsPage2(tree);
                break;
            }
            case 3: {
                this.drawAnalyticsPage3(tree);
                break;
            }
            case 4: {
                this.drawAnalyticsPage4(tree);
                break;
            }
            case 6: {
                this.drawAnalyticsPageClassification(tree);
                break;
            }
            default: {
                this.drawAnalyticsOverview();
            }
        }
    }

    private void drawAnalyticsPage1(ITree tree, EnumGermlingType type) {
        this.startPage(12, 85, 150);
        this.drawLine(StringUtil.localize("gui.active"), 85);
        this.drawLine(StringUtil.localize("gui.inactive"), 150);
        this.newLine();
        this.newLine();
        String customPrimaryTreeKey = "trees.custom.treealyzer." + type.getName() + "." + tree.getGenome().getPrimary().getUnlocalizedName().replace("trees.species.", "");
        String customSecondaryTreeKey = "trees.custom.treealyzer." + type.getName() + "." + tree.getGenome().getSecondary().getUnlocalizedName().replace("trees.species.", "");
        this.drawSpeciesRow(StringUtil.localize("gui.species"), tree, EnumTreeChromosome.SPECIES, this.checkCustomName(customPrimaryTreeKey), this.checkCustomName(customSecondaryTreeKey));
        this.newLine();
        this.drawLine(StringUtil.localize("gui.saplings"), 12);
        this.drawLine(tree.getGenome().getActiveAllele(EnumTreeChromosome.FERTILITY.ordinal()).getName(), 85, tree, EnumTreeChromosome.FERTILITY, false);
        this.drawLine(tree.getGenome().getInactiveAllele(EnumTreeChromosome.FERTILITY.ordinal()).getName(), 150, tree, EnumTreeChromosome.FERTILITY, true);
        this.newLine();
        this.drawRow(StringUtil.localize("gui.maturity"), tree.getGenome().getActiveAllele(EnumTreeChromosome.MATURATION.ordinal()).getName(), tree.getGenome().getInactiveAllele(EnumTreeChromosome.MATURATION.ordinal()).getName(), tree, EnumTreeChromosome.MATURATION);
        this.drawLine(StringUtil.localize("gui.height"), 12);
        this.drawLine(tree.getGenome().getActiveAllele(EnumTreeChromosome.HEIGHT.ordinal()).getName(), 85, tree, EnumTreeChromosome.HEIGHT, false);
        this.drawLine(tree.getGenome().getInactiveAllele(EnumTreeChromosome.HEIGHT.ordinal()).getName(), 150, tree, EnumTreeChromosome.HEIGHT, true);
        this.newLine();
        this.drawLine(StringUtil.localize("gui.girth"), 12);
        this.drawLine(String.format("%sx%s", tree.getGenome().getGirth(), tree.getGenome().getGirth()), 85, tree, EnumTreeChromosome.FERTILITY, false);
        int secondGirth = ((IAlleleInteger)tree.getGenome().getInactiveAllele(EnumTreeChromosome.GIRTH.ordinal())).getValue();
        this.drawLine(String.format("%sx%s", secondGirth, secondGirth), 150, tree, EnumTreeChromosome.FERTILITY, true);
        this.newLine();
        this.drawLine(StringUtil.localize("gui.yield"), 12);
        this.drawLine(tree.getGenome().getActiveAllele(EnumTreeChromosome.YIELD.ordinal()).getName(), 85, tree, EnumTreeChromosome.YIELD, false);
        this.drawLine(tree.getGenome().getInactiveAllele(EnumTreeChromosome.YIELD.ordinal()).getName(), 150, tree, EnumTreeChromosome.YIELD, true);
        this.newLine();
        this.drawLine(StringUtil.localize("gui.sappiness"), 12);
        this.drawLine(tree.getGenome().getActiveAllele(EnumTreeChromosome.SAPPINESS.ordinal()).getName(), 85, tree, EnumTreeChromosome.SAPPINESS, false);
        IAllele sappiness = tree.getGenome().getInactiveAllele(EnumTreeChromosome.SAPPINESS.ordinal());
        String sap = sappiness instanceof IAlleleFloat ? sappiness.getName() : Allele.saplingsLowest.getName();
        this.drawLine(sap, 150, tree, EnumTreeChromosome.SAPPINESS, true);
        this.newLine();
        this.drawRow(StringUtil.localize("gui.effect"), tree.getGenome().getEffect().getName(), ((IAlleleEffect)tree.getGenome().getInactiveAllele(EnumTreeChromosome.EFFECT.ordinal())).getName(), tree, EnumTreeChromosome.EFFECT);
        this.newLine();
        this.newLine();
        this.endPage();
    }

    private void drawAnalyticsPage2(ITree tree) {
        this.startPage();
        int speciesDominance0 = this.getColorCoding(tree.getGenome().getPrimary().isDominant());
        int speciesDominance1 = this.getColorCoding(tree.getGenome().getSecondary().isDominant());
        this.drawLine(StringUtil.localize("gui.active"), 85);
        this.drawLine(StringUtil.localize("gui.inactive"), 150);
        this.newLine();
        this.newLine();
        this.drawLine(StringUtil.localize("gui.growth"), 12);
        this.drawLine(tree.getGenome().getGrowthProvider().getDescription(), 85, tree, EnumTreeChromosome.GROWTH, false);
        this.drawLine(((IAlleleGrowth)tree.getGenome().getInactiveAllele(EnumTreeChromosome.GROWTH.ordinal())).getProvider().getDescription(), 150, tree, EnumTreeChromosome.GROWTH, true);
        this.newLine();
        this.drawLine(StringUtil.localize("gui.native"), 12);
        this.drawLine(StringUtil.localize("gui." + tree.getGenome().getPrimary().getPlantType().toString().toLowerCase(Locale.ENGLISH)), 85, speciesDominance0);
        this.drawLine(StringUtil.localize("gui." + tree.getGenome().getSecondary().getPlantType().toString().toLowerCase(Locale.ENGLISH)), 150, speciesDominance1);
        this.newLine();
        this.drawLine(StringUtil.localize("gui.tolerated"), 12);
        EnumPlantType[] tolerated0 = tree.getGenome().getPlantTypes().toArray(new EnumPlantType[0]);
        EnumPlantType[] tolerated1 = new EnumPlantType[]{};
        IAllele allele1 = tree.getGenome().getInactiveAllele(EnumTreeChromosome.PLANT.ordinal());
        if (allele1 instanceof AllelePlantType) {
            tolerated1 = ((AllelePlantType)allele1).getPlantTypes().toArray(new EnumPlantType[0]);
        }
        int max = tolerated0.length > tolerated1.length ? tolerated0.length : tolerated1.length;
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                this.newLine();
            }
            if (tolerated0.length > i) {
                this.drawLine(StringUtil.localize("gui." + tolerated0[i].toString().toLowerCase(Locale.ENGLISH)), 85, tree, EnumTreeChromosome.PLANT, false);
            }
            if (tolerated1.length <= i) continue;
            this.drawLine(StringUtil.localize("gui." + tolerated1[i].toString().toLowerCase(Locale.ENGLISH)), 150, tree, EnumTreeChromosome.PLANT, true);
        }
        this.newLine();
        this.drawLine(StringUtil.localize("gui.supports"), 12);
        IFruitFamily[] families0 = tree.getGenome().getPrimary().getSuitableFruit().toArray(new IFruitFamily[0]);
        IFruitFamily[] families1 = tree.getGenome().getPrimary().getSuitableFruit().toArray(new IFruitFamily[0]);
        max = families0.length > families1.length ? families0.length : families1.length;
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                this.newLine();
            }
            if (families0.length > i) {
                this.drawLine(families0[i].getName(), 85, speciesDominance0);
            }
            if (families1.length <= i) continue;
            this.drawLine(families1[i].getName(), 150, speciesDominance1);
        }
        this.newLine();
        this.newLine();
        int fruitDominance0 = this.getColorCoding(tree.getGenome().getActiveAllele(EnumTreeChromosome.FRUITS.ordinal()).isDominant());
        int fruitDominance1 = this.getColorCoding(tree.getGenome().getInactiveAllele(EnumTreeChromosome.FRUITS.ordinal()).isDominant());
        this.drawLine(StringUtil.localize("gui.fruits"), 12);
        String strike = "";
        IAllele fruit0 = tree.getGenome().getActiveAllele(EnumTreeChromosome.FRUITS.ordinal());
        if (!tree.canBearFruit() && fruit0 != Allele.fruitNone) {
            strike = "\u00a7m";
        }
        this.drawLine(strike + StringUtil.localize(tree.getGenome().getFruitProvider().getDescription()), 85, fruitDominance0);
        strike = "";
        IAllele fruit1 = tree.getGenome().getInactiveAllele(EnumTreeChromosome.FRUITS.ordinal());
        if (!tree.getGenome().getSecondary().getSuitableFruit().contains(((IAlleleFruit)fruit1).getProvider().getFamily()) && fruit1 != Allele.fruitNone) {
            strike = "\u00a7m";
        }
        this.drawLine(strike + StringUtil.localize(((IAlleleFruit)fruit1).getProvider().getDescription()), 150, fruitDominance1);
        this.newLine();
        this.drawLine(StringUtil.localize("gui.family"), 12);
        IFruitFamily primary = tree.getGenome().getFruitProvider().getFamily();
        IFruitFamily secondary = ((IAlleleFruit)tree.getGenome().getInactiveAllele(EnumTreeChromosome.FRUITS.ordinal())).getProvider().getFamily();
        if (primary != null) {
            this.drawLine(primary.getName(), 85, fruitDominance0);
        }
        if (secondary != null) {
            this.drawLine(secondary.getName(), 150, fruitDominance1);
        }
        this.endPage();
    }

    private void drawAnalyticsPage3(ITree tree) {
        this.tempProductList = tree.getProduceList();
        this.startPage(12, 85, 150);
        this.drawLine(StringUtil.localize("gui.beealyzer.produce") + ":", 12);
        this.newLine();
        int x = 12;
        for (ItemStack stack : this.tempProductList) {
            field_146296_j.func_77015_a(this.field_146289_q, this.field_146297_k.field_71446_o, stack, (int)((float)(this.field_147003_i + x) * (1.0f / this.factor)), (int)((float)(this.field_147009_r + this.getLineY()) * (1.0f / this.factor)));
            if ((x += 18) <= this.adjustToFactor(148)) continue;
            x = 12;
            this.newLine();
        }
        this.newLine();
        this.newLine();
        this.drawLine(StringUtil.localize("gui.beealyzer.specialty") + ":", 12);
        this.newLine();
        x = 12;
        for (ItemStack stack : tree.getSpecialtyList()) {
            field_146296_j.func_77015_a(this.field_146289_q, this.field_146297_k.field_71446_o, stack, (int)((float)(this.field_147003_i + x) * (1.0f / this.factor)), (int)((float)(this.field_147009_r + this.getLineY()) * (1.0f / this.factor)));
            if ((x += 18) <= this.adjustToFactor(148)) continue;
            x = 12;
            this.newLine();
        }
        this.endPage();
    }
}

