/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.config.ForestryBlock;
import forestry.core.worldgen.BlockType;
import forestry.core.worldgen.WorldGenBase;

public class WorldGenBaobab
extends WorldGenTree {
    public WorldGenBaobab(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        int times;
        this.generateTreeTrunk(this.height - 1, this.girth);
        if (this.rand.nextFloat() < 0.3f) {
            this.generateCylinder(new WorldGenBase.Vector(0.0f, this.height - 1, 0.0f), this.girth, 1, this.wood, WorldGenBase.EnumReplaceMode.NONE);
        } else if (this.rand.nextBoolean()) {
            this.generateCylinder(new WorldGenBase.Vector(0.0f, this.height - 1, 0.0f), this.girth - 1, 1, this.wood, WorldGenBase.EnumReplaceMode.NONE);
        }
        int leafSpawn = this.height + 1;
        this.generateAdjustedCylinder(leafSpawn--, 2.0f, 1, this.leaf);
        this.generateAdjustedCylinder(leafSpawn--, 1.5f, 1, this.leaf);
        this.generateAdjustedCylinder(leafSpawn--, 1.0f, 1, this.leaf);
        for (times = 0; times < this.height / 2; ++times) {
            int h = this.height - 1 + this.rand.nextInt(4);
            if (this.rand.nextBoolean() && h < this.height / 2) {
                h = this.height / 2 + this.rand.nextInt(this.height / 2);
            }
            int x_off = -this.girth + this.rand.nextInt(2 * this.girth);
            int y_off = -this.girth + this.rand.nextInt(2 * this.girth);
            this.generateSphere(new WorldGenBase.Vector(x_off, h, y_off), 1 + (this.girth > 1 ? this.rand.nextInt(this.girth - 1) : 0), this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        }
        for (times = 0; times < this.height / 4; ++times) {
            int delim;
            int h = delim + ((delim = this.modifyByHeight(6, 0, this.height)) < this.height ? this.rand.nextInt(this.height - delim) : 0);
            if (this.rand.nextBoolean() && h < this.height / 2) {
                h = this.height / 2 + this.rand.nextInt(this.height / 2);
            }
            int x_off = -1 + this.rand.nextInt(3);
            int y_off = -1 + this.rand.nextInt(3);
            this.generateSphere(new WorldGenBase.Vector(x_off, h, y_off), 1 + this.rand.nextInt(2), this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        }
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(6, 6);
        this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
    }

    @Override
    public BlockType getWood() {
        return new BlockType(ForestryBlock.log2, 2);
    }
}

