/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.config.ForestryBlock;
import forestry.core.worldgen.BlockType;
import forestry.core.worldgen.WorldGenBase;

public class WorldGenPapaya
extends WorldGenTree {
    public WorldGenPapaya(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        int yCenter = this.height - this.girth;
        yCenter = yCenter > 3 ? yCenter : 4;
        this.generateSphere(this.getCenteredAt(yCenter, 0), 2 + this.rand.nextInt(this.girth), this.leaf, WorldGenBase.EnumReplaceMode.NONE);
    }

    @Override
    public BlockType getWood() {
        return new BlockType(ForestryBlock.log5, 3);
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(7, 2);
        this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
    }
}

