/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.circuits.ISolderManager;
import forestry.api.core.ForestryAPI;
import forestry.core.EnumErrorCode;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.circuits.ISolderingIron;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.interfaces.IErrorSource;
import forestry.core.items.ItemForestry;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemInventory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemSolderingIron
extends ItemForestry
implements ISolderingIron {
    public ItemSolderingIron() {
        this.func_77625_d(1);
        this.func_77656_e(5);
    }

    public boolean func_77662_d() {
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (Proxies.common.isSimulating(world)) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.SolderingIronGUI.ordinal(), world, (int)entityplayer.field_70165_t, (int)entityplayer.field_70163_u, (int)entityplayer.field_70161_v);
        }
        return itemstack;
    }

    public static class SolderingInventory
    extends ItemInventory
    implements IErrorSource {
        ICircuitLayout layout;
        EnumErrorCode errorState;
        short blankSlot = 0;
        short finishedSlot = 1;
        short ingredientSlot1 = (short)2;

        public SolderingInventory() {
            super(ItemSolderingIron.class, 6);
            this.layout = ChipsetManager.circuitRegistry.getDefaultLayout();
        }

        public SolderingInventory(ItemStack itemstack) {
            super(ItemSolderingIron.class, 6, itemstack);
            this.layout = ChipsetManager.circuitRegistry.getDefaultLayout();
        }

        public ICircuitLayout getLayout() {
            return this.layout;
        }

        public void setLayout(String uid) {
            this.layout = ChipsetManager.circuitRegistry.getLayout(uid);
        }

        public void advanceLayout() {
            Iterator<Map.Entry<String, ICircuitLayout>> it = ChipsetManager.circuitRegistry.getRegisteredLayouts().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, ICircuitLayout> entry = it.next();
                if (!entry.getKey().equals(this.layout.getUID())) continue;
                if (it.hasNext()) {
                    this.layout = it.next().getValue();
                    break;
                }
                this.layout = ChipsetManager.circuitRegistry.getRegisteredLayouts().entrySet().iterator().next().getValue();
                break;
            }
        }

        public void regressLayout() {
            Iterator<Map.Entry<String, ICircuitLayout>> it = ChipsetManager.circuitRegistry.getRegisteredLayouts().entrySet().iterator();
            ICircuitLayout previous = null;
            while (it.hasNext()) {
                Map.Entry<String, ICircuitLayout> entry = it.next();
                if (entry.getKey().equals(this.layout.getUID())) {
                    if (previous != null) {
                        this.layout = previous;
                        break;
                    }
                    while (it.hasNext()) {
                        this.layout = it.next().getValue();
                    }
                    break;
                }
                previous = entry.getValue();
            }
        }

        private Collection<ICircuit> getCircuits(EnumCircuitBoardType type, boolean doConsume) {
            ArrayList<ICircuit> circuits = new ArrayList<ICircuit>();
            for (short i = 0; i < type.sockets; i = (short)(i + 1)) {
                CircuitRecipe recipe;
                ItemStack ingredient = this.inventoryStacks[this.ingredientSlot1 + i];
                if (ingredient == null || (recipe = SolderManager.getMatchingRecipe(this.layout, ingredient)) == null || this.getCount(recipe.circuit, circuits) >= recipe.circuit.getLimit()) continue;
                if (doConsume) {
                    this.func_70298_a(this.ingredientSlot1 + i, recipe.resource.field_77994_a);
                }
                circuits.add(recipe.circuit);
            }
            return circuits;
        }

        public void trySolder() {
            if (this.inventoryStacks[this.blankSlot] == null) {
                return;
            }
            if (this.inventoryStacks[this.blankSlot].field_77994_a > 1) {
                return;
            }
            if (this.inventoryStacks[this.finishedSlot] != null) {
                return;
            }
            ItemStack blank = this.inventoryStacks[this.blankSlot];
            if (!ChipsetManager.circuitRegistry.isChipset(blank)) {
                return;
            }
            if (blank.func_77960_j() < 0 || blank.func_77960_j() >= EnumCircuitBoardType.values().length) {
                return;
            }
            EnumCircuitBoardType type = EnumCircuitBoardType.values()[blank.func_77960_j()];
            Collection<ICircuit> circuits = this.getCircuits(type, false);
            if (circuits.size() <= 0) {
                return;
            }
            if (circuits.size() != type.sockets) {
                this.errorState = EnumErrorCode.CIRCUITMISMATCH;
                return;
            }
            circuits = this.getCircuits(type, true);
            this.inventoryStacks[this.finishedSlot] = ItemCircuitBoard.createCircuitboard(type, this.layout, circuits.toArray(new ICircuit[0]));
            this.inventoryStacks[this.blankSlot] = null;
        }

        public int getCount(ICircuit circuit, ArrayList<ICircuit> circuits) {
            int count = 0;
            for (ICircuit other : circuits) {
                if (!other.getUID().equals(circuit.getUID())) continue;
                ++count;
            }
            return count;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbttagcompound) {
        }

        @Override
        public void writeToNBT(NBTTagCompound nbttagcompound) {
        }

        @Override
        public void func_70296_d() {
            this.errorState = EnumErrorCode.OK;
            this.trySolder();
        }

        @Override
        public boolean throwsErrors() {
            return true;
        }

        @Override
        public EnumErrorCode getErrorState() {
            if (this.inventoryStacks[this.blankSlot] == null) {
                return EnumErrorCode.NOCIRCUITBOARD;
            }
            if (this.inventoryStacks[this.blankSlot].field_77994_a > 1) {
                return EnumErrorCode.WRONGSTACKSIZE;
            }
            if (this.errorState != EnumErrorCode.OK) {
                return this.errorState;
            }
            return EnumErrorCode.OK;
        }
    }

    public static class SolderManager
    implements ISolderManager {
        public static ArrayList<CircuitRecipe> recipes = new ArrayList();

        @Override
        public void addRecipe(ICircuitLayout layout, ItemStack resource, ICircuit circuit) {
            if (layout == null) {
                throw new IllegalArgumentException("layout may not be null");
            }
            if (resource == null) {
                throw new IllegalArgumentException("resource may not be null");
            }
            if (circuit == null) {
                throw new IllegalArgumentException("circuit may not be null");
            }
            recipes.add(new CircuitRecipe(layout, resource, circuit));
        }

        public static CircuitRecipe getMatchingRecipe(ICircuitLayout layout, ItemStack resource) {
            if (layout == null || resource == null) {
                return null;
            }
            for (CircuitRecipe recipe : recipes) {
                if (!recipe.matches(layout, resource)) continue;
                return recipe;
            }
            return null;
        }
    }

    public static class CircuitRecipe {
        ICircuitLayout layout;
        ItemStack resource;
        ICircuit circuit;

        public CircuitRecipe(ICircuitLayout layout, ItemStack resource, ICircuit circuit) {
            this.resource = resource;
            this.layout = layout;
            this.circuit = circuit;
        }

        public boolean matches(ICircuitLayout layout, ItemStack itemstack) {
            if (!this.layout.getUID().equals(layout.getUID())) {
                return false;
            }
            return itemstack.func_77969_a(this.resource);
        }
    }
}

