/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.config;

import forestry.core.config.Property;
import forestry.core.config.Version;
import forestry.core.proxy.Proxies;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.minecraftforge.common.config.Configuration;

public class Configuration {
    private String newLine;
    private ArrayList<String> purge = new ArrayList();
    private TreeMap<String, ArrayList<Property>> categorized = new TreeMap();

    public Configuration() {
        this.newLine = System.getProperty("line.separator");
    }

    public void addPurge(String key) {
        this.purge.add(key);
    }

    public Property get(String key, String category, boolean defaultVal) {
        Property existing = this.getExisting(key, category);
        if (existing != null) {
            return existing;
        }
        Property property = new Property(key, new Boolean(defaultVal).toString());
        this.categorized.get(category).add(property);
        return property;
    }

    public Property get(String key, String category, int defaultVal) {
        Property existing = this.getExisting(key, category);
        if (existing != null) {
            return existing;
        }
        Property property = new Property(key, new Integer(defaultVal).toString());
        this.categorized.get(category).add(property);
        return property;
    }

    public Property get(String key, String category, float defaultVal) {
        Property existing = this.getExisting(key, category);
        if (existing != null) {
            return existing;
        }
        Property property = new Property(key, new Float(defaultVal).toString());
        this.categorized.get(category).add(property);
        return property;
    }

    public Property get(String key, String category, String defaultVal) {
        Property existing = this.getExisting(key, category);
        if (existing != null) {
            return existing;
        }
        Property property = new Property(key, defaultVal);
        this.categorized.get(category).add(property);
        return property;
    }

    public void set(String key, String category, boolean val) {
        Property existing = this.getExisting(key, category);
        if (existing != null) {
            existing.Value = new Boolean(val).toString();
            return;
        }
        Property property = new Property(key, new Boolean(val).toString());
        this.categorized.get(category).add(property);
    }

    public void set(String key, String category, String val) {
        Property existing = this.getExisting(key, category);
        if (existing != null) {
            existing.Value = val;
            return;
        }
        Property property = new Property(key, val);
        this.categorized.get(category).add(property);
    }

    public void set(String key, String category, int val) {
        Property existing = this.getExisting(key, category);
        if (existing != null) {
            existing.Value = new Integer(val).toString();
            return;
        }
        Property property = new Property(key, new Integer(val).toString());
        this.categorized.get(category).add(property);
    }

    public void set(String key, String category, float val) {
        Property existing = this.getExisting(key, category);
        if (existing != null) {
            existing.Value = new Float(val).toString();
            return;
        }
        Property property = new Property(key, new Float(val).toString());
        this.categorized.get(category).add(property);
    }

    public Property getExisting(String key, String category) {
        if (!this.categorized.containsKey(category)) {
            this.loadCategory(category);
        }
        for (Property property : this.categorized.get(category)) {
            if (!property.Key.equals(key)) continue;
            return property;
        }
        return null;
    }

    public File getCategoryFile(String category) {
        return new File(Proxies.common.getForestryRoot(), "config/" + "Forestry".toLowerCase(Locale.ENGLISH) + "/" + category + ".conf");
    }

    public void loadCategory(String category) {
        File file = this.getCategoryFile(category);
        this.categorized.remove(category);
        this.categorized.put(category, new ArrayList());
        try {
            String line;
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                return;
            }
            if (!file.canRead()) {
                return;
            }
            Configuration.UnicodeInputStreamReader filein = new Configuration.UnicodeInputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            BufferedReader reader = new BufferedReader((Reader)filein);
            String lastComment = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) {
                    if (line.length() <= 3) continue;
                    lastComment = line.substring(2, line.length() - 1);
                    continue;
                }
                if (!line.contains("=")) continue;
                String[] tokens = line.split("=");
                Property property = tokens.length > 1 ? new Property(tokens[0], tokens[1].trim()) : new Property(tokens[0], "");
                if (lastComment != null) {
                    property.Comment = lastComment;
                    lastComment = null;
                }
                this.categorized.get(category).add(property);
            }
            reader.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void save() {
        for (Map.Entry<String, ArrayList<Property>> entry : this.categorized.entrySet()) {
            this.saveFile(this.getCategoryFile(entry.getKey()), entry.getValue());
        }
    }

    private void saveFile(File file, ArrayList<Property> properties) {
        try {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists() && !file.createNewFile()) {
                return;
            }
            if (!file.canWrite()) {
                return;
            }
            FileOutputStream fileout = new FileOutputStream(file);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileout, "UTF-8"));
            writer.write("# Forestry" + this.newLine + "# " + Version.getVersion() + this.newLine);
            writer.write("#" + this.newLine + "# Config files:" + this.newLine);
            writer.write("# base.conf\t\t-\t Contains Forge configuration for block and item ids" + this.newLine);
            writer.write("# common.conf\t\t-\t Contains all options common to Forestry" + this.newLine);
            writer.write("# apiculture.conf\t-\t Contains all options for bee breeding" + this.newLine);
            writer.write("# backpacks.conf\t-\t Contains custom configurations for backpacks" + this.newLine);
            writer.write("# pipes.conf\t\t-\t Configures item id for the apiarist's pipe" + this.newLine);
            writer.write("# gamemodes/\t\t-\t Configures available gamemodes");
            TreeMap<String, ArrayList<Property>> subsectioned = this.getSubsectioned(properties);
            for (Map.Entry<String, ArrayList<Property>> entry : subsectioned.entrySet()) {
                writer.write(this.newLine + this.newLine + "#####################" + this.newLine + "# " + entry.getKey().toUpperCase() + this.newLine + "#####################" + this.newLine);
                for (Property property : entry.getValue()) {
                    if (this.purge.contains(property.Key)) continue;
                    if (property.Comment != null) {
                        writer.write("# " + property.Comment + this.newLine);
                    }
                    writer.write(property.Key + "=" + property.Value + this.newLine);
                }
            }
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private TreeMap<String, ArrayList<Property>> getSubsectioned(ArrayList<Property> properties) {
        TreeMap<String, ArrayList<Property>> subsectioned = new TreeMap<String, ArrayList<Property>>();
        for (Property property : properties) {
            String subsection = property.Key.split("\\.")[0];
            if (!subsectioned.containsKey(subsection)) {
                subsectioned.put(subsection, new ArrayList());
            }
            subsectioned.get(subsection).add(property);
        }
        return subsectioned;
    }
}

