/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import buildcraft.api.gates.ITrigger;
import com.mojang.authlib.GameProfile;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.config.Defaults;
import forestry.core.interfaces.IErrorSource;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.interfaces.IOwnable;
import forestry.core.interfaces.IPowerHandler;
import forestry.core.network.ForestryPacket;
import forestry.core.network.INetworkedEntity;
import forestry.core.network.PacketPayload;
import forestry.core.network.PacketTileUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumAccess;
import forestry.core.utils.ForestryTank;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.Vect;
import java.util.LinkedList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public abstract class TileForestry
extends TileEntity
implements INetworkedEntity,
IOwnable,
IErrorSource {
    protected boolean isInited = false;
    protected int energyConsumed;
    protected int energyLast;
    protected int energyReceived;
    private ForgeDirection orientation = ForgeDirection.WEST;
    public EnumErrorCode errorState = EnumErrorCode.OK;
    public GameProfile owner = null;
    private EnumAccess access = EnumAccess.SHARED;

    public Vect Coords() {
        return new Vect(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public World getWorld() {
        return this.func_145831_w();
    }

    public void openGui(EntityPlayer player) {
    }

    public void rotateAfterPlacement(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack stack) {
        int l = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            this.setOrientation(ForgeDirection.NORTH);
        }
        if (l == 1) {
            this.setOrientation(ForgeDirection.EAST);
        }
        if (l == 2) {
            this.setOrientation(ForgeDirection.SOUTH);
        }
        if (l == 3) {
            this.setOrientation(ForgeDirection.WEST);
        }
    }

    public void func_145845_h() {
        IPowerHandler receptor;
        if (!this.isInited) {
            this.initialize();
            this.isInited = true;
        }
        if (!Proxies.common.isSimulating(this.field_145850_b)) {
            return;
        }
        if (this instanceof IPowerHandler && (receptor = (IPowerHandler)((Object)this)).getPowerHandler() != null) {
            receptor.getPowerHandler().update();
        }
    }

    public abstract void initialize();

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.access = nbttagcompound.func_74764_b("Access") ? EnumAccess.values()[nbttagcompound.func_74762_e("Access")] : EnumAccess.SHARED;
        if (nbttagcompound.func_74764_b("owner")) {
            this.owner = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.func_74775_l("owner"));
        }
        this.orientation = nbttagcompound.func_74764_b("Orientation") ? ForgeDirection.values()[nbttagcompound.func_74762_e("Orientation")] : ForgeDirection.WEST;
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("Access", this.access.ordinal());
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)nbt, (GameProfile)this.owner);
            nbttagcompound.func_74782_a("owner", (NBTBase)nbt);
        }
        if (this.orientation != null) {
            nbttagcompound.func_74768_a("Orientation", this.orientation.ordinal());
        }
    }

    @Override
    public void sendNetworkUpdate() {
        PacketTileUpdate packet = new PacketTileUpdate(this);
        Proxies.net.sendNetworkPacket(packet, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Packet func_145844_m() {
        PacketTileUpdate packet = new PacketTileUpdate(this);
        return packet.getPacket();
    }

    public abstract PacketPayload getPacketPayload();

    public abstract void fromPacketPayload(PacketPayload var1);

    @Override
    public void fromPacket(ForestryPacket packetRaw) {
        PacketTileUpdate packet = (PacketTileUpdate)packetRaw;
        if (this.orientation != packet.getOrientation()) {
            this.orientation = packet.getOrientation();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.errorState = packet.getErrorState();
        this.owner = packet.getOwner();
        this.access = packet.getAccess();
        this.fromPacketPayload(packet.payload);
    }

    public LinkedList<ITrigger> getCustomTriggers() {
        return null;
    }

    public void onRemoval() {
    }

    public boolean isActivated() {
        return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public ForgeDirection getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ForgeDirection orientation) {
        if (this.orientation == orientation) {
            return;
        }
        this.orientation = orientation;
        this.sendNetworkUpdate();
    }

    public void setErrorState(EnumErrorCode state) {
        if (this.errorState == state) {
            return;
        }
        this.errorState = state;
        this.sendNetworkUpdate();
    }

    @Override
    public boolean throwsErrors() {
        return true;
    }

    @Override
    public EnumErrorCode getErrorState() {
        return this.errorState;
    }

    @Override
    public boolean allowsRemoval(EntityPlayer player) {
        if (!this.isOwnable()) {
            return true;
        }
        if (!this.isOwned()) {
            return true;
        }
        if (this.isOwner(player)) {
            return true;
        }
        if (Proxies.common.isOp(player)) {
            return true;
        }
        return this.getAccess() == EnumAccess.SHARED;
    }

    @Override
    public boolean allowsInteraction(EntityPlayer player) {
        if (Config.disablePermissions) {
            return true;
        }
        if (!this.isOwnable()) {
            return true;
        }
        if (!this.isOwned()) {
            return true;
        }
        if (this.isOwner(player)) {
            return true;
        }
        if (Proxies.common.isOp(player)) {
            return true;
        }
        return this.getAccess() == EnumAccess.SHARED || this.getAccess() == EnumAccess.VIEWABLE;
    }

    @Override
    public EnumAccess getAccess() {
        return this.access;
    }

    @Override
    public boolean isOwnable() {
        return false;
    }

    @Override
    public boolean isOwned() {
        return this.owner != null;
    }

    @Override
    public GameProfile getOwnerProfile() {
        return this.owner;
    }

    public EntityPlayer getOwnerEntity() {
        if (this.owner != null) {
            return this.field_145850_b.func_152378_a(this.owner.getId());
        }
        return null;
    }

    @Override
    public void setOwner(EntityPlayer player) {
        this.owner = player.func_146103_bH();
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        if (this.owner != null) {
            return this.owner.getId().compareTo(player.getPersistentID()) == 0;
        }
        return false;
    }

    @Override
    public boolean switchAccessRule(EntityPlayer player) {
        if (!this.isOwner(player)) {
            return false;
        }
        this.access = this.access.ordinal() < EnumAccess.values().length - 1 ? EnumAccess.values()[this.access.ordinal() + 1] : EnumAccess.values()[0];
        return true;
    }

    public abstract String getInventoryName();

    public boolean hasCustomInventoryName() {
        return true;
    }

    public abstract boolean isUseableByPlayer(EntityPlayer var1);

    public InventoryAdapter getInternalInventory() {
        return null;
    }

    public boolean isItemValidForSlot(int slotIndex, ItemStack itemstack) {
        return true;
    }

    public boolean canInsertItem(int i, ItemStack itemstack, int j) {
        return this.canPutStackFromSide(i, itemstack, j);
    }

    protected boolean canTakeStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        return this.getAccess() != EnumAccess.PRIVATE;
    }

    public boolean canExtractItem(int i, ItemStack itemstack, int j) {
        return this.canTakeStackFromSide(i, itemstack, j);
    }

    protected boolean canPutStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        return this.getAccess() != EnumAccess.PRIVATE;
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        if (this.getInternalInventory() == null) {
            return Defaults.FACINGS_NONE;
        }
        return this.getInternalInventory().getSizeInventorySide(side);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this instanceof ILiquidTankContainer) {
            ForestryTank[] tanks = ((ILiquidTankContainer)((Object)this)).getTanks();
            FluidTankInfo[] info = new FluidTankInfo[tanks.length];
            for (int i = 0; i < info.length; ++i) {
                info[i] = tanks[i].getInfo();
            }
            return info;
        }
        return ForestryTank.DUMMY_TANKINFO_ARRAY;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return resource != null ? this.drain(from, resource.amount, doDrain) : null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }
}

