/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import buildcraft.api.gates.ITrigger;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ISpecialInventory;
import forestry.core.config.ForestryBlock;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.gadgets.TileForestry;
import forestry.core.interfaces.IClimatised;
import forestry.core.interfaces.IHintSource;
import forestry.core.network.PacketPayload;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumAccess;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.Utils;
import forestry.plugins.PluginApiculture;
import forestry.plugins.PluginCore;
import forestry.plugins.PluginEnergy;
import forestry.plugins.PluginFactory;
import forestry.plugins.PluginMail;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileMachine
extends TileForestry
implements ISpecialInventory,
IClimatised,
IHintSource {
    int oldkind;
    NBTTagCompound olddata;
    private HashMap<Block, HashMap<Integer, MachineDefinition>> definitionMap;

    @Override
    public boolean throwsErrors() {
        return false;
    }

    @Override
    public boolean hasHints() {
        return false;
    }

    @Override
    public String[] getHints() {
        return null;
    }

    @Override
    public boolean isClimatized() {
        return false;
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.NORMAL;
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.NORMAL;
    }

    @Override
    public float getExactTemperature() {
        return 0.0f;
    }

    @Override
    public float getExactHumidity() {
        return 0.0f;
    }

    @Override
    public boolean isOwnable() {
        return true;
    }

    protected void createMachine() {
    }

    @Override
    public void initialize() {
        if (!Proxies.common.isSimulating(this.field_145850_b)) {
            return;
        }
        if (this.olddata != null) {
            this.legacyConversion(this.oldkind, this.olddata);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
    }

    @Override
    public void onRemoval() {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        int kind;
        super.func_145839_a(nbttagcompound);
        this.oldkind = kind = nbttagcompound.func_74762_e("Kind");
        this.olddata = nbttagcompound;
    }

    private void createDefinitionMap() {
        this.definitionMap = new HashMap();
        HashMap<Integer, MachineDefinition> machineMap = new HashMap<Integer, MachineDefinition>();
        machineMap.put(2, PluginFactory.definitionBottler);
        machineMap.put(5, PluginFactory.definitionCarpenter);
        machineMap.put(8, PluginFactory.definitionCentrifuge);
        machineMap.put(11, PluginFactory.definitionFabricator);
        machineMap.put(0, PluginFactory.definitionFermenter);
        machineMap.put(6, PluginFactory.definitionMoistener);
        machineMap.put(3, PluginFactory.definitionRaintank);
        machineMap.put(9, PluginFactory.definitionSqueezer);
        machineMap.put(1, PluginFactory.definitionStill);
        machineMap.put(7, PluginApiculture.definitionApiary);
        machineMap.put(4, PluginEnergy.definitionGenerator);
        this.definitionMap.put(ForestryBlock.factoryTESR.block(), machineMap);
        HashMap<Integer, MachineDefinition> millMap = new HashMap<Integer, MachineDefinition>();
        millMap.put(5, PluginMail.definitionMailbox);
        millMap.put(6, PluginMail.definitionTradestation);
        millMap.put(7, PluginMail.definitionPhilatelist);
        millMap.put(3, PluginApiculture.definitionChest);
        millMap.put(4, PluginCore.definitionAnalyzer);
        millMap.put(1, PluginFactory.definitionRainmaker);
        this.definitionMap.put(ForestryBlock.factoryPlain.block(), millMap);
        HashMap<Integer, MachineDefinition> engineMap = new HashMap<Integer, MachineDefinition>();
        engineMap.put(0, PluginEnergy.definitionEngineBronze);
        engineMap.put(1, PluginEnergy.definitionEngineCopper);
        engineMap.put(2, PluginEnergy.definitionEngineTin);
        this.definitionMap.put(ForestryBlock.engine.block(), engineMap);
    }

    private void legacyConversion(int kind, NBTTagCompound nbttagcompound) {
        Block block;
        if (this.definitionMap == null) {
            this.createDefinitionMap();
        }
        if (!this.definitionMap.containsKey(block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e)) || !this.definitionMap.get(block).containsKey(kind)) {
            this.commitSeppuku(block, kind);
            return;
        }
        MachineDefinition definition = this.definitionMap.get(block).get(kind);
        Proxies.log.info("Converting obsolete gadget %s-%s to new '%s' %s-%s", block.func_149739_a(), kind, definition.teIdent, definition.block.func_149739_a(), definition.meta);
        Proxies.log.info("Removing old tile entity...");
        this.field_145850_b.func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        Proxies.log.info("Setting to new block id...");
        this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, definition.block, definition.meta, 2);
        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (tile == null) {
            throw new RuntimeException("Failed to set new block tile entity!");
        }
        if (tile.getClass() != definition.teClass) {
            throw new RuntimeException(String.format("Converted tile entity was '%s' instead of expected '%s'", tile.getClass(), definition.teClass));
        }
        Proxies.log.info("Refreshing converted tile entity %s with nbt data...", (Object)tile.getClass());
        if (nbttagcompound.func_74764_b("Machine")) {
            tile.func_145839_a(this.complementNBT(nbttagcompound, nbttagcompound.func_74775_l("Machine"), definition));
        } else {
            tile.func_145839_a(nbttagcompound);
        }
    }

    private NBTTagCompound complementNBT(NBTTagCompound parent, NBTTagCompound inner, MachineDefinition definition) {
        inner.func_74778_a("id", definition.teIdent);
        inner.func_74768_a("x", this.field_145851_c);
        inner.func_74768_a("y", this.field_145848_d);
        inner.func_74768_a("z", this.field_145849_e);
        inner.func_74768_a("Access", parent.func_74762_e("Access"));
        if (parent.func_74764_b("Owner")) {
            inner.func_74778_a("Owner", parent.func_74779_i("Owner"));
        }
        if (parent.func_74764_b("Orientation")) {
            inner.func_74768_a("Orientation", parent.func_74762_e("Orientation"));
        }
        return inner;
    }

    private void commitSeppuku(Block block, int meta) {
        Proxies.log.info("Obsolete gadget %s-%s has no replacement defined. Committing sepukku.", block.func_149739_a(), meta);
        this.field_145850_b.func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        int kind = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        nbttagcompound.func_74768_a("Kind", kind);
    }

    public void func_145829_t() {
        super.func_145829_t();
    }

    public boolean isWorking() {
        return false;
    }

    public int getChargeReceivedScaled(int i) {
        return 0;
    }

    public static EnumTankLevel rateTankLevel(int scaled) {
        if (scaled < 5) {
            return EnumTankLevel.EMPTY;
        }
        if (scaled < 30) {
            return EnumTankLevel.LOW;
        }
        if (scaled < 60) {
            return EnumTankLevel.MEDIUM;
        }
        if (scaled < 90) {
            return EnumTankLevel.HIGH;
        }
        return EnumTankLevel.MAXIMUM;
    }

    public boolean isIndirectlyPoweringTo(IBlockAccess world, int i, int j, int k, int l) {
        return false;
    }

    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return false;
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int i) {
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
    }

    public String func_145825_b() {
        return "[Unknown]";
    }

    public int func_70297_j_() {
        return 64;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return Utils.isUseableByPlayer(player, this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean func_145818_k_() {
        return super.hasCustomInventoryName();
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return super.isItemValidForSlot(slotIndex, itemstack);
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (this.getAccess() == EnumAccess.PRIVATE) {
            return 0;
        }
        return 0;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        if (this.getAccess() == EnumAccess.PRIVATE) {
            return new ItemStack[0];
        }
        return new ItemStack[0];
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = null;
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
    }

    public void onNeighborBlockChange() {
    }

    @Override
    public LinkedList<ITrigger> getCustomTriggers() {
        return null;
    }
}

