/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import buildcraft.api.power.PowerHandler;
import forestry.core.GameMode;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.IPowerHandler;
import forestry.core.interfaces.IRenderableMachine;
import forestry.core.network.ClassMap;
import forestry.core.network.IndexInPayload;
import forestry.core.network.PacketPayload;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.ForestryTank;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;

public abstract class TilePowered
extends TileBase
implements IPowerHandler,
IRenderableMachine {
    public static int WORK_CYCLES = 4;
    private final PowerHandler powerHandler = new PowerHandler(this, PowerHandler.Type.MACHINE);
    private int workCounter;

    @Override
    public PacketPayload getPacketPayload() {
        if (!ClassMap.classMappers.containsKey(this.getClass())) {
            ClassMap.classMappers.put(this.getClass(), new ClassMap(this.getClass()));
        }
        ClassMap classmap = ClassMap.classMappers.get(this.getClass());
        PacketPayload payload = new PacketPayload(classmap.intSize, classmap.floatSize, classmap.stringSize);
        try {
            classmap.setData(this, payload.intPayload, payload.floatPayload, payload.stringPayload, new IndexInPayload(0, 0, 0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
        if (payload.isEmpty()) {
            return;
        }
        if (!ClassMap.classMappers.containsKey(this.getClass())) {
            ClassMap.classMappers.put(this.getClass(), new ClassMap(this.getClass()));
        }
        ClassMap classmap = ClassMap.classMappers.get(this.getClass());
        try {
            classmap.fromData(this, payload.intPayload, payload.floatPayload, payload.stringPayload, new IndexInPayload(0, 0, 0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public TilePowered() {
        this.configurePowerProvider(this.powerHandler);
        this.adjustPowerProvider(this.powerHandler);
    }

    protected void configurePowerProvider(PowerHandler provider) {
        provider.configure(5.0, 40.0, 15.0, 500.0);
    }

    private void adjustPowerProvider(PowerHandler provider) {
        provider.configure(provider.getMinEnergyReceived(), Math.round(provider.getMaxEnergyReceived() * (double)GameMode.getGameMode().getFloatSetting("energy.demand.modifier")), Math.round(provider.getActivationEnergy() * (double)GameMode.getGameMode().getFloatSetting("energy.demand.modifier")), Math.round(provider.getMaxEnergyStored() * (double)GameMode.getGameMode().getFloatSetting("energy.demand.modifier")));
    }

    public abstract boolean isWorking();

    public boolean hasResourcesMin(float percentage) {
        return false;
    }

    public boolean hasFuelMin(float percentage) {
        return false;
    }

    public boolean hasWork() {
        return false;
    }

    @Override
    public PowerHandler getPowerHandler() {
        return this.powerHandler;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.workCounter >= WORK_CYCLES && this.field_145850_b.func_82737_E() % 5L == 0L && this.workCycle()) {
            this.workCounter = 0;
        }
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        if (!Proxies.common.isSimulating(this.field_145850_b)) {
            return;
        }
        if (this.workCounter < WORK_CYCLES) {
            this.powerHandler.useEnergy(this.powerHandler.getActivationEnergy(), this.powerHandler.getActivationEnergy(), true);
            ++this.workCounter;
        }
    }

    public abstract boolean workCycle();

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.powerHandler.writeToNBT(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.powerHandler.readFromNBT(nbt);
    }

    protected ItemStack bottleIntoContainer(ItemStack canStack, ItemStack outputStack, FluidContainerRegistry.FluidContainerData container, ForestryTank tank) {
        if (tank.getFluidAmount() < container.fluid.amount) {
            return outputStack;
        }
        if (canStack.field_77994_a <= 0) {
            return outputStack;
        }
        if (outputStack != null && !outputStack.func_77969_a(container.filledContainer)) {
            return outputStack;
        }
        if (outputStack != null && outputStack.field_77994_a >= outputStack.func_77976_d()) {
            return outputStack;
        }
        tank.drain(container.fluid.amount, true);
        --canStack.field_77994_a;
        if (outputStack == null) {
            outputStack = container.filledContainer.func_77946_l();
        } else {
            ++outputStack.field_77994_a;
        }
        return outputStack;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return EnumTankLevel.EMPTY;
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return EnumTankLevel.EMPTY;
    }
}

