/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.mojang.authlib.GameProfile;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleHandler;
import forestry.api.genetics.IAlleleRegistry;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ILegacyHandler;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.Classification;
import forestry.core.genetics.ItemResearchNote;
import forestry.core.utils.IDAllocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class AlleleRegistry
implements IAlleleRegistry,
ILegacyHandler {
    public static final int ALLELE_ARRAY_SIZE = 2048;
    private final LinkedHashMap<String, ISpeciesRoot> rootMap = new LinkedHashMap(16);
    private final LinkedHashMap<String, IAllele> alleleMap = new LinkedHashMap(2048);
    private final LinkedHashMap<String, IAllele> deprecatedAlleleMap = new LinkedHashMap(32);
    private final LinkedHashMap<String, IClassification> classificationMap = new LinkedHashMap(128);
    private final LinkedHashMap<String, IFruitFamily> fruitMap = new LinkedHashMap(64);
    private final HashMap<Integer, String> metaMapToUID = new HashMap();
    private final HashMap<String, Integer> uidMapToMeta = new HashMap();
    private final HashMap<Integer, String> legacyMap = new HashMap();
    private final HashSet<IAlleleHandler> alleleHandlers = new HashSet();
    private final ArrayList<String> blacklist = new ArrayList();

    @Override
    public void registerSpeciesRoot(ISpeciesRoot root) {
        this.rootMap.put(root.getUID(), root);
    }

    @Override
    public Map<String, ISpeciesRoot> getSpeciesRoot() {
        return Collections.unmodifiableMap(this.rootMap);
    }

    @Override
    public ISpeciesRoot getSpeciesRoot(String uid) {
        if (this.rootMap.containsKey(uid)) {
            return this.rootMap.get(uid);
        }
        return null;
    }

    @Override
    public ISpeciesRoot getSpeciesRoot(ItemStack stack) {
        for (ISpeciesRoot root : this.rootMap.values()) {
            if (!root.isMember(stack)) continue;
            return root;
        }
        return null;
    }

    @Override
    public ISpeciesRoot getSpeciesRoot(Class<? extends IIndividual> clz) {
        for (ISpeciesRoot root : this.rootMap.values()) {
            if (!root.getMemberClass().isAssignableFrom(clz)) continue;
            return root;
        }
        return null;
    }

    @Override
    public boolean isIndividual(ItemStack stack) {
        return this.getSpeciesRoot(stack) != null;
    }

    @Override
    public IIndividual getIndividual(ItemStack stack) {
        ISpeciesRoot root = this.getSpeciesRoot(stack);
        if (root == null) {
            return null;
        }
        return root.getMember(stack);
    }

    public void initialize() {
        this.createAndRegisterClassification(IClassification.EnumClassLevel.DOMAIN, "archaea", "Archaea");
        this.createAndRegisterClassification(IClassification.EnumClassLevel.DOMAIN, "bacteria", "Bacteria");
        IClassification eukarya = this.createAndRegisterClassification(IClassification.EnumClassLevel.DOMAIN, "eukarya", "Eukarya");
        eukarya.addMemberGroup(this.createAndRegisterClassification(IClassification.EnumClassLevel.KINGDOM, "animalia", "Animalia"));
        eukarya.addMemberGroup(this.createAndRegisterClassification(IClassification.EnumClassLevel.KINGDOM, "plantae", "Plantae"));
        eukarya.addMemberGroup(this.createAndRegisterClassification(IClassification.EnumClassLevel.KINGDOM, "fungi", "Fungi"));
        eukarya.addMemberGroup(this.createAndRegisterClassification(IClassification.EnumClassLevel.KINGDOM, "protista", "Protista"));
        this.getClassification("kingdom.animalia").addMemberGroup(this.createAndRegisterClassification(IClassification.EnumClassLevel.PHYLUM, "arthropoda", "Arthropoda"));
        this.getClassification("phylum.arthropoda").addMemberGroup(this.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "insecta", "Insecta"));
    }

    @Override
    public Map<String, IAllele> getRegisteredAlleles() {
        return Collections.unmodifiableMap(this.alleleMap);
    }

    @Override
    public Map<String, IAllele> getDeprecatedAlleleReplacements() {
        return Collections.unmodifiableMap(this.deprecatedAlleleMap);
    }

    @Override
    public void registerAllele(IAllele allele) {
        IClassification branch;
        this.alleleMap.put(allele.getUID(), allele);
        if (allele instanceof IAlleleSpecies && (branch = ((IAlleleSpecies)allele).getBranch()) != null) {
            branch.addMemberSpecies((IAlleleSpecies)allele);
        }
        for (IAlleleHandler handler : this.alleleHandlers) {
            handler.onRegisterAllele(allele);
        }
    }

    @Override
    public void registerDeprecatedAlleleReplacement(String deprecatedUID, IAllele replacementAllele) {
        if (this.deprecatedAlleleMap.containsKey(deprecatedUID)) {
            return;
        }
        this.deprecatedAlleleMap.put(deprecatedUID, replacementAllele);
    }

    @Override
    public IAllele getAllele(String uid) {
        IAllele allele = this.alleleMap.get(uid);
        if (allele == null) {
            allele = this.deprecatedAlleleMap.get(uid);
        }
        return allele;
    }

    @Override
    public void reloadMetaMap(World world) {
        this.metaMapToUID.clear();
        this.uidMapToMeta.clear();
        for (Map.Entry<String, IAllele> entry : this.alleleMap.entrySet()) {
            if (!(entry.getValue() instanceof IAlleleSpecies)) continue;
            int meta = IDAllocator.getIDAllocator(world, "speciesMetaMap").getId(entry.getKey());
            this.metaMapToUID.put(meta, entry.getKey());
            this.uidMapToMeta.put(entry.getKey(), meta);
        }
    }

    @Override
    public IAllele getFromMetaMap(int meta) {
        if (!this.metaMapToUID.containsKey(meta)) {
            return null;
        }
        return this.getAllele(this.metaMapToUID.get(meta));
    }

    @Override
    public int getFromUIDMap(String uid) {
        if (!this.uidMapToMeta.containsKey(uid)) {
            return 0;
        }
        return this.uidMapToMeta.get(uid);
    }

    @Override
    public void registerClassification(IClassification branch) {
        if (this.classificationMap.containsKey(branch.getUID())) {
            throw new RuntimeException(String.format("Could not add new classification '%s', because the key is already taken by %s.", branch.getUID(), this.classificationMap.get(branch.getUID())));
        }
        this.classificationMap.put(branch.getUID(), branch);
        for (IAlleleHandler handler : this.alleleHandlers) {
            handler.onRegisterClassification(branch);
        }
    }

    @Override
    public Map<String, IClassification> getRegisteredClassifications() {
        return Collections.unmodifiableMap(this.classificationMap);
    }

    @Override
    public IClassification createAndRegisterClassification(IClassification.EnumClassLevel level, String uid, String scientific) {
        return new Classification(level, uid, scientific);
    }

    @Override
    public IClassification getClassification(String uid) {
        return this.classificationMap.get(uid);
    }

    @Override
    public void registerFruitFamily(IFruitFamily family) {
        this.fruitMap.put(family.getUID(), family);
        for (IAlleleHandler handler : this.alleleHandlers) {
            handler.onRegisterFruitFamily(family);
        }
    }

    @Override
    public Map<String, IFruitFamily> getRegisteredFruitFamilies() {
        return Collections.unmodifiableMap(this.fruitMap);
    }

    @Override
    public IFruitFamily getFruitFamily(String uid) {
        return this.fruitMap.get(uid);
    }

    @Override
    public void registerLegacyMapping(int id, String uid) {
        this.legacyMap.put(id, uid);
    }

    @Override
    public IAllele getFromLegacyMap(int id) {
        if (!this.legacyMap.containsKey(id)) {
            return null;
        }
        return this.getAllele(this.legacyMap.get(id));
    }

    @Override
    public void registerAlleleHandler(IAlleleHandler handler) {
        this.alleleHandlers.add(handler);
    }

    @Override
    public void blacklistAllele(String uid) {
        this.blacklist.add(uid);
    }

    @Override
    public Collection<String> getAlleleBlacklist() {
        return Collections.unmodifiableCollection(this.blacklist);
    }

    @Override
    public boolean isBlacklisted(String uid) {
        return this.blacklist.contains(uid);
    }

    @Override
    public ItemStack getSpeciesNoteStack(GameProfile researcher, IAlleleSpecies species) {
        return ItemResearchNote.EnumNoteType.createSpeciesNoteStack(ForestryItem.researchNote.item(), researcher, species);
    }

    @Override
    public ItemStack getMutationNoteStack(GameProfile researcher, IMutation mutation) {
        return ItemResearchNote.EnumNoteType.createMutationNoteStack(ForestryItem.researchNote.item(), researcher, mutation);
    }
}

