/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IIconProvider;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.Allele;
import forestry.core.utils.StackUtils;
import forestry.core.utils.StringUtil;
import java.util.Collection;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public abstract class AlleleSpecies
extends Allele
implements IAlleleSpecies {
    private final String name;
    private final String binomial;
    private String description = null;
    private int complexity = 3;
    private boolean hasEffect = false;
    private boolean isSecret = false;
    private boolean isCounted = true;
    private IClassification branch = null;
    private EnumTemperature climate = EnumTemperature.NORMAL;
    private EnumHumidity humidity = EnumHumidity.NORMAL;

    public AlleleSpecies(String uid, boolean isDominant, String name, IClassification branch, String binomial) {
        super(uid, isDominant, true);
        this.branch = branch;
        this.name = name;
        this.binomial = binomial;
        this.description = StringUtil.localize("description." + uid);
        AlleleManager.alleleRegistry.registerAllele(this);
    }

    @Override
    public String getName() {
        return StringUtil.localize(this.name);
    }

    @Override
    public String getUnlocalizedName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getComplexity() {
        return this.complexity;
    }

    @Override
    public float getResearchSuitability(ItemStack itemstack) {
        if (itemstack == null) {
            return 0.0f;
        }
        if (ForestryItem.honeyDrop.isItemEqual(itemstack)) {
            return 0.5f;
        }
        if (ForestryItem.honeydew.isItemEqual(itemstack)) {
            return 0.7f;
        }
        if (ForestryItem.beeComb.isItemEqual(itemstack)) {
            return 0.4f;
        }
        if (AlleleManager.alleleRegistry.isIndividual(itemstack)) {
            return 1.0f;
        }
        for (Map.Entry<ItemStack, Float> entry : this.getRoot().getResearchCatalysts().entrySet()) {
            if (!StackUtils.isIdenticalItem(entry.getKey(), itemstack)) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }

    @Override
    public ItemStack[] getResearchBounty(World world, GameProfile researcher, IIndividual individual, int bountyLevel) {
        Collection<? extends IMutation> combinations;
        ItemStack research = null;
        if (world.field_73012_v.nextFloat() < 10.0f / (float)bountyLevel && (combinations = this.getRoot().getCombinations(this)).size() > 0) {
            IMutation[] candidates = combinations.toArray(new IMutation[0]);
            research = AlleleManager.alleleRegistry.getMutationNoteStack(researcher, candidates[world.field_73012_v.nextInt(candidates.length)]);
        }
        if (research != null) {
            return new ItemStack[]{research};
        }
        return StackUtils.EMPTY_STACK_ARRAY;
    }

    @Override
    public EnumTemperature getTemperature() {
        return this.climate;
    }

    @Override
    public EnumHumidity getHumidity() {
        return this.humidity;
    }

    @Override
    public boolean hasEffect() {
        return this.hasEffect;
    }

    @Override
    public boolean isSecret() {
        return this.isSecret;
    }

    @Override
    public boolean isCounted() {
        return this.isCounted;
    }

    @Override
    public String getBinomial() {
        return this.binomial;
    }

    @Override
    public String getAuthority() {
        return "Sengir";
    }

    @Override
    public IClassification getBranch() {
        return this.branch;
    }

    public AlleleSpecies setComplexity(int complexity) {
        this.complexity = complexity;
        return this;
    }

    public AlleleSpecies setTemperature(EnumTemperature temperature) {
        this.climate = temperature;
        return this;
    }

    public AlleleSpecies setHumidity(EnumHumidity humidity) {
        this.humidity = humidity;
        return this;
    }

    public AlleleSpecies setHasEffect() {
        this.hasEffect = true;
        return this;
    }

    public AlleleSpecies setIsSecret() {
        this.isSecret = true;
        return this;
    }

    public AlleleSpecies setIsNotCounted() {
        this.isCounted = false;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public abstract IIconProvider getIconProvider();
}

