/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IMutation;
import java.util.ArrayList;
import java.util.Collection;

public abstract class Mutation
implements IMutation {
    protected int chance;
    boolean isSecret = false;
    protected IAllele allele0;
    protected IAllele allele1;
    IAllele[] template;
    protected float minTemperature = 0.0f;
    protected float maxTemperature = 2.0f;
    protected float minRainfall = 0.0f;
    protected float maxRainfall = 2.0f;
    protected ArrayList<String> specialConditions = new ArrayList();

    public Mutation(IAllele allele0, IAllele allele1, IAllele[] template, int chance) {
        this.allele0 = allele0;
        this.allele1 = allele1;
        this.template = template;
        this.chance = chance;
    }

    public Mutation setSpecialConditions(Collection<String> conditions) {
        this.specialConditions.addAll(conditions);
        return this;
    }

    @Override
    public Collection<String> getSpecialConditions() {
        return this.specialConditions;
    }

    public Mutation setIsSecret() {
        this.isSecret = true;
        return this;
    }

    public Mutation setTemperature(float minTemperature, float maxTemperature) {
        EnumTemperature temp2;
        this.minTemperature = minTemperature;
        this.maxTemperature = maxTemperature;
        EnumTemperature temp1 = EnumTemperature.getFromValue(minTemperature);
        if (temp1 != (temp2 = EnumTemperature.getFromValue(maxTemperature))) {
            this.specialConditions.add(String.format("Temperature between %s and %s.", new Object[]{temp1, temp2}));
        } else {
            this.specialConditions.add(String.format("Temperature %s required.", new Object[]{temp1}));
        }
        return this;
    }

    public Mutation setRainfall(float minRainfall, float maxRainfall) {
        EnumHumidity temp2;
        this.minRainfall = minRainfall;
        this.maxRainfall = maxRainfall;
        EnumHumidity temp1 = EnumHumidity.getFromValue(minRainfall);
        if (temp1 != (temp2 = EnumHumidity.getFromValue(maxRainfall))) {
            this.specialConditions.add(String.format("Humidity between %s and %s.", new Object[]{temp1, temp2}));
        } else {
            this.specialConditions.add(String.format("Humidity %s required.", new Object[]{temp1}));
        }
        return this;
    }

    public Mutation setTemperatureRainfall(float minTemperature, float maxTemperature, float minRainfall, float maxRainfall) {
        this.setTemperature(minTemperature, maxTemperature);
        this.setRainfall(minRainfall, maxRainfall);
        return this;
    }

    @Override
    public IAllele getAllele0() {
        return this.allele0;
    }

    @Override
    public IAllele getAllele1() {
        return this.allele1;
    }

    @Override
    public float getBaseChance() {
        return this.chance;
    }

    @Override
    public IAllele[] getTemplate() {
        return this.template;
    }

    @Override
    public boolean isPartner(IAllele allele) {
        return this.allele0.getUID().equals(allele.getUID()) || this.allele1.getUID().equals(allele.getUID());
    }

    @Override
    public IAllele getPartner(IAllele allele) {
        if (this.allele0.getUID().equals(allele.getUID())) {
            return this.allele1;
        }
        return this.allele0;
    }

    @Override
    public boolean isSecret() {
        return this.isSecret;
    }
}

