/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.config.Config;
import forestry.core.gadgets.TileForestry;
import forestry.core.gui.ClimateLedger;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.ErrorLedger;
import forestry.core.gui.HintLedger;
import forestry.core.gui.LedgerManager;
import forestry.core.gui.OwnerLedger;
import forestry.core.gui.PowerLedger;
import forestry.core.gui.WidgetManager;
import forestry.core.gui.slots.SlotForestry;
import forestry.core.gui.tooltips.IToolTipProvider;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.tooltips.ToolTipLine;
import forestry.core.interfaces.IClimatised;
import forestry.core.interfaces.IErrorSource;
import forestry.core.interfaces.IHintSource;
import forestry.core.interfaces.IOwnable;
import forestry.core.interfaces.IPowerHandler;
import forestry.core.proxy.Proxies;
import forestry.core.utils.FontColour;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class GuiForestry<T extends TileForestry>
extends GuiContainer {
    protected WidgetManager widgetManager;
    protected LedgerManager ledgerManager = new LedgerManager(this);
    protected T tile;
    public ResourceLocation textureFile;
    protected FontColour fontColor;
    protected int column0;
    protected int column1;
    protected int column2;
    private int line;
    protected float factor = 0.75f;

    public GuiForestry(ContainerForestry container) {
        this("", container);
    }

    public GuiForestry(String texture, ContainerForestry container) {
        this(new ResourceLocation("forestry", texture), container, null);
    }

    public GuiForestry(String texture, ContainerForestry container, Object inventory) {
        this(new ResourceLocation("forestry", texture), container, inventory);
    }

    public GuiForestry(ResourceLocation texture, ContainerForestry container) {
        this(texture, container, null);
    }

    public GuiForestry(ResourceLocation texture, ContainerForestry container, Object inventory) {
        super((Container)container);
        this.widgetManager = new WidgetManager(this);
        this.ledgerManager = new LedgerManager(this);
        this.textureFile = texture;
        this.field_147002_h = container;
        if (inventory instanceof TileForestry) {
            this.tile = (TileForestry)inventory;
        }
        this.fontColor = new FontColour(Proxies.common.getSelectedTexturePack(Proxies.common.getClientInstance()));
        this.initLedgers(inventory);
    }

    protected void initLedgers(Object inventory) {
        if (inventory instanceof IErrorSource && ((IErrorSource)inventory).throwsErrors()) {
            this.ledgerManager.add(new ErrorLedger(this.ledgerManager, (IErrorSource)inventory));
        }
        if (inventory instanceof IClimatised && ((IClimatised)inventory).isClimatized()) {
            this.ledgerManager.add(new ClimateLedger(this.ledgerManager, (IClimatised)inventory));
        }
        if (!Config.disableEnergyStat && inventory instanceof IPowerHandler) {
            this.ledgerManager.add(new PowerLedger(this.ledgerManager, (IPowerHandler)inventory));
        }
        if (!Config.disableHints && inventory instanceof IHintSource && ((IHintSource)inventory).hasHints()) {
            this.ledgerManager.add(new HintLedger(this.ledgerManager, (IHintSource)inventory));
        }
        if (inventory instanceof IOwnable && ((IOwnable)inventory).isOwnable()) {
            this.ledgerManager.add(new OwnerLedger(this.ledgerManager, (IOwnable)inventory));
        }
    }

    protected final void setFactor(float factor) {
        this.factor = factor;
    }

    protected final void startPage() {
        this.line = 12;
        GL11.glPushMatrix();
        GL11.glScalef((float)this.factor, (float)this.factor, (float)this.factor);
    }

    protected final void startPage(int column0, int column1, int column2) {
        this.column0 = column0;
        this.column1 = column1;
        this.column2 = column2;
        this.startPage();
    }

    protected final int adjustToFactor(int fixed) {
        return (int)((float)fixed * (1.0f / this.factor));
    }

    protected final int getLineY() {
        return this.line;
    }

    protected final void newLine() {
        this.line = (int)((float)this.line + 12.0f * this.factor);
    }

    protected final void newLine(int lineHeight) {
        this.line = (int)((float)this.line + (float)lineHeight * this.factor);
    }

    protected final void endPage() {
        GL11.glPopMatrix();
    }

    protected final void drawRow(String text0, String text1, String text2, int colour0, int colour1, int colour2) {
        this.drawLine(text0, this.column0, colour0);
        this.drawLine(text1, this.column1, colour1);
        this.drawLine(text2, this.column2, colour2);
        this.newLine();
    }

    protected final void drawLine(String text, int x) {
        this.drawLine(text, x, this.fontColor.get("gui.screen"));
    }

    protected final void drawSplitLine(String text, int x, int maxWidth) {
        this.drawSplitLine(text, x, maxWidth, this.fontColor.get("gui.screen"));
    }

    protected final void drawCenteredLine(String text, int x, int width) {
        this.drawCenteredLine(text, x, width, this.fontColor.get("gui.screen"));
    }

    protected final void drawCenteredLine(String text, int x, int width, int color) {
        this.field_146289_q.func_78276_b(text, (int)((float)(this.field_147003_i + x) * (1.0f / this.factor)) + (this.adjustToFactor(width) - this.field_146289_q.func_78256_a(text)) / 2, (int)((float)(this.field_147009_r + this.line) * (1.0f / this.factor)), color);
    }

    protected final void drawLine(String text, int x, int color) {
        this.field_146289_q.func_78276_b(text, (int)((float)(this.field_147003_i + x) * (1.0f / this.factor)), (int)((float)(this.field_147009_r + this.line) * (1.0f / this.factor)), color);
    }

    protected final void drawSplitLine(String text, int x, int maxWidth, int color) {
        this.field_146289_q.func_78279_b(text, (int)((float)(this.field_147003_i + x) * (1.0f / this.factor)), (int)((float)(this.field_147009_r + this.line) * (1.0f / this.factor)), (int)((float)maxWidth * (1.0f / this.factor)), color);
    }

    public void spinTextureIcon(int par1, int par2, IIcon par3Icon, int par4, int par5, int rotation) {
        float x = (par1 += this.field_146294_l / 2 - this.field_146999_f / 2) + par4 / 2;
        float y = (par2 += this.field_146295_m / 2 - this.field_147000_g / 2) + par5 / 2;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glRotatef((float)rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + par5), (double)this.field_73735_i, (double)par3Icon.func_94209_e(), (double)par3Icon.func_94210_h());
        tessellator.func_78374_a((double)(par1 + par4), (double)(par2 + par5), (double)this.field_73735_i, (double)par3Icon.func_94212_f(), (double)par3Icon.func_94210_h());
        tessellator.func_78374_a((double)(par1 + par4), (double)(par2 + 0), (double)this.field_73735_i, (double)par3Icon.func_94212_f(), (double)par3Icon.func_94206_g());
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + 0), (double)this.field_73735_i, (double)par3Icon.func_94209_e(), (double)par3Icon.func_94206_g());
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.field_146999_f);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.field_146289_q.func_78256_a(string)) / 2;
    }

    protected void func_73864_a(int xPos, int yPos, int mouseButton) {
        super.func_73864_a(xPos, yPos, mouseButton);
        this.ledgerManager.handleMouseClicked(xPos, yPos, mouseButton);
        this.widgetManager.handleMouseClicked(xPos, yPos, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int eventType) {
        super.func_146286_b(mouseX, mouseY, eventType);
        this.widgetManager.handleMouseRelease(mouseX, mouseY, eventType);
    }

    protected void func_146273_a(int mouseX, int mouseY, int mouseButton, long time) {
        this.widgetManager.handleMouseMove(mouseX, mouseY, mouseButton, time);
        Slot slot = this.func_146975_c(mouseX, mouseY);
        if (mouseButton == 1 && slot instanceof SlotForestry && ((SlotForestry)slot).isPhantom()) {
            return;
        }
        super.func_146273_a(mouseX, mouseY, mouseButton, time);
    }

    public Slot func_146975_c(int par1, int par2) {
        for (int k = 0; k < this.field_147002_h.field_75151_b.size(); ++k) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(k);
            if (!this.func_146981_a(slot, par1, par2)) continue;
            return slot;
        }
        return null;
    }

    public boolean func_146981_a(Slot par1Slot, int par2, int par3) {
        return this.func_146978_c(par1Slot.field_75223_e, par1Slot.field_75221_f, 16, 16, par2, par3);
    }

    protected void drawTooltip(int mouseX, int mouseY, float zLevel, List information, EnumRarity rarity) {
        if (information.size() > 0) {
            this.field_73735_i = 0.0f;
            GuiForestry.field_146296_j.field_77023_b = 0.0f;
            int tooltipWidth = 0;
            for (int i = 0; i < information.size(); ++i) {
                int textWidth = this.field_146289_q.func_78256_a((String)information.get(i));
                if (textWidth <= tooltipWidth) continue;
                tooltipWidth = textWidth;
            }
            int xPos = mouseX - this.field_147003_i + 12;
            int yPos = mouseY - this.field_147009_r - 12;
            int var14 = 8;
            if (information.size() > 1) {
                var14 += 2 + (information.size() - 1) * 10;
            }
            this.field_73735_i = zLevel;
            GuiForestry.field_146296_j.field_77023_b = zLevel;
            int var15 = -267386864;
            this.func_73733_a(xPos - 3, yPos - 4, xPos + tooltipWidth + 3, yPos - 3, var15, var15);
            this.func_73733_a(xPos - 3, yPos + var14 + 3, xPos + tooltipWidth + 3, yPos + var14 + 4, var15, var15);
            this.func_73733_a(xPos - 3, yPos - 3, xPos + tooltipWidth + 3, yPos + var14 + 3, var15, var15);
            this.func_73733_a(xPos - 4, yPos - 3, xPos - 3, yPos + var14 + 3, var15, var15);
            this.func_73733_a(xPos + tooltipWidth + 3, yPos - 3, xPos + tooltipWidth + 4, yPos + var14 + 3, var15, var15);
            int var16 = 0x505000FF;
            int var17 = (var16 & 0xFEFEFE) >> 1 | var16 & 0xFF000000;
            this.func_73733_a(xPos - 3, yPos - 3 + 1, xPos - 3 + 1, yPos + var14 + 3 - 1, var16, var17);
            this.func_73733_a(xPos + tooltipWidth + 2, yPos - 3 + 1, xPos + tooltipWidth + 3, yPos + var14 + 3 - 1, var16, var17);
            this.func_73733_a(xPos - 3, yPos - 3, xPos + tooltipWidth + 3, yPos - 3 + 1, var16, var16);
            this.func_73733_a(xPos - 3, yPos + var14 + 2, xPos + tooltipWidth + 3, yPos + var14 + 3, var17, var17);
            for (int i = 0; i < information.size(); ++i) {
                String line = (String)information.get(i);
                line = i == 0 ? "\u00a7" + rarity.field_77937_e.func_96298_a() + line : "\u00a77" + line;
                this.field_146289_q.func_78261_a(line, xPos, yPos, -1);
                if (i == 0) {
                    yPos += 2;
                }
                yPos += 10;
            }
            this.field_73735_i = 0.0f;
            GuiForestry.field_146296_j.field_77023_b = 0.0f;
        }
    }

    public void drawToolTips(ToolTip toolTips, int mouseX, int mouseY) {
        int y;
        if (toolTips == null) {
            return;
        }
        if (toolTips.isEmpty()) {
            return;
        }
        int left = this.field_147003_i;
        int top = this.field_147009_r;
        int lenght = 0;
        Iterator i$ = toolTips.iterator();
        while (i$.hasNext()) {
            ToolTipLine tip = (ToolTipLine)i$.next();
            y = this.field_146289_q.func_78256_a(tip.text);
            if (y <= lenght) continue;
            lenght = y;
        }
        int x = mouseX - left + 12;
        y = mouseY - top - 12;
        int var14 = 8;
        if (toolTips.size() > 1) {
            var14 += 2 + (toolTips.size() - 1) * 10;
        }
        this.field_73735_i = 300.0f;
        GuiForestry.field_146296_j.field_77023_b = 300.0f;
        int var15 = -267386864;
        this.func_73733_a(x - 3, y - 4, x + lenght + 3, y - 3, var15, var15);
        this.func_73733_a(x - 3, y + var14 + 3, x + lenght + 3, y + var14 + 4, var15, var15);
        this.func_73733_a(x - 3, y - 3, x + lenght + 3, y + var14 + 3, var15, var15);
        this.func_73733_a(x - 4, y - 3, x - 3, y + var14 + 3, var15, var15);
        this.func_73733_a(x + lenght + 3, y - 3, x + lenght + 4, y + var14 + 3, var15, var15);
        int var16 = 0x505000FF;
        int var17 = (var16 & 0xFEFEFE) >> 1 | var16 & 0xFF000000;
        this.func_73733_a(x - 3, y - 3 + 1, x - 3 + 1, y + var14 + 3 - 1, var16, var17);
        this.func_73733_a(x + lenght + 2, y - 3 + 1, x + lenght + 3, y + var14 + 3 - 1, var16, var17);
        this.func_73733_a(x - 3, y - 3, x + lenght + 3, y - 3 + 1, var16, var16);
        this.func_73733_a(x - 3, y + var14 + 2, x + lenght + 3, y + var14 + 3, var17, var17);
        Iterator i$2 = toolTips.iterator();
        while (i$2.hasNext()) {
            ToolTipLine tip = (ToolTipLine)i$2.next();
            String line = tip.text;
            line = tip.color == null ? "\u00a77" + line : "\u00a7" + tip.color.func_96298_a() + line;
            this.field_146289_q.func_78261_a(line, x, y, -1);
            y += 10 + tip.getSpacing();
        }
        this.field_73735_i = 0.0f;
        GuiForestry.field_146296_j.field_77023_b = 0.0f;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GL11.glPushAttrib((int)8192);
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.ledgerManager.drawTooltips(mouseX, mouseY);
        InventoryPlayer playerInv = this.field_146297_k.field_71439_g.field_71071_by;
        if (playerInv.func_70445_o() == null) {
            this.drawToolTips(this.widgetManager.widgets, mouseX, mouseY);
            this.drawToolTips(this.field_146292_n, mouseX, mouseY);
            this.drawToolTips(this.field_147002_h.field_75151_b, mouseX, mouseY);
        }
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void drawToolTips(Collection<?> objects, int mouseX, int mouseY) {
        for (Object obj : objects) {
            ToolTip tips;
            IToolTipProvider provider;
            if (!(obj instanceof IToolTipProvider) || !(provider = (IToolTipProvider)obj).isToolTipVisible() || (tips = provider.getToolTip()) == null) continue;
            boolean mouseOver = provider.isMouseOver(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            tips.onTick(mouseOver);
            if (!mouseOver || !tips.isReady()) continue;
            tips.refresh();
            this.drawToolTips(tips, mouseX, mouseY);
        }
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.textureFile);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        int left = this.field_147003_i;
        int top = this.field_147009_r;
        GL11.glPushAttrib((int)8192);
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)left, (float)top, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.ledgerManager.drawLedgers();
        this.widgetManager.drawWidgets();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        this.bindTexture(this.textureFile);
    }

    protected void bindTexture(ResourceLocation texturePath) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Proxies.common.bindTexture(texturePath);
    }

    public void setZLevel(float level) {
        this.field_73735_i = level;
    }

    public static RenderItem getItemRenderer() {
        return field_146296_j;
    }

    public int getSizeX() {
        return this.field_146999_f;
    }

    public int getSizeY() {
        return this.field_147000_g;
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public void func_73733_a(int par1, int par2, int par3, int par4, int par5, int par6) {
        super.func_73733_a(par1, par2, par3, par4, par5, par6);
    }

    public void drawItemStack(ItemStack stack, int xPos, int yPos) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 100.0f;
        GuiForestry.field_146296_j.field_77023_b = 100.0f;
        FontRenderer font = null;
        if (stack != null) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = this.field_146289_q;
        }
        field_146296_j.func_82406_b(font, this.field_146297_k.func_110434_K(), stack, xPos, yPos);
        field_146296_j.func_77021_b(font, this.field_146297_k.func_110434_K(), stack, xPos, yPos);
        this.field_73735_i = 0.0f;
        GuiForestry.field_146296_j.field_77023_b = 0.0f;
    }
}

