/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gui.Ledger;
import forestry.core.gui.LedgerManager;
import forestry.core.interfaces.IOwnable;
import forestry.core.network.PacketCoordinates;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.EnumAccess;
import forestry.core.utils.StringUtil;
import java.util.Locale;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;

public class OwnerLedger
extends Ledger {
    IOwnable tile;

    public OwnerLedger(LedgerManager manager, IOwnable tile) {
        super(manager);
        this.tile = tile;
    }

    public boolean isAccessButton(int mouseX, int mouseY) {
        int shiftX = this.currentShiftX;
        int shiftY = this.currentShiftY + 44;
        return mouseX >= shiftX && mouseX <= this.currentShiftX + this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + 12;
    }

    public boolean isOwnerChangeButton(int mouseX, int mouseY) {
        return false;
    }

    @Override
    public void draw(int x, int y) {
        boolean playerIsOwner = this.tile.isOwner((EntityPlayer)this.manager.minecraft.field_71439_g);
        EnumAccess access = this.tile.getAccess();
        this.maxHeight = playerIsOwner ? 60 : 36;
        this.drawBackground(x, y);
        IIcon accessIcon = TextureManager.getInstance().getDefault("misc/access." + access.toString().toLowerCase(Locale.ENGLISH));
        this.drawIcon(accessIcon, x + 3, y + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        this.manager.minecraft.field_71466_p.func_78261_a(StringUtil.localize("gui.owner"), x + 22, y + 8, this.manager.gui.fontColor.get("ledger.owner.header"));
        String ownerName = StringUtil.localize("gui.derelict");
        if (this.tile.getOwnerProfile() != null) {
            ownerName = this.tile.getOwnerProfile().getName();
        }
        this.manager.minecraft.field_71466_p.func_78276_b(ownerName, x + 22, y + 20, this.manager.gui.fontColor.get("ledger.owner.text"));
        if (!playerIsOwner) {
            return;
        }
        this.manager.minecraft.field_71466_p.func_78261_a(StringUtil.localize("gui.access") + ":", x + 22, y + 32, this.manager.gui.fontColor.get("ledger.owner.subheader"));
        this.drawIcon(accessIcon, x + 20, y + 40);
        this.manager.minecraft.field_71466_p.func_78276_b(StringUtil.localize(access.getName()), x + 38, y + 44, this.manager.gui.fontColor.get("ledger.owner.text"));
    }

    @Override
    public String getTooltip() {
        if (this.tile.getOwnerProfile() != null) {
            return StringUtil.localize("gui.owner") + ": " + this.tile.getOwnerProfile().getName();
        }
        return StringUtil.localize("gui.derelict");
    }

    @Override
    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        if (this.isAccessButton(x, y)) {
            if (!Proxies.common.isSimulating(((TileEntity)this.tile).func_145831_w())) {
                TileEntity te = (TileEntity)this.tile;
                Proxies.net.sendToServer(new PacketCoordinates(50, te.field_145851_c, te.field_145848_d, te.field_145849_e));
            }
            this.tile.switchAccessRule((EntityPlayer)this.manager.minecraft.field_71439_g);
            return true;
        }
        return false;
    }
}

