/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.slots;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.gui.slots.SlotForestry;
import forestry.core.interfaces.ICrafter;
import forestry.core.render.TextureManager;
import forestry.core.utils.StackUtils;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class SlotCustom
extends SlotForestry {
    protected Object[] items;
    private boolean exclusion;
    private ICrafter crafter;
    private String blockedTexture = "slots/blocked";

    public SlotCustom(IInventory iinventory, int slotIndex, int xPos, int yPos, boolean exclusion) {
        super(iinventory, slotIndex, xPos, yPos);
        this.items = new Object[0];
        this.exclusion = exclusion;
    }

    public SlotCustom(IInventory iinventory, Collection<?> items, int slotIndex, int xPos, int yPos) {
        this(iinventory, slotIndex, xPos, yPos, items.toArray());
    }

    public SlotCustom(IInventory iinventory, int slotIndex, int xPos, int yPos, boolean exclusion, Object ... items) {
        this(iinventory, slotIndex, xPos, yPos, items);
        this.exclusion = exclusion;
    }

    public SlotCustom(IInventory iinventory, int slotIndex, int xPos, int yPos, Object ... items) {
        super(iinventory, slotIndex, xPos, yPos);
        this.items = items;
    }

    public SlotCustom setCrafter(ICrafter crafter) {
        this.crafter = crafter;
        return this;
    }

    public boolean func_75214_a(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (!this.field_75224_c.func_94041_b(this.getSlotIndex(), itemstack)) {
            return false;
        }
        if (this.exclusion) {
            return !this.determineValidity(itemstack);
        }
        return this.determineValidity(itemstack);
    }

    public boolean func_75216_d() {
        if (this.crafter != null && !this.crafter.canTakeStack(this.getSlotIndex())) {
            return false;
        }
        return super.func_75216_d();
    }

    @Override
    public ItemStack func_75209_a(int i) {
        if (this.crafter != null && !this.crafter.canTakeStack(this.getSlotIndex())) {
            return null;
        }
        return super.func_75209_a(i);
    }

    public void func_82870_a(EntityPlayer player, ItemStack itemStack) {
        if (this.crafter != null) {
            this.crafter.takenFromSlot(this.getSlotIndex(), true, player);
        }
    }

    private boolean determineValidity(ItemStack itemstack) {
        for (Object filter : this.items) {
            if (filter == null) continue;
            if (filter instanceof Class) {
                Block block = StackUtils.getBlock(itemstack);
                if (block != null && ((Class)filter).isAssignableFrom(block.getClass())) {
                    return true;
                }
                if (!((Class)filter).isAssignableFrom(itemstack.func_77973_b().getClass())) continue;
                return true;
            }
            if (filter instanceof ItemStack) {
                if (((ItemStack)filter).func_77960_j() == Short.MAX_VALUE && itemstack.func_77973_b() == ((ItemStack)filter).func_77973_b()) {
                    return true;
                }
                if (!itemstack.func_77969_a((ItemStack)filter)) continue;
                return true;
            }
            if (filter instanceof Block) {
                if (!StackUtils.equals((Block)filter, itemstack)) continue;
                return true;
            }
            if (filter instanceof Item) {
                if (itemstack.func_77973_b() != (Item)filter) continue;
                return true;
            }
            if (filter instanceof ForestryItem) {
                if (!((ForestryItem)((Object)filter)).isItemEqual(itemstack)) continue;
                return true;
            }
            if (filter instanceof ForestryBlock) {
                if (!((ForestryBlock)((Object)filter)).isItemEqual(itemstack)) continue;
                return true;
            }
            if (filter instanceof ISpeciesRoot) {
                if (!((ISpeciesRoot)filter).isMember(itemstack)) continue;
                return true;
            }
            throw new RuntimeException("invalid filter item specified: " + filter + " (" + filter.getClass() + ")");
        }
        return false;
    }

    public SlotCustom setBlockedTexture(String ident) {
        this.blockedTexture = ident;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_75212_b() {
        if (!this.field_75224_c.func_94041_b(this.getSlotIndex(), null)) {
            return TextureManager.getInstance().getDefault(this.blockedTexture);
        }
        return null;
    }
}

