/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import forestry.api.core.IToolPipette;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.ContainerLiquidTanks;
import forestry.core.gui.WidgetManager;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.proxy.Proxies;
import forestry.core.render.SpriteSheet;
import forestry.core.utils.ForestryTank;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class TankWidget
extends Widget {
    protected int overlayTexX = 176;
    protected int overlayTexY = 0;
    protected int slot = 0;

    public TankWidget(WidgetManager manager, int xPos, int yPos, int slot) {
        super(manager, xPos, yPos);
        this.slot = slot;
        this.height = 58;
    }

    public TankWidget setOverlayOrigin(int x, int y) {
        this.overlayTexX = x;
        this.overlayTexY = y;
        return this;
    }

    public ForestryTank getTank() {
        return ((ContainerForestry)this.manager.gui.field_147002_h).getTank(this.slot);
    }

    @Override
    public void draw(int startX, int startY) {
        int x;
        if (this.getTank() == null) {
            return;
        }
        FluidStack contents = this.getTank().getFluid();
        if (contents == null || contents.amount <= 0) {
            return;
        }
        IIcon liquidIcon = contents.getFluid().getIcon(contents);
        if (liquidIcon == null) {
            return;
        }
        int squaled = contents.amount * this.height / this.getTank().getCapacity();
        Proxies.common.bindTexture(SpriteSheet.BLOCKS);
        int start = 0;
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        do {
            x = 0;
            if (squaled > 16) {
                x = 16;
                squaled -= 16;
            } else {
                x = squaled;
                squaled = 0;
            }
            this.manager.gui.func_94065_a(startX + this.xPos, startY + this.yPos + this.height - x - start, liquidIcon, 16, 16 - (16 - x));
            start += 16;
        } while (x != 0 && squaled != 0);
        Proxies.common.bindTexture(this.manager.gui.textureFile);
        this.manager.gui.func_73729_b(startX + this.xPos, startY + this.yPos, this.overlayTexX, this.overlayTexY, 16, 60);
        GL11.glPopAttrib();
    }

    @Override
    public ToolTip getToolTip() {
        ForestryTank tank = this.getTank();
        if (tank == null) {
            return null;
        }
        return tank.getToolTip();
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        ItemStack itemstack = this.manager.minecraft.field_71439_g.field_71071_by.func_70445_o();
        if (itemstack == null) {
            return;
        }
        Item held = itemstack.func_77973_b();
        if (held instanceof IToolPipette && this.manager.gui.field_147002_h instanceof ContainerLiquidTanks) {
            ((ContainerLiquidTanks)this.manager.gui.field_147002_h).handlePipetteClick(this.slot, (EntityPlayer)this.manager.minecraft.field_71439_g);
        }
    }
}

