/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import forestry.core.gui.WidgetManager;
import forestry.core.gui.tooltips.IToolTipProvider;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.proxy.Proxies;
import net.minecraft.entity.player.EntityPlayer;

public abstract class Widget
implements IToolTipProvider {
    protected WidgetManager manager;
    protected int xPos;
    protected int yPos;
    protected int width = 16;
    protected int height = 16;

    public Widget(WidgetManager manager, int xPos, int yPos) {
        this.manager = manager;
        this.xPos = xPos;
        this.yPos = yPos;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public abstract void draw(int var1, int var2);

    @Override
    public ToolTip getToolTip() {
        String line = this.getLegacyTooltip((EntityPlayer)Proxies.common.getClientInstance().field_71439_g);
        if (line != null && !line.isEmpty()) {
            ToolTip tip = new ToolTip();
            tip.add(line);
            return tip;
        }
        return null;
    }

    protected String getLegacyTooltip(EntityPlayer player) {
        return null;
    }

    @Override
    public boolean isToolTipVisible() {
        return true;
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.xPos && mouseX <= this.xPos + this.width && mouseY >= this.yPos && mouseY <= this.yPos + this.height;
    }

    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
    }

    public void handleMouseRelease(int mouseX, int mouseY, int eventType) {
    }

    public void handleMouseMove(int mouseX, int mouseY, int mouseButton, long time) {
    }
}

