/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.CreativeTabForestry;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.LiquidHelper;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class ItemLiquidContainer
extends Item {
    private boolean isDrink = false;
    private boolean isAlwaysEdible = false;
    private int healAmount = 0;
    private float saturationModifier = 0.0f;
    private final EnumContainerType type;
    private final int colour;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemLiquidContainer(EnumContainerType type, int colour) {
        this.type = type;
        this.colour = colour;
        this.func_77637_a(CreativeTabForestry.tabForestry);
        this.func_77625_d(16);
    }

    private int getMatchingSlot(EntityPlayer player, ItemStack stack) {
        for (int slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
            int space;
            ItemStack slotStack = player.field_71071_by.func_70301_a(slot);
            if (slotStack == null) {
                return slot;
            }
            if (!slotStack.func_77969_a(stack) || (space = slotStack.func_77976_d() - slotStack.field_77994_a) < stack.field_77994_a) continue;
            return slot;
        }
        return -1;
    }

    public ItemStack func_77654_b(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!this.isDrink) {
            return itemstack;
        }
        --itemstack.field_77994_a;
        entityplayer.func_71024_bL().func_75122_a(this.getHealAmount(), this.getSaturationModifier());
        world.func_72956_a((Entity)entityplayer, "random.burp", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        return itemstack;
    }

    public int func_77626_a(ItemStack itemstack) {
        if (this.isDrink) {
            return 32;
        }
        return super.func_77626_a(itemstack);
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        if (this.isDrink) {
            return EnumAction.drink;
        }
        return EnumAction.none;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!Proxies.common.isSimulating(world)) {
            return itemstack;
        }
        if (this.isDrink) {
            if (entityplayer.func_71043_e(this.isAlwaysEdible)) {
                entityplayer.func_71008_a(itemstack, this.func_77626_a(itemstack));
            }
            return itemstack;
        }
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, entityplayer, true);
        if (movingobjectposition != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int i = movingobjectposition.field_72311_b;
            int j = movingobjectposition.field_72312_c;
            int k = movingobjectposition.field_72309_d;
            Block targetedBlock = world.func_147439_a(i, j, k);
            if (!(targetedBlock instanceof IFluidBlock)) {
                return itemstack;
            }
            IFluidBlock fluidBlock = (IFluidBlock)targetedBlock;
            FluidStack drainable = fluidBlock.drain(world, i, j, k, false);
            if (drainable == null || drainable.amount <= 0) {
                return itemstack;
            }
            FluidContainerRegistry.FluidContainerData container = LiquidHelper.getEmptyContainer(itemstack, drainable);
            if (container == null) {
                return itemstack;
            }
            int slot = this.getMatchingSlot(entityplayer, container.filledContainer);
            if (slot < 0) {
                return itemstack;
            }
            if (entityplayer.field_71071_by.func_70301_a(slot) == null) {
                entityplayer.field_71071_by.func_70299_a(slot, container.filledContainer.func_77946_l());
            } else {
                ++entityplayer.field_71071_by.func_70301_a((int)slot).field_77994_a;
            }
            world.func_147468_f(i, j, k);
            --itemstack.field_77994_a;
            Proxies.net.inventoryChangeNotify(entityplayer);
            return itemstack;
        }
        return itemstack;
    }

    public int getHealAmount() {
        return this.healAmount;
    }

    public float getSaturationModifier() {
        return this.saturationModifier;
    }

    public ItemLiquidContainer setDrink(int healAmount, float saturationModifier) {
        this.isDrink = true;
        this.healAmount = healAmount;
        this.saturationModifier = saturationModifier;
        return this;
    }

    public ItemLiquidContainer setAlwaysEdible() {
        this.isAlwaysEdible = true;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.icons = new IIcon[2];
        this.icons[0] = TextureManager.getInstance().registerTex(register, "liquids/" + this.type.toString().toLowerCase(Locale.ENGLISH) + ".bottle");
        this.icons[1] = TextureManager.getInstance().registerTex(register, "liquids/" + this.type.toString().toLowerCase(Locale.ENGLISH) + ".contents");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int i, int j) {
        if (j > 0 && this.colour >= 0) {
            return this.icons[1];
        }
        return this.icons[0];
    }

    public boolean func_77623_v() {
        return true;
    }

    public int func_82790_a(ItemStack itemstack, int j) {
        if (j > 0 && this.colour >= 0) {
            return this.colour;
        }
        return 0xFFFFFF;
    }

    public static enum EnumContainerType {
        GLASS,
        JAR,
        CAN,
        CAPSULE,
        REFRACTORY;

    }
}

