/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import com.mojang.authlib.GameProfile;
import forestry.core.network.EntityNetData;
import forestry.core.network.IndexInPayload;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.UUID;

public class ClassMap {
    public static HashMap<Class, ClassMap> classMappers = new HashMap();
    private final LinkedList<Field> intMember = new LinkedList();
    private final LinkedList<Field> floatMember = new LinkedList();
    private final LinkedList<Field> booleanMember = new LinkedList();
    private final LinkedList<Field> stringMember = new LinkedList();
    private final LinkedList<Field> enumMember = new LinkedList();
    private final LinkedList<Field> gameProfileMember = new LinkedList();
    private final LinkedList<ClassMap> objectMember = new LinkedList();
    public int intSize;
    public int floatSize;
    public int stringSize;
    private Field field;

    public void setData(Object obj, int[] intPayload, float[] floatPayload, String[] stringPayload, IndexInPayload index) throws IllegalAccessException {
        for (Field member : this.intMember) {
            intPayload[index.intIndex] = member.getInt(obj);
            ++index.intIndex;
        }
        for (Field member : this.floatMember) {
            floatPayload[index.floatIndex] = member.getFloat(obj);
            ++index.floatIndex;
        }
        for (Field member : this.booleanMember) {
            floatPayload[index.intIndex] = member.getBoolean(obj) ? 1.0f : 0.0f;
            ++index.intIndex;
        }
        for (Field member : this.stringMember) {
            stringPayload[index.stringIndex] = (String)member.get(obj);
            ++index.stringIndex;
        }
        for (Field member : this.enumMember) {
            intPayload[index.intIndex] = ((Enum)member.get(obj)).ordinal();
            ++index.intIndex;
        }
        for (Field member : this.gameProfileMember) {
            GameProfile profile = (GameProfile)member.get(obj);
            UUID profileID = profile.getId();
            if (profileID == null) {
                profileID = new UUID(0L, 0L);
            }
            intPayload[index.intIndex] = (int)profileID.getMostSignificantBits() >>> 32;
            intPayload[index.intIndex + 1] = (int)profileID.getMostSignificantBits();
            intPayload[index.intIndex + 2] = (int)profileID.getLeastSignificantBits() >>> 32;
            intPayload[index.intIndex + 3] = (int)profileID.getLeastSignificantBits();
            index.intIndex += 4;
            stringPayload[index.stringIndex] = profile.getName();
            ++index.stringIndex;
        }
        for (ClassMap submap : this.objectMember) {
            Object source = submap.field.get(obj);
            if (source == null) {
                intPayload[index.intIndex] = 0;
                ++index.intIndex;
                index.intIndex += submap.intSize;
                index.floatIndex += submap.floatSize;
                index.stringIndex += submap.stringSize;
                continue;
            }
            intPayload[index.intIndex] = 1;
            ++index.intIndex;
            submap.setData(source, intPayload, floatPayload, stringPayload, index);
        }
    }

    public void fromData(Object obj, int[] intPayload, float[] floatPayload, String[] stringPayload, IndexInPayload index) throws IllegalAccessException {
        for (Field member : this.intMember) {
            member.setInt(obj, intPayload[index.intIndex]);
            ++index.intIndex;
        }
        for (Field member : this.booleanMember) {
            member.setBoolean(obj, intPayload[index.intIndex] == 1);
            ++index.intIndex;
        }
        for (Field member : this.enumMember) {
            member.set(obj, ((Class)member.getGenericType()).getEnumConstants()[intPayload[index.intIndex]]);
            ++index.intIndex;
        }
        for (Field member : this.floatMember) {
            member.setFloat(obj, floatPayload[index.floatIndex]);
            ++index.floatIndex;
        }
        for (Field member : this.stringMember) {
            member.set(obj, stringPayload[index.stringIndex]);
            ++index.stringIndex;
        }
        for (Field member : this.gameProfileMember) {
            GameProfile profile = new GameProfile(new UUID((long)intPayload[index.intIndex] << 32 | (long)intPayload[index.intIndex + 1], (long)intPayload[index.intIndex + 2] << 32 | (long)intPayload[index.intIndex + 3]), stringPayload[index.stringIndex]);
            index.intIndex += 4;
            ++index.stringIndex;
            member.set(obj, profile);
        }
        for (ClassMap map : this.objectMember) {
            boolean isNull = intPayload[index.intIndex] == 0;
            ++index.intIndex;
            if (isNull) {
                index.intIndex += map.intSize;
                index.floatIndex += map.floatSize;
                index.stringIndex += map.stringSize;
                continue;
            }
            map.field.get(obj);
            map.fromData(map.field.get(obj), intPayload, floatPayload, stringPayload, index);
        }
    }

    public ClassMap(Class targetClass) {
        Field[] fields = targetClass.getDeclaredFields();
        try {
            for (Field field : fields) {
                if (!this.isNetworkedMember(field)) continue;
                field.setAccessible(true);
                Type type = field.getGenericType();
                if (type instanceof Class && !((Class)type).isArray()) {
                    Class memberClass = (Class)type;
                    if (memberClass.equals(Integer.TYPE)) {
                        ++this.intSize;
                        this.intMember.add(field);
                        continue;
                    }
                    if (memberClass.equals(Float.TYPE)) {
                        ++this.floatSize;
                        this.floatMember.add(field);
                        continue;
                    }
                    if (memberClass.equals(Boolean.TYPE)) {
                        ++this.intSize;
                        this.booleanMember.add(field);
                        continue;
                    }
                    if (memberClass.equals(String.class)) {
                        ++this.stringSize;
                        this.stringMember.add(field);
                        continue;
                    }
                    if (Enum.class.isAssignableFrom(memberClass)) {
                        ++this.intSize;
                        this.enumMember.add(field);
                        continue;
                    }
                    if (GameProfile.class.isAssignableFrom(memberClass)) {
                        this.intSize += 4;
                        ++this.stringSize;
                        this.gameProfileMember.add(field);
                        continue;
                    }
                    ClassMap mapper = new ClassMap(memberClass);
                    mapper.field = field;
                    this.objectMember.add(mapper);
                    ++this.intSize;
                    this.intSize += mapper.intSize;
                    this.floatSize += mapper.floatSize;
                    this.stringSize += mapper.stringSize;
                    continue;
                }
                if (!(type instanceof Class) || !((Class)type).isArray()) continue;
                throw new RuntimeException("Tried to map class " + targetClass.toString() + " but it requested mapping of an array. Not handled!");
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private boolean isNetworkedMember(Field member) {
        return member.getAnnotation(EntityNetData.class) != null;
    }
}

