/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import cpw.mods.fml.common.registry.GameData;
import forestry.core.network.ForestryPacket;
import forestry.core.proxy.Proxies;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class PacketFXSignal
extends ForestryPacket {
    private VisualFXType visualFX;
    private SoundFXType soundFX;
    private int xCoord;
    private int yCoord;
    private int zCoord;
    private Block block;
    private int meta;

    public PacketFXSignal() {
    }

    public PacketFXSignal(VisualFXType type, int xCoord, int yCoord, int zCoord, Block block, int meta) {
        this(type, SoundFXType.NONE, xCoord, yCoord, zCoord, block, meta);
    }

    public PacketFXSignal(SoundFXType type, int xCoord, int yCoord, int zCoord, Block block, int meta) {
        this(VisualFXType.NONE, type, xCoord, yCoord, zCoord, block, meta);
    }

    public PacketFXSignal(VisualFXType visualFX, SoundFXType soundFX, int xCoord, int yCoord, int zCoord, Block block, int meta) {
        super(4);
        this.visualFX = visualFX;
        this.soundFX = soundFX;
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.block = block;
        this.meta = meta;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeShort(this.visualFX.ordinal());
        data.writeShort(this.soundFX.ordinal());
        data.writeInt(this.xCoord);
        data.writeInt(this.yCoord);
        data.writeInt(this.zCoord);
        data.writeUTF(GameData.getBlockRegistry().func_148750_c((Object)this.block));
        data.writeInt(this.meta);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        this.visualFX = VisualFXType.values()[data.readShort()];
        this.soundFX = SoundFXType.values()[data.readShort()];
        this.xCoord = data.readInt();
        this.yCoord = data.readInt();
        this.zCoord = data.readInt();
        this.block = (Block)GameData.getBlockRegistry().getRaw(data.readUTF());
        this.meta = data.readInt();
    }

    public void executeFX() {
        if (this.visualFX != VisualFXType.NONE) {
            Proxies.common.addBlockDestroyEffects(Proxies.common.getRenderWorld(), this.xCoord, this.yCoord, this.zCoord, this.block, this.meta);
        }
        if (this.soundFX != SoundFXType.NONE) {
            if (this.soundFX == SoundFXType.BLOCK_DESTROY) {
                Proxies.common.playBlockBreakSoundFX(Proxies.common.getRenderWorld(), this.xCoord, this.yCoord, this.zCoord, this.block);
            } else if (this.soundFX == SoundFXType.BLOCK_PLACE) {
                Proxies.common.playBlockPlaceSoundFX(Proxies.common.getRenderWorld(), this.xCoord, this.yCoord, this.zCoord, this.block);
            } else {
                World world = Proxies.common.getRenderWorld();
                String string = this.soundFX.soundFile;
                ((Object)((Object)this.soundFX)).getClass();
                ((Object)((Object)this.soundFX)).getClass();
                Proxies.common.playSoundFX(world, this.xCoord, this.yCoord, this.zCoord, string, 1.0f, 1.0f);
            }
        }
    }

    public static enum SoundFXType {
        NONE(""),
        BLOCK_DESTROY(""),
        BLOCK_PLACE(""),
        LEAF("step.grass"),
        LOG("dig.wood"),
        DIRT("dig.gravel");

        public final String soundFile;
        public final float volume = 1.0f;
        public final float pitch = 1.0f;

        private SoundFXType(String soundFile) {
            this.soundFile = soundFile;
        }
    }

    public static enum VisualFXType {
        NONE,
        BLOCK_DESTROY,
        SAPLING_PLACE;

    }
}

