/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.core.interfaces.IBlockRenderer;
import forestry.core.interfaces.IRenderableMachine;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.ForestryResource;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderMachine
extends TileEntitySpecialRenderer
implements IBlockRenderer {
    private final ModelBase model = new ModelBase(){};
    private final ModelRenderer basefront = new ModelRenderer(this.model, 0, 0);
    private final ModelRenderer baseback;
    private final ModelRenderer resourceTank;
    private final ModelRenderer productTank;
    private ResourceLocation[] textures;

    public RenderMachine() {
        this.basefront.func_78789_a(-8.0f, -8.0f, -8.0f, 16, 4, 16);
        this.basefront.field_78800_c = 8.0f;
        this.basefront.field_78797_d = 8.0f;
        this.basefront.field_78798_e = 8.0f;
        this.baseback = new ModelRenderer(this.model, 0, 0);
        this.baseback.func_78789_a(-8.0f, 4.0f, -8.0f, 16, 4, 16);
        this.baseback.field_78800_c = 8.0f;
        this.baseback.field_78797_d = 8.0f;
        this.baseback.field_78798_e = 8.0f;
        this.resourceTank = new ModelRenderer(this.model, 0, 0);
        this.resourceTank.func_78789_a(-6.0f, -8.0f, -6.0f, 12, 16, 6);
        this.resourceTank.field_78800_c = 8.0f;
        this.resourceTank.field_78797_d = 8.0f;
        this.resourceTank.field_78798_e = 8.0f;
        this.productTank = new ModelRenderer(this.model, 0, 0);
        this.productTank.func_78789_a(-6.0f, -8.0f, 0.0f, 12, 16, 6);
        this.productTank.field_78800_c = 8.0f;
        this.productTank.field_78797_d = 8.0f;
        this.productTank.field_78798_e = 8.0f;
    }

    public RenderMachine(String baseTexture) {
        this();
        this.textures = new ResourceLocation[]{new ForestryResource(baseTexture + "base.png"), new ForestryResource(baseTexture + "tank_resource_empty.png"), new ForestryResource(baseTexture + "tank_resource_low.png"), new ForestryResource(baseTexture + "tank_resource_medium.png"), new ForestryResource(baseTexture + "tank_resource_high.png"), new ForestryResource(baseTexture + "tank_resource_maximum.png"), new ForestryResource(baseTexture + "tank_product_empty.png"), new ForestryResource(baseTexture + "tank_product_low.png"), new ForestryResource(baseTexture + "tank_product_medium.png"), new ForestryResource(baseTexture + "tank_product_high.png"), new ForestryResource(baseTexture + "tank_product_maximum.png")};
    }

    @Override
    public void inventoryRender(double x, double y, double z, float f, float f1) {
        this.render(EnumTankLevel.EMPTY, EnumTankLevel.EMPTY, ForgeDirection.UP, x, y, z);
    }

    public void func_147500_a(TileEntity tileentity, double d, double d1, double d2, float f) {
        IRenderableMachine generator = (IRenderableMachine)tileentity;
        this.render(generator.getPrimaryLevel(), generator.getSecondaryLevel(), generator.getOrientation(), d, d1, d2);
    }

    private void render(EnumTankLevel waterLevel, EnumTankLevel melangeLevel, ForgeDirection orientation, double x, double y, double z) {
        this.render(waterLevel.ordinal(), melangeLevel.ordinal(), orientation, x, y, z);
    }

    public void render(int waterLevelInt, int melangeLevelInt, ForgeDirection orientation, double x, double y, double z) {
        ResourceLocation texture;
        EnumTankLevel waterLevel = EnumTankLevel.values()[waterLevelInt];
        EnumTankLevel melangeLevel = EnumTankLevel.values()[melangeLevelInt];
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        float[] translate = new float[]{0.0f, 0.0f, 0.0f};
        if (orientation == null) {
            orientation = ForgeDirection.WEST;
        }
        switch (orientation) {
            case EAST: {
                angle[1] = (float)Math.PI;
                angle[2] = -1.5707964f;
                translate[0] = 1.0f;
                break;
            }
            case WEST: {
                angle[2] = 1.5707964f;
                translate[0] = -1.0f;
                break;
            }
            case UP: {
                translate[1] = 1.0f;
                break;
            }
            case DOWN: {
                angle[2] = (float)Math.PI;
                translate[1] = -1.0f;
                break;
            }
            case SOUTH: {
                angle[0] = 1.5707964f;
                angle[2] = 1.5707964f;
                translate[2] = 1.0f;
                break;
            }
            default: {
                angle[0] = -1.5707964f;
                angle[2] = 1.5707964f;
                translate[2] = -1.0f;
            }
        }
        this.basefront.field_78795_f = angle[0];
        this.basefront.field_78796_g = angle[1];
        this.basefront.field_78808_h = angle[2];
        this.baseback.field_78795_f = angle[0];
        this.baseback.field_78796_g = angle[1];
        this.baseback.field_78808_h = angle[2];
        this.resourceTank.field_78795_f = angle[0];
        this.resourceTank.field_78796_g = angle[1];
        this.resourceTank.field_78808_h = angle[2];
        this.productTank.field_78795_f = angle[0];
        this.productTank.field_78796_g = angle[1];
        this.productTank.field_78808_h = angle[2];
        float factor = 0.0625f;
        Proxies.common.bindTexture(this.textures[Textures.BASE.ordinal()]);
        this.basefront.func_78785_a(factor);
        Proxies.common.bindTexture(this.textures[Textures.BASE.ordinal()]);
        this.baseback.func_78785_a(factor);
        switch (waterLevel) {
            case LOW: {
                texture = this.textures[Textures.TANK_R_LOW.ordinal()];
                break;
            }
            case MEDIUM: {
                texture = this.textures[Textures.TANK_R_MEDIUM.ordinal()];
                break;
            }
            case HIGH: {
                texture = this.textures[Textures.TANK_R_HIGH.ordinal()];
                break;
            }
            case MAXIMUM: {
                texture = this.textures[Textures.TANK_R_MAXIMUM.ordinal()];
                break;
            }
            default: {
                texture = this.textures[Textures.TANK_R_EMPTY.ordinal()];
            }
        }
        Proxies.common.bindTexture(texture);
        this.resourceTank.func_78785_a(factor);
        switch (melangeLevel) {
            case LOW: {
                texture = this.textures[Textures.TANK_P_LOW.ordinal()];
                break;
            }
            case MEDIUM: {
                texture = this.textures[Textures.TANK_P_MEDIUM.ordinal()];
                break;
            }
            case HIGH: {
                texture = this.textures[Textures.TANK_P_HIGH.ordinal()];
                break;
            }
            case MAXIMUM: {
                texture = this.textures[Textures.TANK_P_MAXIMUM.ordinal()];
                break;
            }
            default: {
                texture = this.textures[Textures.TANK_P_EMPTY.ordinal()];
            }
        }
        Proxies.common.bindTexture(texture);
        this.productTank.func_78785_a(factor);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    private static enum Textures {
        BASE,
        TANK_R_EMPTY,
        TANK_R_LOW,
        TANK_R_MEDIUM,
        TANK_R_HIGH,
        TANK_R_MAXIMUM,
        TANK_P_EMPTY,
        TANK_P_LOW,
        TANK_P_MEDIUM,
        TANK_P_HIGH,
        TANK_P_MAXIMUM;

    }
}

