/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IIconProvider;
import forestry.api.core.ITextureManager;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;

@SideOnly(value=Side.CLIENT)
public class TextureManager
implements ITextureManager {
    private static TextureManager instance;
    String[] defaultIconNames = new String[]{"habitats/desert", "habitats/end", "habitats/forest", "habitats/hills", "habitats/jungle", "habitats/mushroom", "habitats/nether", "habitats/ocean", "habitats/plains", "habitats/snow", "habitats/swamp", "habitats/taiga", "misc/access.private", "misc/access.viewable", "misc/access.shared", "misc/energy", "misc/hint", "analyzer/anything", "analyzer/bee", "analyzer/cave", "analyzer/closed", "analyzer/drone", "analyzer/flyer", "analyzer/item", "analyzer/nocturnal", "analyzer/princess", "analyzer/pure_breed", "analyzer/pure_cave", "analyzer/pure_flyer", "analyzer/pure_nocturnal", "analyzer/queen", "particles/ember", "particles/flame", "particles/poison", "particles/swarm_bee", "errors/errored", "slots/blocked", "slots/blocked_2", "slots/liquid", "slots/container", "slots/locked", "mail/carrier.player", "mail/carrier.trader"};
    HashMap<String, IIcon> defaultIcons = new HashMap();
    IIcon[] textures = new IIcon[2048];
    ArrayList<IIconProvider> iconProvider = new ArrayList();

    public static TextureManager getInstance() {
        if (instance == null) {
            instance = new TextureManager();
            ForestryAPI.textureManager = instance;
        }
        return instance;
    }

    public void initDefaultIcons(IIconRegister register) {
        for (String str : this.defaultIconNames) {
            this.defaultIcons.put(str, TextureManager.getInstance().registerTex(register, str));
        }
    }

    @Override
    public IIcon getDefault(String ident) {
        if (this.defaultIcons.containsKey(ident)) {
            return this.defaultIcons.get(ident);
        }
        return null;
    }

    public IIcon registerTex(IIconRegister register, String identifier) {
        return register.func_94245_a("forestry:" + identifier);
    }

    public IIcon registerTexUID(IIconRegister register, short uid, String identifier) {
        return this.setTexUID(uid, this.registerTex(register, identifier));
    }

    public IIcon setTexUID(short uid, IIcon texture) {
        this.textures[uid] = texture;
        return texture;
    }

    @Override
    public void registerIconProvider(IIconProvider provider) {
        this.iconProvider.add(provider);
    }

    @Override
    public IIcon getIcon(short texUID) {
        if (texUID < this.textures.length) {
            return this.textures[texUID];
        }
        for (IIconProvider provider : this.iconProvider) {
            IIcon retr = provider.getIcon(texUID);
            if (retr == null) continue;
            return retr;
        }
        return null;
    }
}

