/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import buildcraft.api.core.Position;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import forestry.core.utils.Vect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockLog;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockUtil {
    public static ArrayList<ItemStack> getBlockItemStack(World world, Vect posBlock) {
        Block block = world.func_147439_a(posBlock.x, posBlock.y, posBlock.z);
        int meta = world.func_72805_g(posBlock.x, posBlock.y, posBlock.z);
        return block.getDrops(world, posBlock.x, posBlock.y, posBlock.z, meta, 0);
    }

    public static IInventory[] getAdjacentInventories(World world, Vect blockPos, ForgeDirection from) {
        ArrayList<IInventory> inventories = new ArrayList<IInventory>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity entity;
            if (from != ForgeDirection.UNKNOWN && from != dir.getOpposite() || (entity = world.func_147438_o(blockPos.x + dir.offsetX, blockPos.y + dir.offsetY, blockPos.z + dir.offsetZ)) == null || !(entity instanceof IInventory) || entity instanceof TileEntityHopper || entity instanceof IPowerReceptor) continue;
            inventories.add((IInventory)entity);
        }
        return inventories.toArray(new IInventory[inventories.size()]);
    }

    public static ForgeDirection[] getPipeDirections(World world, Vect blockPos, ForgeDirection from) {
        LinkedList<ForgeDirection> possiblePipes = new LinkedList<ForgeDirection>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (from != ForgeDirection.UNKNOWN && from != dir.getOpposite()) continue;
            Position posPipe = new Position(blockPos.x, blockPos.y, blockPos.z, dir);
            posPipe.moveForwards(1.0);
            TileEntity pipeEntry = world.func_147438_o((int)posPipe.x, (int)posPipe.y, (int)posPipe.z);
            if (!(pipeEntry instanceof IPipeTile)) continue;
            IPipeTile pipe = (IPipeTile)pipeEntry;
            if (from != ForgeDirection.UNKNOWN && pipeEntry instanceof IPipeConnection) {
                if (((IPipeConnection)pipeEntry).overridePipeConnection(IPipeTile.PipeType.ITEM, from) == IPipeConnection.ConnectOverride.DISCONNECT) continue;
                possiblePipes.add(dir);
                continue;
            }
            if (pipe.getPipeType() != IPipeTile.PipeType.ITEM || !pipe.isPipeConnected(dir.getOpposite())) continue;
            possiblePipes.add(dir);
        }
        return possiblePipes.toArray(new ForgeDirection[0]);
    }

    public static ArrayList<ForgeDirection> filterPipeDirections(ForgeDirection[] all, ForgeDirection[] exclude) {
        ArrayList<ForgeDirection> filtered = new ArrayList<ForgeDirection>();
        ArrayList<ForgeDirection> excludeList = new ArrayList<ForgeDirection>(Arrays.asList(exclude));
        for (int i = 0; i < all.length; ++i) {
            if (excludeList.contains(all[i])) continue;
            filtered.add(all[i]);
        }
        return filtered;
    }

    public static boolean putFromStackIntoPipe(TileEntity tile, ArrayList<ForgeDirection> pipes, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.field_77994_a <= 0) {
            return false;
        }
        if (pipes.size() <= 0) {
            return false;
        }
        int choice = tile.func_145831_w().field_73012_v.nextInt(pipes.size());
        Position itemPos = new Position(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, pipes.get(choice));
        itemPos.x += 0.5;
        itemPos.y += 0.25;
        itemPos.z += 0.5;
        itemPos.moveForwards(0.5);
        Position pipePos = new Position(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, pipes.get(choice));
        pipePos.moveForwards(1.0);
        IPipeTile pipe = (IPipeTile)tile.func_145831_w().func_147438_o((int)pipePos.x, (int)pipePos.y, (int)pipePos.z);
        ItemStack payload = stack.func_77979_a(1);
        if (pipe.injectItem(payload, true, itemPos.orientation.getOpposite()) > 0) {
            return true;
        }
        pipes.remove(choice);
        return false;
    }

    public static boolean isPoweredTile(ForgeDirection side, TileEntity tile) {
        if (tile == null) {
            return false;
        }
        if (!(tile instanceof IPowerReceptor)) {
            return false;
        }
        IPowerReceptor receptor = (IPowerReceptor)tile;
        return receptor.getPowerReceiver(side) != null;
    }

    public static boolean tryPlantPot(World world, int x, int y, int z, Block block) {
        int direction = BlockUtil.getDirectionalMetadata(world, x, y, z);
        if (direction < 0) {
            return false;
        }
        world.func_147465_d(x, y, z, block, direction, 2);
        return true;
    }

    public static int getDirectionalMetadata(World world, int x, int y, int z) {
        for (int i = 0; i < 4; ++i) {
            if (!BlockUtil.isValidPot(world, x, y, z, i)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isValidPot(World world, int x, int y, int z, int notchDirection) {
        Block block = world.func_147439_a(x += Direction.field_71583_a[notchDirection], y, z += Direction.field_71581_b[notchDirection]);
        if (block == Blocks.field_150364_r) {
            return BlockLog.func_150165_c((int)world.func_72805_g(x, y, z)) == 3;
        }
        return block.isWood((IBlockAccess)world, x, y, z);
    }

    public static int getMaturityPod(int metadata) {
        return BlockCocoa.func_149987_c((int)metadata);
    }
}

